/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.deserialize.binary;

import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.deserialize.FieldDeserializer;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializer;
import de.mein.core.serialize.exceptions.JsonDeserializationException;
import java.lang.reflect.Field;
import java.util.Base64;

public class BinaryDeserializer
implements FieldDeserializer {
    private static Base64Decoder base64Decoder = string -> Base64.getDecoder().decode(string);

    public static void setBase64Decoder(Base64Decoder base64Decoder) {
        BinaryDeserializer.base64Decoder = base64Decoder;
    }

    public static byte[] decode(String base64) {
        return base64Decoder.decode(base64);
    }

    @Override
    public Object deserialize(SerializableEntityDeserializer serializableEntityDeserializer, SerializableEntity entity, Field field, Class typeClass, Object value) throws IllegalAccessException, JsonDeserializationException {
        Class<?> fieldClass = field.getType();
        if (value != null) {
            byte[] decoded = BinaryDeserializer.decode(value.toString());
            field.set(entity, decoded);
            return decoded;
        }
        return null;
    }

    public static interface Base64Decoder {
        public byte[] decode(String var1);
    }
}

