/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.deserialize.collections;

import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.deserialize.FieldDeserializer;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializer;
import de.mein.core.serialize.exceptions.JsonDeserializationException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class SerializableEntityCollectionDeserializer
implements FieldDeserializer {
    public SerializableEntityCollectionDeserializer(SerializableEntityDeserializer rootDeserializer, Field field) {
    }

    public static <T> Collection createCollection(Class<T> type) throws JsonDeserializationException {
        if (List.class.isAssignableFrom(type)) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(type)) {
            return new HashSet();
        }
        throw new JsonDeserializationException("Could not instantiate a List or set given that Type: " + type);
    }

    @Override
    public Object deserialize(SerializableEntityDeserializer serializableEntityDeserializer, SerializableEntity entity, Field field, Class typeClass, Object jsonFieldValue) throws JsonDeserializationException, IllegalAccessException {
        if (jsonFieldValue != null) {
            ParameterizedType genericListType = (ParameterizedType)field.getGenericType();
            Class genericListClass = (Class)genericListType.getActualTypeArguments()[0];
            JSONArray jsonArray = (JSONArray)jsonFieldValue;
            int length = jsonArray.length();
            if (SerializableEntity.class.isAssignableFrom(genericListClass)) {
                Collection entities = SerializableEntityCollectionDeserializer.createCollection(field.getType());
                int i = 0;
                while (i < length) {
                    Object something = jsonArray.get(i);
                    JSONObject jsonObject = null;
                    if (!(something instanceof JSONObject.Null)) {
                        jsonObject = jsonArray.getJSONObject(i);
                    }
                    SerializableEntity arrEntity = serializableEntityDeserializer.buildEntity(jsonObject);
                    entities.add(arrEntity);
                    ++i;
                }
                field.set(entity, entities);
                return entities;
            }
        }
        return null;
    }
}

