/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.deserialize.map;

import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.deserialize.FieldDeserializer;
import de.mein.core.serialize.deserialize.FieldDeserializerFactory;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializer;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializerFactory;
import de.mein.core.serialize.deserialize.map.KeyDeserializer;
import de.mein.core.serialize.deserialize.map.KeyDeserializerFactory;
import de.mein.core.serialize.deserialize.primitive.PrimitiveDeserializer;
import de.mein.core.serialize.deserialize.primitive.PrimitiveDeserializerFactory;
import de.mein.core.serialize.exceptions.JsonDeserializationException;
import de.mein.core.serialize.serialize.reflection.FieldAnalyzer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class MapDeserializer
implements FieldDeserializer {
    private final SerializableEntityDeserializer rootDeserializer;
    private final Field field;

    public MapDeserializer(SerializableEntityDeserializer rootDeserializer, Field field) {
        this.rootDeserializer = rootDeserializer;
        this.field = field;
    }

    @Override
    public Object deserialize(SerializableEntityDeserializer serializableEntityDeserializer, SerializableEntity entity, Field field, Class typeClass, Object jsonFieldValue) throws IllegalAccessException, JsonDeserializationException {
        Type type = field.getGenericType();
        ParameterizedType pType = (ParameterizedType)type;
        Class clazzK = (Class)pType.getActualTypeArguments()[0];
        Class clazzV = (Class)pType.getActualTypeArguments()[1];
        KeyDeserializerFactory kFactory = new KeyDeserializerFactory(clazzK);
        FieldDeserializerFactory vFactory = this.createDeserializerFactory(clazzV);
        Map map = null;
        if (jsonFieldValue != null) {
            map = MapDeserializer.createMap(clazzK, clazzV);
            JSONObject jsonObject = (JSONObject)jsonFieldValue;
            JSONObject keyIdKeyJSONMap = jsonObject.getJSONObject("__x");
            HashMap<Integer, Object> keyIdKeyMap = new HashMap<Integer, Object>();
            Integer i = 0;
            while (i < keyIdKeyJSONMap.length()) {
                Object key = keyIdKeyJSONMap.get(i.toString());
                KeyDeserializer des = kFactory.createDeserializer(this.rootDeserializer);
                Object desKey = des.deserialize(this.rootDeserializer, null, null, key);
                keyIdKeyMap.put(i, desKey);
                i = i + 1;
            }
            JSONObject jsonMap = jsonObject.getJSONObject("__m");
            Integer keyId = 0;
            while (keyId < jsonMap.length()) {
                Object valObj = jsonMap.get(keyId.toString());
                Object key = keyIdKeyMap.get(keyId);
                Object val = null;
                FieldDeserializer valueDeserializer = vFactory.createDeserializer(this.rootDeserializer, null);
                val = valueDeserializer.deserialize(this.rootDeserializer, null, null, clazzV, valObj);
                map.put(key, val);
                keyId = keyId + 1;
            }
        }
        field.set(entity, map);
        return map;
    }

    private Object JSON2val(Class clazz, Object obj) {
        if (Number.class.isAssignableFrom(clazz) && !Number.class.isAssignableFrom(obj.getClass())) {
            obj = Double.parseDouble(obj.toString());
        }
        obj = PrimitiveDeserializer.JSON2Primtive(clazz, obj);
        return obj;
    }

    public static <K, V> Map<K, V> createMap(Class<K> classK, Class<V> classV) {
        HashMap map = new HashMap();
        return map;
    }

    private FieldDeserializerFactory createDeserializerFactory(Class clazz) {
        if (FieldAnalyzer.isPrimitiveClass(clazz)) {
            return new PrimitiveDeserializerFactory();
        }
        if (FieldAnalyzer.isEntitySerializableClass(clazz)) {
            return new SerializableEntityDeserializerFactory();
        }
        System.err.println("MapSerializer.createSerializerFactory: could not create Serializer for generic type: " + clazz.getName());
        return null;
    }
}

