/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.fieldserializer;

import de.mein.core.serialize.Serialize;
import de.mein.core.serialize.deserialize.FieldDeserializer;
import de.mein.core.serialize.deserialize.FieldDeserializerFactory;
import de.mein.core.serialize.deserialize.binary.BinaryDeserializerFactory;
import de.mein.core.serialize.deserialize.collections.PrimitiveCollectionDeserializerFactory;
import de.mein.core.serialize.deserialize.collections.SerializableEntityCollectionDeserializerFactory;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializer;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializerFactory;
import de.mein.core.serialize.deserialize.map.MapDeserializerFactory;
import de.mein.core.serialize.deserialize.primitive.PrimitiveDeserializerFactory;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializer;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.binary.BinarySerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.collections.PrimitiveCollectionSerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.collections.SerializableEntityCollectionSerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.map.MapSerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.primitive.PrimitiveFieldSerializerFactory;
import de.mein.core.serialize.serialize.reflection.FieldAnalyzer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FieldSerializerFactoryRepository {
    private static Map<Field, FieldSerializerFactory> fieldSerializerFactoryMap = new HashMap<Field, FieldSerializerFactory>();
    private static Map<Field, FieldDeserializerFactory> classIDeserializerFactoryMap = new HashMap<Field, FieldDeserializerFactory>();
    private static Set<FieldSerializerFactory> availableSerializationFactories = new HashSet<FieldSerializerFactory>();
    private static Set<FieldDeserializerFactory> availableDeserializationFactories = new HashSet<FieldDeserializerFactory>();

    static {
        FieldSerializerFactoryRepository.addAvailableSerializerFactory(PrimitiveFieldSerializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableSerializerFactory(BinarySerializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableSerializerFactory(SerializableEntitySerializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableSerializerFactory(SerializableEntityCollectionSerializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableSerializerFactory(PrimitiveCollectionSerializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableSerializerFactory(MapSerializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableDeserializerFactory(SerializableEntityDeserializerFactory.getIntance());
        FieldSerializerFactoryRepository.addAvailableDeserializerFactory(BinaryDeserializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableDeserializerFactory(PrimitiveDeserializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableDeserializerFactory(SerializableEntityCollectionDeserializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableDeserializerFactory(PrimitiveCollectionDeserializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableDeserializerFactory(MapDeserializerFactory.getInstance());
    }

    public static void addAvailableSerializerFactory(FieldSerializerFactory factory) {
        availableSerializationFactories.add(factory);
    }

    public static void bindClassAndSerializerFactory(Field field, FieldSerializerFactory factory) {
        fieldSerializerFactoryMap.put(field, factory);
    }

    public static void addAvailableDeserializerFactory(FieldDeserializerFactory factory) {
        availableDeserializationFactories.add(factory);
    }

    public static void bindClassAndDeserializerFactory(Field field, FieldDeserializerFactory factory) {
        classIDeserializerFactoryMap.put(field, factory);
    }

    public static void printSerializers() {
        Serialize.println("FieldSerializerFactoryRepository.printSerializers...");
        for (FieldSerializerFactory fieldSerializerFactory : availableSerializationFactories) {
            Serialize.println(fieldSerializerFactory.getClass());
        }
        Serialize.println("Deserializers...");
        for (FieldDeserializerFactory fieldDeserializerFactory : availableDeserializationFactories) {
            Serialize.println(fieldDeserializerFactory.getClass());
        }
        Serialize.println("FieldSerializerFactoryRepository.printSerializers.done");
    }

    public static FieldSerializer buildFieldSerializer(SerializableEntitySerializer parentSerializer, Field field) throws IllegalAccessException, JsonSerializationException {
        if (FieldAnalyzer.isJsonIgnored(field)) {
            return null;
        }
        Class<?> type = field.getType();
        if (fieldSerializerFactoryMap.containsKey(field)) {
            return fieldSerializerFactoryMap.get(field).createSerializer(parentSerializer, field);
        }
        for (FieldSerializerFactory factory : availableSerializationFactories) {
            if (!factory.canSerialize(field)) continue;
            FieldSerializerFactoryRepository.bindClassAndSerializerFactory(field, factory);
            return factory.createSerializer(parentSerializer, field);
        }
        return null;
    }

    public static FieldDeserializer buildFieldDeserializer(SerializableEntityDeserializer parentSerializer, Field field) {
        if (FieldAnalyzer.isJsonIgnored(field)) {
            return null;
        }
        if (classIDeserializerFactoryMap.containsKey(field)) {
            return classIDeserializerFactoryMap.get(field).createDeserializer(parentSerializer, field);
        }
        for (FieldDeserializerFactory factory : availableDeserializationFactories) {
            if (!factory.canDeserialize(field)) continue;
            FieldSerializerFactoryRepository.bindClassAndDeserializerFactory(field, factory);
            return factory.createDeserializer(parentSerializer, field);
        }
        return null;
    }
}

