/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.fieldserializer.binary;

import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializer;
import java.util.Base64;

public class BinaryFieldSerializer
extends FieldSerializer {
    private final byte[] bytes;
    private static Base64Encoder base64Encoder = bytes -> Base64.getEncoder().encode(bytes);

    public static void setBase64Encoder(Base64Encoder base64Encoder) {
        BinaryFieldSerializer.base64Encoder = base64Encoder;
    }

    public BinaryFieldSerializer(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public boolean isNull() {
        return this.bytes == null || this.bytes.length == 0;
    }

    @Override
    public String JSON() throws JsonSerializationException {
        String json = "\"" + new String(base64Encoder.encode(this.bytes)) + "\"";
        return json;
    }

    public static interface Base64Encoder {
        public byte[] encode(byte[] var1);
    }
}

