/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.fieldserializer.collections;

import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializer;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import de.mein.core.serialize.serialize.tools.StringBuilder;
import de.mein.core.serialize.serialize.trace.TraceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SerializableEntityCollectionSerializer
extends FieldSerializer {
    protected SerializableEntitySerializer parentSerializer;
    protected List<SerializableEntitySerializer> serializers = new ArrayList<SerializableEntitySerializer>();
    protected Iterable<? extends SerializableEntity> iterable;
    protected Integer traversalDepth;
    public static Comparator comparator;

    public SerializableEntityCollectionSerializer(SerializableEntitySerializer parentSerializer, Iterable<? extends SerializableEntity> iterable) {
        this.parentSerializer = parentSerializer;
        this.traversalDepth = parentSerializer.getTraversalDepth() - 1;
        this.iterable = iterable;
    }

    public void setTraversalDepth(Integer traversalDepth) {
        this.traversalDepth = traversalDepth;
    }

    public void setTraceManager(TraceManager traceManager) {
        this.parentSerializer.setTraceManager(traceManager);
    }

    @Override
    public boolean isNull() {
        return this.iterable == null || !this.iterable.iterator().hasNext();
    }

    @Override
    public String JSON() throws JsonSerializationException {
        Iterator<SerializableEntity> iterator;
        StringBuilder b2 = new StringBuilder().arrBegin();
        int count = 0;
        if (comparator != null) {
            Iterator<? extends SerializableEntity> iter = this.iterable.iterator();
            ArrayList<SerializableEntity> copy = new ArrayList<SerializableEntity>();
            while (iter.hasNext()) {
                copy.add(iter.next());
            }
            Collections.sort(copy, comparator);
            iterator = copy.iterator();
        } else {
            iterator = this.iterable.iterator();
        }
        iterator = this.iterable.iterator();
        while (iterator.hasNext()) {
            SerializableEntity entity = null;
            try {
                entity = iterator.next();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entity != null) {
                SerializableEntitySerializer serializer = this.parentSerializer.getPreparedSerializer(entity);
                serializer.setTraversalDepth(this.traversalDepth);
                b2.append(serializer.JSON());
            } else {
                b2.append("null");
            }
            if (iterator.hasNext()) {
                b2.comma();
            }
            ++count;
        }
        b2.arrEnd();
        return b2.toString();
    }
}

