/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.fieldserializer.entity;

import de.mein.core.serialize.EntityAnalyzer;
import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.EntitySerializerMap;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializer;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializerFactoryRepository;
import de.mein.core.serialize.serialize.reflection.FieldAnalyzer;
import de.mein.core.serialize.serialize.tools.StringBuilder;
import de.mein.core.serialize.serialize.trace.TraceManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableEntitySerializer
extends FieldSerializer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String ID = "$id";
    public static final String REF = "$ref";
    private Map<Long, SerializableEntity> idEntityMap = new HashMap<Long, SerializableEntity>();
    private Long refIdCount;
    private int traversalDepth = 2;
    private TraceManager traceManager = new TraceManager();
    private EntitySerializerMap existingSerializersMap = new EntitySerializerMap();
    private SerializableEntitySerializer parent;
    private Long refId;
    private SerializableEntity entity;
    private Map<Field, FieldSerializer> fieldValueMap = new HashMap<Field, FieldSerializer>();
    private List<Field> fields;
    private boolean jsonized = false;
    private boolean prepared = false;

    public SerializableEntitySerializer(TraceManager traceManager, SerializableEntity entity) throws IllegalArgumentException, IllegalAccessException {
        this.entity = entity;
        this.idEntityMap = new HashMap<Long, SerializableEntity>();
        this.refIdCount = 0L;
        this.traceManager = traceManager;
        this.refIdCount = 0L;
    }

    public static String serialize(SerializableEntity entity, int range) throws JsonSerializationException, IllegalAccessException {
        return SerializableEntitySerializer.serialize(entity, null, range);
    }

    public static String serialize(SerializableEntity entity) throws JsonSerializationException, IllegalAccessException {
        return SerializableEntitySerializer.serialize(entity, null, Integer.MAX_VALUE);
    }

    public static String serialize(SerializableEntity entity, TraceManager traceManager, int range) throws JsonSerializationException, IllegalAccessException {
        SerializableEntitySerializer serializer = new SerializableEntitySerializer().setTraceManager(traceManager);
        serializer.setEntity(entity).setTraversalDepth(range);
        return serializer.JSON();
    }

    public SerializableEntity getEntity() {
        return this.entity;
    }

    public SerializableEntitySerializer() {
        this.refIdCount = 0L;
    }

    public SerializableEntitySerializer(SerializableEntitySerializer parent, SerializableEntity entity) {
        this.idEntityMap = parent.idEntityMap;
        this.refIdCount = null;
        this.parent = parent;
        this.existingSerializersMap = parent.existingSerializersMap;
        this.traceManager = parent.traceManager;
        this.traversalDepth = parent.traversalDepth - 1;
        this.entity = entity;
        this.existingSerializersMap.put(this);
    }

    public void addFieldFieldSerializer(Field field, FieldSerializer serializer) {
        this.fieldValueMap.put(field, serializer);
    }

    public SerializableEntitySerializer getPreparedSerializer(SerializableEntity entity) throws JsonSerializationException {
        SerializableEntitySerializer serializer = this.existingSerializersMap.get(entity);
        if (serializer == null) {
            serializer = new SerializableEntitySerializer(this, entity);
            this.existingSerializersMap.put(serializer);
            serializer.prepare();
        } else if (serializer.traversalDepth < this.traversalDepth - 1) {
            serializer.setTraversalDepth(this.traversalDepth - 1);
            serializer.prepare();
        }
        return serializer;
    }

    public SerializableEntitySerializer setTraversalDepth(int traversalDepth) {
        this.traversalDepth = traversalDepth;
        this.prepared = false;
        return this;
    }

    private Long generateRefId() {
        if (this.parent != null) {
            return this.parent.generateRefId();
        }
        this.refIdCount = this.refIdCount + 1L;
        return this.refIdCount;
    }

    private void assignRefId() {
        if (this.refId == null) {
            this.refId = this.generateRefId();
        }
    }

    public TraceManager getTraceManager() {
        return this.traceManager;
    }

    private void prepare() throws JsonSerializationException {
        try {
            this.fields = EntityAnalyzer.getSerializableFields(this.entity);
            this.fieldValueMap.clear();
            this.prepared = true;
            this.traceManager.start(this.entity);
            this.existingSerializersMap.put(this);
            for (Field field : this.fields) {
                FieldSerializer fieldSerializer;
                if (field.getName().equals("this$0")) continue;
                this.traceManager.down(field);
                if ((this.traversalDepth != 0 || !FieldAnalyzer.isEntitySerializable(field) && !FieldAnalyzer.isEntitySerializableCollection(field) || this.traceManager.isForcedPath()) && (fieldSerializer = FieldSerializerFactoryRepository.buildFieldSerializer(this, field)) != null) {
                    this.fieldValueMap.put(field, fieldSerializer);
                }
                this.traceManager.up();
            }
        }
        catch (Exception e) {
            System.err.println("SerializableEntitySerializer.prepare()");
            e.printStackTrace();
            throw new JsonSerializationException(e);
        }
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String JSON() throws JsonSerializationException {
        try {
            StringBuilder b2 = new StringBuilder();
            SerializableEntitySerializer existingSerializer = this.existingSerializersMap.get(this.entity);
            if (existingSerializer != null && existingSerializer != this) {
                return existingSerializer.JSON();
            }
            if (!this.prepared) {
                this.prepare();
            }
            if (!this.jsonized) {
                this.jsonized = true;
                this.assignRefId();
                b2.objBegin().key(ID).eq().value(this.refId);
                String type = EntityAnalyzer.getType(this.entity);
                b2.comma().key("__type").eq().value(type);
                for (Field field : this.fields) {
                    FieldSerializer fieldSerializer = this.fieldValueMap.get(field);
                    if (fieldSerializer == null || fieldSerializer.isNull()) continue;
                    b2.comma();
                    b2.key(field.getName()).eq();
                    b2.append(fieldSerializer.JSON());
                }
                b2.objEnd();
            } else {
                b2.objBegin().key(REF).eq().value(this.refId).objEnd();
            }
            return b2.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JsonSerializationException(e);
        }
    }

    public String toString() {
        return "serialises a '" + EntityAnalyzer.getType(this.entity);
    }

    public SerializableEntitySerializer setTraceManager(TraceManager traceManager) {
        this.traceManager = traceManager;
        if (this.traceManager == null) {
            this.traceManager = new TraceManager();
        }
        return this;
    }

    public SerializableEntitySerializer setEntity(SerializableEntity entity) {
        if (this.entity != null) {
            this.existingSerializersMap.remove(this.entity);
        }
        this.entity = entity;
        this.prepared = false;
        return this;
    }

    public int getTraversalDepth() {
        return this.traversalDepth;
    }
}

