/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.fieldserializer.map;

import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializer;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import de.mein.core.serialize.serialize.reflection.FieldAnalyzer;

class KeySerializer
extends FieldSerializer {
    private final SerializableEntitySerializer parentSerializer;
    private final Object value;

    public KeySerializer(SerializableEntitySerializer parentSerializer, Object value) {
        this.parentSerializer = parentSerializer;
        this.value = value;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String JSON() throws JsonSerializationException {
        if (Number.class.isAssignableFrom(this.value.getClass())) {
            return this.value.toString();
        }
        if (String.class.isAssignableFrom(this.value.getClass())) {
            String res = this.value.toString();
            res = res.replaceAll("\"", "\\\"");
            return res;
        }
        if (SerializableEntity.class.isAssignableFrom(this.value.getClass())) {
            SerializableEntitySerializer serializer = this.parentSerializer.getPreparedSerializer((SerializableEntity)this.value);
            String json = serializer.JSON();
            return json;
        }
        System.err.println("KeySerializer.JSON.not.implemented.2");
        return null;
    }

    public boolean isPrimitive() {
        return this.value == null || FieldAnalyzer.isPrimitiveClass(this.value.getClass());
    }
}

