/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.fieldserializer.map;

import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializer;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.map.KeySerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.primitive.PrimitiveFieldSerializerFactory;
import de.mein.core.serialize.serialize.reflection.FieldAnalyzer;
import de.mein.core.serialize.serialize.tools.StringBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MapSerializer
extends FieldSerializer {
    private SerializableEntitySerializer parentSerializer;
    private Field field;
    private Map<?, ?> ins;

    public MapSerializer(SerializableEntitySerializer parentSerializer, Field field) throws IllegalAccessException {
        this.parentSerializer = parentSerializer;
        this.field = field;
        field.setAccessible(true);
        this.ins = (Map)field.get(parentSerializer.getEntity());
    }

    @Override
    public boolean isNull() {
        return this.ins == null;
    }

    @Override
    public String JSON() throws JsonSerializationException {
        Class<?> insClass = this.ins.getClass();
        Type type = this.field.getGenericType();
        ParameterizedType pType = (ParameterizedType)type;
        Class clazzK = (Class)pType.getActualTypeArguments()[0];
        Class clazzV = (Class)pType.getActualTypeArguments()[1];
        KeySerializerFactory kFactory = new KeySerializerFactory(this.parentSerializer);
        FieldSerializerFactory vFactory = this.createSerializerFactory(clazzV);
        boolean isFirst = true;
        StringBuilder b2 = new StringBuilder();
        b2.objBegin().key("__type").eq().value(insClass.getName()).comma().key("__k").eq().value(clazzK.getName()).comma().key("__v").eq().value(clazzV.getName()).comma().key("__x").eq().objBegin();
        HashSet keySet = new HashSet(this.ins.keySet());
        HashMap<Integer, Object> keyIdKeyMap = new HashMap<Integer, Object>();
        HashMap<Object, Integer> keyKeyIdMap = new HashMap<Object, Integer>();
        boolean appendComma = false;
        Integer keyIdInc = 0;
        Object[] objectArray = keySet.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object k = objectArray[n2];
            if (appendComma) {
                b2.comma();
            }
            keyIdKeyMap.put(keyIdInc, k);
            keyKeyIdMap.put(k, keyIdInc);
            b2.key(keyIdInc.toString()).eq();
            keyIdInc = keyIdInc + 1;
            if (k instanceof SerializableEntity) {
                SerializableEntitySerializer serializer = this.parentSerializer.getPreparedSerializer((SerializableEntity)k);
                b2.append(serializer.JSON());
            } else {
                b2.value(k);
            }
            appendComma = true;
            ++n2;
        }
        b2.objEnd().comma().key("__m").eq().objBegin();
        appendComma = false;
        for (Object key : keySet) {
            if (appendComma) {
                b2.comma();
            }
            appendComma = true;
            Integer keyId = (Integer)keyKeyIdMap.get(key);
            b2.key(keyId.toString()).eq();
            FieldSerializer vSer = vFactory.createSerializerOnClass(this.parentSerializer, this.ins.get(key));
            b2.append(vSer.JSON());
        }
        b2.objEnd().objEnd();
        return b2.toString();
    }

    private FieldSerializerFactory createSerializerFactory(Class clazz) {
        if (FieldAnalyzer.isPrimitiveClass(clazz)) {
            return new PrimitiveFieldSerializerFactory();
        }
        if (FieldAnalyzer.isEntitySerializableClass(clazz)) {
            return new SerializableEntitySerializerFactory();
        }
        System.err.println("MapSerializer.createSerializerFactory: could not create Serializer for generic type: " + clazz.getName());
        return null;
    }
}

