/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.fieldserializer.primitive;

import de.mein.core.serialize.serialize.fieldserializer.FieldSerializer;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializerFactory;
import de.mein.core.serialize.serialize.fieldserializer.NullSerializer;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import de.mein.core.serialize.serialize.fieldserializer.primitive.PrimitiveFieldSerializer;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

public class PrimitiveFieldSerializerFactory
implements FieldSerializerFactory {
    private static PrimitiveFieldSerializerFactory ins;
    private final Set<Class<?>> primitiveClasses = new HashSet();

    public PrimitiveFieldSerializerFactory() {
        Class<?>[] classArray = PrimitiveFieldSerializerFactory.getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            this.primitiveClasses.add(clazz);
            ++n2;
        }
    }

    public static PrimitiveFieldSerializerFactory getInstance() {
        if (ins == null) {
            ins = new PrimitiveFieldSerializerFactory();
        }
        return ins;
    }

    public static Class<?>[] getClasses() {
        return new Class[]{Byte.class, Byte.TYPE, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, String.class, Boolean.TYPE, Boolean.class};
    }

    @Override
    public FieldSerializer createSerializer(SerializableEntitySerializer parentSerializer, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        Object whatever = field.get(parentSerializer.getEntity());
        if (whatever == null) {
            return new NullSerializer();
        }
        return new PrimitiveFieldSerializer(whatever);
    }

    @Override
    public boolean canSerialize(Field field) {
        return this.primitiveClasses.contains(field.getType());
    }

    @Override
    public FieldSerializer createSerializerOnClass(SerializableEntitySerializer parentSerializer, Object value) {
        return new PrimitiveFieldSerializer(value);
    }
}

