/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.reflection;

import de.mein.core.serialize.JsonIgnore;
import de.mein.core.serialize.SerializableEntity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FieldAnalyzer {
    private static final Set<Class<?>> primitiveClasses;

    static {
        Class[] classes;
        primitiveClasses = new HashSet();
        Class[] classArray = classes = new Class[]{Byte.class, Byte.TYPE, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, String.class, Boolean.TYPE, Boolean.class};
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            primitiveClasses.add(clazz);
            ++n2;
        }
    }

    private FieldAnalyzer() {
    }

    private static Map<String, Field> getFields(Class clazz) {
        Field[] fields;
        HashMap<String, Field> result2 = new HashMap<String, Field>();
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            result2.putAll(FieldAnalyzer.getFields(superClazz));
        }
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers())) {
                result2.put(field.getName(), field);
            }
            ++n2;
        }
        return result2;
    }

    public static List<Field> collectFields(Class clazz) {
        Map<String, Field> fieldMap = FieldAnalyzer.getFields(clazz);
        ArrayList<Field> result2 = new ArrayList<Field>(fieldMap.values());
        return result2;
    }

    public static boolean isJsonIgnored(Field field) {
        Annotation[] annotations = field.getAnnotations();
        if (annotations != null) {
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType().equals(JsonIgnore.class)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return false;
    }

    public static boolean isCollectionClass(Class clazz) {
        boolean isCollection = Collection.class.isAssignableFrom(clazz);
        return isCollection;
    }

    public static boolean isPrimitiveCollection(Field field) {
        boolean isCollection = Collection.class.isAssignableFrom(field.getType());
        if (isCollection) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type whatEver = parameterizedType.getActualTypeArguments()[0];
            if (whatEver instanceof ParameterizedType) {
                return false;
            }
            Class genericType = (Class)whatEver;
            return FieldAnalyzer.isPrimitiveClass(genericType);
        }
        return false;
    }

    public static boolean isEntitySerializableCollection(Field field) {
        boolean isCollection = Collection.class.isAssignableFrom(field.getType());
        if (isCollection) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type whatEver = parameterizedType.getActualTypeArguments()[0];
            if (whatEver instanceof ParameterizedType) {
                return false;
            }
            Class genericType = (Class)whatEver;
            return SerializableEntity.class.isAssignableFrom(genericType);
        }
        return false;
    }

    public static boolean isCollectionOfClass(Class clazz, Field field) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type whatEver = parameterizedType.getActualTypeArguments()[0];
            if (whatEver instanceof ParameterizedType) {
                return false;
            }
            if (whatEver instanceof TypeVariable) {
                return false;
            }
            Class genericType = (Class)whatEver;
            return clazz.isAssignableFrom(genericType);
        }
        return false;
    }

    public static boolean isEntitySerializable(Field field) {
        Class<?> clazz = field.getType();
        return SerializableEntity.class.isAssignableFrom(clazz);
    }

    public static boolean isEntitySerializableClass(Class clazz) {
        return SerializableEntity.class.isAssignableFrom(clazz);
    }

    public static boolean isOfClass(Field field, Class expected) {
        Class<?> clazz = field.getType();
        return expected.isAssignableFrom(clazz);
    }

    public static boolean isPrimitiveClass(Class<?> type) {
        return primitiveClasses.contains(type);
    }

    public static boolean isPrimitive(Field field) {
        return FieldAnalyzer.isPrimitiveClass(field.getType());
    }

    public static boolean isPrimitiveMap(Field field) {
        boolean isMap = FieldAnalyzer.isMap(field);
        if (isMap) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type whatEver = parameterizedType.getActualTypeArguments()[0];
            if (whatEver instanceof ParameterizedType) {
                return false;
            }
            Class genericType = (Class)whatEver;
            return FieldAnalyzer.isPrimitiveClass(genericType);
        }
        return false;
    }

    public static boolean isMap(Field field) {
        boolean isMap = Map.class.isAssignableFrom(field.getType());
        return isMap;
    }

    public static boolean isTransinient(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }
}

