/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.reflection;

import de.mein.core.serialize.serialize.reflection.FieldAnalyzer;
import de.mein.core.serialize.serialize.reflection.classes.ReflectionTestPojo;
import java.lang.reflect.Field;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FieldAnalyzerTest {
    private Field fPrimitive;
    private Field fPrimitiveCollection;
    private Field fEntity;
    private Field fEntityCollection;
    private Field fTwoDimensionalList;
    private ReflectionTestPojo object;

    @Before
    public void prepare() {
        this.object = new ReflectionTestPojo();
        List<Field> fields = FieldAnalyzer.collectFields(this.object.getClass());
        this.fPrimitive = fields.stream().filter(f -> f.getName().equals("primitive")).findFirst().get();
        this.fPrimitiveCollection = fields.stream().filter(field -> field.getName().equals("primitiveCollection")).findFirst().get();
        this.fEntity = fields.stream().filter(field -> field.getName().equals("entity")).findFirst().get();
        this.fEntityCollection = fields.stream().filter(field -> field.getName().equals("entityCollection")).findFirst().get();
        this.fTwoDimensionalList = fields.stream().filter(field -> field.getName().equals("twoDimensionalList")).findFirst().get();
    }

    @Test
    public void primitive() {
        Assert.assertTrue(FieldAnalyzer.isPrimitive(this.fPrimitive));
        Assert.assertFalse(FieldAnalyzer.isEntitySerializable(this.fPrimitive));
        Assert.assertFalse(FieldAnalyzer.isPrimitiveCollection(this.fPrimitive));
        Assert.assertFalse(FieldAnalyzer.isEntitySerializableCollection(this.fPrimitive));
    }

    @Test
    public void primitiveCollection() {
        Assert.assertFalse(FieldAnalyzer.isPrimitive(this.fPrimitiveCollection));
        Assert.assertFalse(FieldAnalyzer.isEntitySerializable(this.fPrimitiveCollection));
        Assert.assertTrue(FieldAnalyzer.isPrimitiveCollection(this.fPrimitiveCollection));
        Assert.assertFalse(FieldAnalyzer.isEntitySerializableCollection(this.fPrimitiveCollection));
        Assert.assertFalse(FieldAnalyzer.isPrimitiveCollection(this.fEntityCollection));
    }

    @Test
    public void entitySerializable() {
        Assert.assertFalse(FieldAnalyzer.isPrimitive(this.fEntity));
        Assert.assertTrue(FieldAnalyzer.isEntitySerializable(this.fEntity));
        Assert.assertFalse(FieldAnalyzer.isPrimitiveCollection(this.fEntity));
        Assert.assertFalse(FieldAnalyzer.isEntitySerializableCollection(this.fEntity));
    }

    @Test
    public void entitySerializableCollection() {
        Assert.assertFalse(FieldAnalyzer.isPrimitive(this.fEntityCollection));
        Assert.assertFalse(FieldAnalyzer.isEntitySerializable(this.fEntityCollection));
        Assert.assertFalse(FieldAnalyzer.isPrimitiveCollection(this.fEntityCollection));
        Assert.assertTrue(FieldAnalyzer.isEntitySerializableCollection(this.fEntityCollection));
        Assert.assertFalse(FieldAnalyzer.isPrimitiveCollection(this.fEntityCollection));
        Assert.assertFalse(FieldAnalyzer.isPrimitiveCollection(this.fTwoDimensionalList));
    }
}

