/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.serializer;

import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.classes.BinarySerializableEntity;
import de.mein.core.serialize.classes.ChildSerializableEntity;
import de.mein.core.serialize.classes.SimpleSerializableEntity;
import de.mein.core.serialize.classes.WithPrimitiveCollection;
import de.mein.core.serialize.classes.WithSerializableEntityCollection;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializer;
import de.mein.core.serialize.exceptions.InvalidPathException;
import de.mein.core.serialize.exceptions.JsonDeserializationException;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import de.mein.core.serialize.serialize.trace.TraceManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class SerrTest {
    @Test
    public void set() throws JsonSerializationException, IllegalAccessException {
        S s = new S();
        s.set.add(new SimpleSerializableEntity().setPrimitive("bla"));
        String json = SerializableEntitySerializer.serialize(s);
        Assert.assertEquals("{\"$id\":1,\"__type\":\"de.mein.core.serialize.serialize.serializer.SerrTest$S\",\"set\":[{\"$id\":2,\"__type\":\"de.mein.core.serialize.classes.SimpleSerializableEntity\",\"primitive\":\"bla\"}]}", json);
    }

    @Test
    public void testTraversalDepthEntity() throws JsonSerializationException {
        ChildSerializableEntity parent = new ChildSerializableEntity();
        ChildSerializableEntity child = new ChildSerializableEntity();
        parent.setPrimitive("bla");
        parent.addChild(child);
        child.setParent(parent);
        child.setPrimitive("bla");
        SerializableEntitySerializer serializer = new SerializableEntitySerializer();
        serializer.setEntity(parent);
        serializer.setTraversalDepth(0);
        String json = serializer.JSON();
        Assert.assertEquals("{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"primitive\":\"bla\"}", json);
        serializer = new SerializableEntitySerializer();
        serializer.setEntity(parent);
        serializer.setTraversalDepth(1);
        json = serializer.JSON();
        System.out.println(json);
        Assert.assertEquals("{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"primitive\":\"bla\",\"children\":[{\"$id\":2,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"primitive\":\"bla\"}]}", json);
        System.out.println("SerializationTest.testTraversalDepth");
    }

    private void extendLeDirectory(ChildSerializableEntity dir, int depth) {
        if (depth >= 0) {
            ChildSerializableEntity sub = new ChildSerializableEntity();
            sub.setPrimitive("sub." + depth);
            sub.setParent(dir);
            dir.addChild(sub);
            this.extendLeDirectory(sub, --depth);
        }
    }

    @Test
    public void testTrace() throws JsonSerializationException, InvalidPathException {
        ChildSerializableEntity root = new ChildSerializableEntity();
        this.extendLeDirectory(root, 5);
        SerializableEntitySerializer serializer = new SerializableEntitySerializer();
        serializer.setEntity(root);
        serializer.setTraversalDepth(0);
        TraceManager traceManager = new TraceManager().addForcedPath("[de.mein.core.serialize.classes.ChildSerializableEntity].children");
        serializer.setTraceManager(traceManager);
        String json = serializer.JSON();
        String expected = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"children\":[{\"$id\":2,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"parent\":{\"$ref\":1},\"primitive\":\"sub.5\",\"children\":[{\"$id\":3,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"parent\":{\"$ref\":2},\"primitive\":\"sub.4\",\"children\":[{\"$id\":4,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"parent\":{\"$ref\":3},\"primitive\":\"sub.3\",\"children\":[{\"$id\":5,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"parent\":{\"$ref\":4},\"primitive\":\"sub.2\",\"children\":[{\"$id\":6,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"parent\":{\"$ref\":5},\"primitive\":\"sub.1\",\"children\":[{\"$id\":7,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"parent\":{\"$ref\":6},\"primitive\":\"sub.0\"}]}]}]}]}]}]}";
        Assert.assertEquals(expected, json);
        System.out.println("SerializationTest.testTraversalDepth");
    }

    @Test
    public void testWithEntitySerializableCollection() {
        WithSerializableEntityCollection withEntitySerializableCollection = new WithSerializableEntityCollection();
        ChildSerializableEntity pairSerializable = new ChildSerializableEntity();
        pairSerializable.setPrimitive("some test");
        withEntitySerializableCollection.entityserializables.add(pairSerializable);
        withEntitySerializableCollection.entityserializables.add(new WithPrimitiveCollection());
        String json = SerrTest.serialize(withEntitySerializableCollection);
        String result2 = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.WithSerializableEntityCollection\",\"primitive\":\"primitive\",\"entityserializables\":[{\"$id\":2,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"primitive\":\"some test\"},{\"$id\":3,\"__type\":\"de.mein.core.serialize.classes.WithPrimitiveCollection\",\"strings\":[],\"primitive\":\"primitive\"}]}";
        System.out.println("should");
        System.out.println(result2);
        System.out.println("is");
        System.out.println(json);
        Assert.assertEquals(result2, json);
    }

    @Test
    public void testWithEmptyEntitySerializableCollection() {
        WithSerializableEntityCollection withEntitySerializableCollection = new WithSerializableEntityCollection();
        String json = SerrTest.serialize(withEntitySerializableCollection);
        String result2 = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.WithSerializableEntityCollection\",\"primitive\":\"primitive\"}";
        Assert.assertEquals(result2, json);
    }

    @Test
    public void primitiveNull() {
        ChildSerializableEntity root = new ChildSerializableEntity();
        String json = SerrTest.serialize(root);
        System.out.println("is");
        System.out.println(json);
        String result2 = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\"}";
        System.out.println("should");
        System.out.println(result2);
        Assert.assertTrue(result2.equals(json));
    }

    @Test
    public void listWithNull() {
        WithSerializableEntityCollection listi = new WithSerializableEntityCollection();
        listi.entityserializables.add(null);
        listi.entityserializables.add(null);
        listi.entityserializables.add(new SimpleSerializableEntity());
        String json = SerrTest.serialize(listi);
        Assert.assertEquals("{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.WithSerializableEntityCollection\",\"primitive\":\"primitive\",\"entityserializables\":[null,null,{\"$id\":2,\"__type\":\"de.mein.core.serialize.classes.SimpleSerializableEntity\"}]}", json);
    }

    @Test
    public void primitive() {
        ChildSerializableEntity root = new ChildSerializableEntity();
        root.setPrimitive("testi");
        String json = SerrTest.serialize(root);
        System.out.println("is");
        System.out.println(json);
        String result2 = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"primitive\":\"testi\"}";
        System.out.println("should");
        System.out.println(result2);
        Assert.assertEquals(result2, json);
    }

    @Test
    public void ring() {
        SimpleSerializableEntity root = new SimpleSerializableEntity();
        SimpleSerializableEntity child = new SimpleSerializableEntity();
        child.setPrimitive("child");
        root.setPrimitive("root");
        root.out = child;
        child.in = root;
        child.out = root;
        root.in = child;
        String json = SerrTest.serialize(child);
        String result2 = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.SimpleSerializableEntity\",\"primitive\":\"child\",\"in\":{\"$id\":2,\"__type\":\"de.mein.core.serialize.classes.SimpleSerializableEntity\",\"primitive\":\"root\",\"in\":{\"$ref\":1},\"out\":{\"$ref\":1}},\"out\":{\"$ref\":2}}";
        Assert.assertEquals(result2, json);
    }

    @Test
    public void rootContainsChildContainsRoot() {
        SimpleSerializableEntity root = new SimpleSerializableEntity();
        SimpleSerializableEntity child = new SimpleSerializableEntity();
        child.setPrimitive("child");
        root.setPrimitive("root");
        root.out = child;
        child.in = root;
        child.out = root;
        String json = SerrTest.serialize(root);
        String result2 = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.SimpleSerializableEntity\",\"primitive\":\"root\",\"out\":{\"$id\":2,\"__type\":\"de.mein.core.serialize.classes.SimpleSerializableEntity\",\"primitive\":\"child\",\"in\":{\"$ref\":1},\"out\":{\"$ref\":1}}}";
        Assert.assertEquals(result2, json);
    }

    @Test
    public void childContainsRootInList() {
        ChildSerializableEntity root = new ChildSerializableEntity();
        ChildSerializableEntity child = new ChildSerializableEntity();
        child.setPrimitive("child");
        root.setPrimitive("root");
        root.addChild(child);
        child.setParent(root);
        String json = SerrTest.serialize(child);
        String result2 = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"parent\":{\"$id\":2,\"__type\":\"de.mein.core.serialize.classes.ChildSerializableEntity\",\"primitive\":\"root\",\"children\":[{\"$ref\":1}]},\"primitive\":\"child\"}";
        Assert.assertEquals(result2, json);
    }

    public static String serialize(SerializableEntity serializable) {
        SerializableEntitySerializer serializer = new SerializableEntitySerializer();
        serializer.setEntity(serializable);
        try {
            return serializer.JSON();
        }
        catch (JsonSerializationException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Test
    public void mapEntityAsKey() throws JsonSerializationException, IllegalAccessException {
        class MapTest
        implements SerializableEntity {
            private Map<SerializableEntity, Long> map = new HashMap<SerializableEntity, Long>();

            MapTest() {
            }
        }
        MapTest mapTest = new MapTest();
        SimpleSerializableEntity key = new SimpleSerializableEntity();
        mapTest.map.put(key, 666L);
        String json = SerializableEntitySerializer.serialize(mapTest);
        System.out.println(json);
        String expected = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.serialize.serializer.SerrTest$1MapTest\",\"map\":{\"__type\":\"java.util.HashMap\",\"__k\":\"de.mein.core.serialize.SerializableEntity\",\"__v\":\"java.lang.Long\",\"__x\":{\"0\":{\"$id\":2,\"__type\":\"de.mein.core.serialize.classes.SimpleSerializableEntity\"}},\"__m\":{\"0\":666}}}";
        Assert.assertEquals(expected, json);
    }

    @Test
    public void mapEntityOnItself() throws JsonSerializationException, IllegalAccessException, JsonDeserializationException {
        MapTestE mapTest = new MapTestE();
        B key = new B();
        mapTest.map.put(key, key);
        String json = SerializableEntitySerializer.serialize(mapTest);
        System.out.println(json);
        String expected = "{\"$id\":1,\"__type\":\"de.mein.core.serialize.serialize.serializer.SerrTest$MapTestE\",\"map\":{\"__type\":\"java.util.HashMap\",\"__k\":\"de.mein.core.serialize.SerializableEntity\",\"__v\":\"de.mein.core.serialize.SerializableEntity\",\"__x\":{\"0\":{\"$id\":2,\"__type\":\"de.mein.core.serialize.serialize.serializer.SerrTest$B\",\"primitive\":\"BBB\"}},\"__m\":{\"0\":{\"$ref\":2}}}}";
        Assert.assertEquals(expected, json);
        SerializableEntity o = SerializableEntityDeserializer.deserialize(json);
        System.out.println(o);
    }

    @Test
    public void mapInverse() throws JsonSerializationException, IllegalAccessException, JsonDeserializationException {
        EntityMapTest mapTest = new EntityMapTest();
        B key = new B();
        mapTest.inverse.put(key, 3);
        mapTest.map = null;
        String json = SerializableEntitySerializer.serialize(mapTest);
        System.out.println(json);
        SerializableEntity o = SerializableEntityDeserializer.deserialize(json);
        System.out.println(o);
    }

    @Test
    public void mapTestEntity() throws JsonSerializationException, IllegalAccessException, JsonDeserializationException {
        EntityMapTest mapTest = new EntityMapTest();
        B key = new B();
        B value = new B();
        mapTest.map.put(1, value);
        mapTest.map.put(2, value);
        mapTest.inverse.put(key, 3);
        mapTest.inverse.put(key, 4);
        String json = SerializableEntitySerializer.serialize(mapTest);
        System.out.println(json);
        SerializableEntity o = SerializableEntityDeserializer.deserialize(json);
        System.out.println(o);
    }

    @Test
    public void mapTestPrimitive() throws JsonSerializationException, IllegalAccessException, JsonDeserializationException {
        SimpleMapTest mapTest = new SimpleMapTest();
        mapTest.map.put(1, "one");
        mapTest.map.put(2, "two");
        mapTest.inverse.put("three", 3);
        mapTest.inverse.put("four", 4);
        String json = SerializableEntitySerializer.serialize(mapTest);
        System.out.println(json);
        SimpleMapTest des = (SimpleMapTest)SerializableEntityDeserializer.deserialize(json);
        System.out.println("SerrTest.mapTestPrimitive");
        Assert.assertEquals("one", des.map.get(1));
        Assert.assertEquals("two", des.map.get(2));
        Assert.assertEquals((Object)3, des.inverse.get("three"));
        Assert.assertEquals((Object)4, des.inverse.get("four"));
    }

    @Test
    public void binary() throws JsonDeserializationException {
        String source = "bla";
        BinarySerializableEntity binarySerializable = new BinarySerializableEntity();
        binarySerializable.setBinary("bla".getBytes());
        String json = SerrTest.serialize(binarySerializable);
        Assert.assertEquals("{\"$id\":1,\"__type\":\"de.mein.core.serialize.classes.BinarySerializableEntity\",\"binary\":\"Ymxh\"}", json);
        BinarySerializableEntity deserialized = (BinarySerializableEntity)SerializableEntityDeserializer.deserialize(json);
        Assert.assertEquals(Arrays.toString(binarySerializable.getBinary()), Arrays.toString(deserialized.getBinary()));
        Assert.assertEquals("bla", new String(deserialized.getBinary()));
    }

    public static class A
    implements SerializableEntity {
        private String primitive = "AAA";
        private SerializableEntity b = new B();
    }

    public static class B
    implements SerializableEntity {
        private String primitive = "BBB";
    }

    public static class EntityMapTest
    implements SerializableEntity {
        Map<Integer, SerializableEntity> map = new HashMap<Integer, SerializableEntity>();
        Map<SerializableEntity, Integer> inverse = new HashMap<SerializableEntity, Integer>();
    }

    public static class MapTestE
    implements SerializableEntity {
        Map<SerializableEntity, SerializableEntity> map = new HashMap<SerializableEntity, SerializableEntity>();
    }

    public static class S
    implements SerializableEntity {
        private Set<SimpleSerializableEntity> set = new HashSet<SimpleSerializableEntity>();
    }

    public static class SimpleMapTest
    implements SerializableEntity {
        Map<Integer, String> map = new HashMap<Integer, String>();
        Map<String, Integer> inverse = new HashMap<String, Integer>();
    }
}

