/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.tools;

import java.util.HashMap;
import java.util.Map;

public enum NumberTransformer {
    INT(Integer.class){

        @Override
        public Number cast(Number n) {
            return n == null ? null : Integer.valueOf(n.intValue());
        }
    }
    ,
    LONG(Long.class){

        @Override
        public Number cast(Number n) {
            return n == null ? null : Long.valueOf(n.longValue());
        }
    }
    ,
    NULL(null){

        @Override
        public Number cast(Number n) {
            return null;
        }
    }
    ,
    DOUBLE(Double.class){

        @Override
        public Number cast(Number n) {
            return n == null ? null : Double.valueOf(n.doubleValue());
        }
    }
    ,
    FLOAT(Float.class){

        @Override
        public Number cast(Number n) {
            return n == null ? null : Float.valueOf(n.floatValue());
        }
    };

    private static final Map<Class<? extends Number>, NumberTransformer> TRANSFORMER_MAP;
    private final Class<? extends Number> type;

    static {
        TRANSFORMER_MAP = new HashMap<Class<? extends Number>, NumberTransformer>();
        NumberTransformer[] numberTransformerArray = NumberTransformer.values();
        int n = numberTransformerArray.length;
        int n2 = 0;
        while (n2 < n) {
            NumberTransformer tranformer = numberTransformerArray[n2];
            TRANSFORMER_MAP.put(tranformer.type, tranformer);
            ++n2;
        }
    }

    private NumberTransformer(Class<? extends Number> type) {
        this.type = type;
    }

    public abstract Number cast(Number var1);

    public static NumberTransformer forType(Class<? extends Number> type) {
        NumberTransformer t = TRANSFORMER_MAP.get(type);
        return t == null ? NULL : t;
    }

    /* synthetic */ NumberTransformer(String string, int n, Class clazz, NumberTransformer numberTransformer) {
        this(clazz);
    }
}

