/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.tools;

public class OTimer {
    private final String name;
    private long sum;
    private long startTime;
    private long fps = 0L;
    private long startCount = 0L;

    public OTimer(String name) {
        this.name = name;
    }

    public OTimer start() {
        this.startTime = System.nanoTime();
        ++this.startCount;
        return this;
    }

    public long fps() {
        long duration = System.currentTimeMillis() - this.fps;
        this.fps = System.currentTimeMillis();
        if (duration > 0L) {
            return 1000L / duration;
        }
        return 0L;
    }

    public String toString() {
        return "Timer[" + this.name + "]: " + this.getDurationInMS() + "ms";
    }

    public OTimer stop() {
        this.sum = System.nanoTime() - this.startTime + this.sum;
        return this;
    }

    public long getDurationInMS() {
        return this.sum / 1000000L;
    }

    public long getDurationInNS() {
        return this.sum;
    }

    public long getDurationInS() {
        return (System.nanoTime() - this.startTime) / 1000000000L;
    }

    public OTimer print() {
        System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".'" + this.name + "'.print: " + this.sum / 1000000L + " ms");
        return this;
    }

    public OTimer reset() {
        this.sum = 0L;
        this.startCount = 0L;
        return this;
    }

    public long getStartCount() {
        return this.startCount;
    }

    public long getAverageDuration() {
        return this.sum / this.startCount;
    }
}

