/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.trace;

import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.exceptions.InvalidPathException;
import de.mein.core.serialize.serialize.trace.paths.ClassPathPart;
import de.mein.core.serialize.serialize.trace.paths.IPathPart;
import de.mein.core.serialize.serialize.trace.paths.PathFinder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceManager {
    protected static final Logger logger = LoggerFactory.getLogger(TraceManager.class);
    private List<List<IPathPart>> forcedPaths = new ArrayList<List<IPathPart>>();
    private Set<PathFinder> runningPathFinders = new HashSet<PathFinder>();
    private final List<IPathPart> startsTrace = new ArrayList<IPathPart>();
    private boolean isForcedPath = false;

    public String toString() {
        StringBuilder b2 = new StringBuilder("[" + this.getClass().getSimpleName() + "] isForcedPath: " + this.isForcedPath + "\n");
        b2.append("trace:\n");
        for (IPathPart pathPart : this.startsTrace) {
            b2.append(pathPart.getDesc()).append("\n");
        }
        return b2.toString();
    }

    public void up() {
        if (!this.startsTrace.isEmpty()) {
            this.startsTrace.remove(this.startsTrace.size() - 1);
        }
        ArrayList<PathFinder> pathFindersToDelete = new ArrayList<PathFinder>();
        for (PathFinder pathFinder : this.runningPathFinders) {
            pathFinder.up();
            if (!pathFinder.isOutOfCurrentGraph()) continue;
            pathFindersToDelete.add(pathFinder);
        }
        this.runningPathFinders.removeAll(pathFindersToDelete);
    }

    public void down(Field field) {
        this.isForcedPath = false;
        for (PathFinder pathFinder : this.runningPathFinders) {
            if (!pathFinder.down(field)) continue;
            this.isForcedPath = true;
            return;
        }
    }

    public void start(SerializableEntity entity) throws ClassNotFoundException {
        ClassPathPart pathPart = new ClassPathPart(entity.getClass().getName());
        this.startsTrace.add(pathPart);
        for (List<IPathPart> forcedPath : this.forcedPaths) {
            PathFinder finder = new PathFinder(forcedPath);
            if (!finder.start(entity.getClass())) continue;
            this.runningPathFinders.add(finder);
            this.isForcedPath = true;
        }
    }

    public boolean isForcedPath() {
        return this.isForcedPath;
    }

    public TraceManager addForcedPath(String path) throws InvalidPathException {
        try {
            List<IPathPart> forcedPath = PathFinder.buildForcedPath(path);
            this.forcedPaths.add(forcedPath);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPathException(path, e);
        }
        return this;
    }
}

