/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.trace.paths;

import de.mein.core.serialize.EntityAnalyzer;
import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.serialize.trace.paths.IPathPart;
import java.lang.reflect.Field;

public class ClassPathPart
implements IPathPart {
    private Class<? extends SerializableEntity> clazz;

    public ClassPathPart(String className) throws ClassNotFoundException {
        this.clazz = EntityAnalyzer.clazz(className);
    }

    public ClassPathPart(Class entityClass) {
        this.clazz = entityClass;
    }

    @Override
    public boolean down(Field field) {
        Class<? extends SerializableEntity> fieldClass = field.getDeclaringClass();
        return fieldClass.isAssignableFrom(this.clazz);
    }

    @Override
    public boolean start(Class entityClazz) {
        return entityClazz.isAssignableFrom(this.clazz);
    }

    @Override
    public String getDesc() {
        return this.clazz.getSimpleName();
    }

    @Override
    public boolean fits(IPathPart tracePart) {
        if (tracePart instanceof ClassPathPart) {
            ClassPathPart classPathPart = (ClassPathPart)tracePart;
            return this.clazz.isAssignableFrom(classPathPart.clazz);
        }
        return false;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] clazz: " + this.clazz.getSimpleName();
    }
}

