/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.serialize.trace.paths;

import de.mein.core.serialize.serialize.trace.paths.ClassPathPart;
import de.mein.core.serialize.serialize.trace.paths.FieldPathPart;
import de.mein.core.serialize.serialize.trace.paths.IPathPart;
import de.mein.core.serialize.serialize.trace.paths.PathPartFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PathFinder {
    private List<IPathPart> forcedPath = new ArrayList<IPathPart>();
    private List<IPathPart> trace = new ArrayList<IPathPart>();
    private boolean inPath = true;
    private boolean outOfCurrentGraph = false;

    public static List<IPathPart> buildForcedPath(String path) throws ClassNotFoundException {
        ArrayList<IPathPart> forcedPath = new ArrayList<IPathPart>();
        int classNameStart = path.indexOf("[");
        int classNameStop = path.indexOf("]") + 1;
        String className = path.substring(classNameStart, classNameStop);
        forcedPath.add(PathPartFactory.createPathPart(className));
        String rest = path.substring(classNameStop, path.length());
        StringTokenizer tokenizer = new StringTokenizer(rest, ".");
        while (tokenizer.hasMoreElements()) {
            String pathToken = (String)tokenizer.nextElement();
            IPathPart pathPart = PathPartFactory.createPathPart(pathToken);
            forcedPath.add(pathPart);
        }
        return forcedPath;
    }

    public PathFinder(String path) throws ClassNotFoundException {
        this.forcedPath = PathFinder.buildForcedPath(path);
    }

    public PathFinder(List<IPathPart> forcedPath) {
        this.forcedPath = forcedPath;
    }

    public boolean start(Class entityClass) {
        this.inPath = true;
        ClassPathPart classPathPart = new ClassPathPart(entityClass);
        this.trace.add(classPathPart);
        if (!this.forcedPath.isEmpty()) {
            ClassPathPart forcedPathPart = (ClassPathPart)this.forcedPath.get(0);
            this.inPath = forcedPathPart.start(entityClass);
        }
        return this.inPath;
    }

    public boolean down(Field field) {
        FieldPathPart traceFieldPathPart = new FieldPathPart(field.getName());
        this.trace.add(traceFieldPathPart);
        int index = this.trace.size() - 1;
        if (index < this.forcedPath.size() && this.inPath) {
            IPathPart pathPart = this.forcedPath.get(index);
            this.inPath = pathPart.down(field);
        } else {
            this.inPath = false;
        }
        return this.inPath;
    }

    public void up() {
        if (!this.trace.isEmpty()) {
            this.trace.remove(this.trace.size() - 1);
        }
        if (!this.trace.isEmpty() && this.trace.size() <= this.forcedPath.size()) {
            this.inPath = true;
            int i = 0;
            while (i < this.trace.size()) {
                IPathPart forcePart;
                IPathPart tracePart = this.trace.get(i);
                if (!tracePart.fits(forcePart = this.forcedPath.get(i))) {
                    this.inPath = false;
                }
                ++i;
            }
        } else {
            this.inPath = false;
        }
        if (this.trace.isEmpty()) {
            this.outOfCurrentGraph = true;
        }
    }

    public boolean isOutOfCurrentGraph() {
        return this.outOfCurrentGraph;
    }
}

