/*
 * Decompiled with CFR 0.152.
 */
package de.mein.execute;

import de.mein.core.serialize.serialize.tools.StringBuilder;
import de.mein.execute.SqliteExecutorInjection;
import de.mein.sql.SQLStatement;
import de.mein.sql.conn.SQLConnection;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Scanner;

public class SqliteExecutor {
    private SQLConnection connection;
    private String statement;
    private static SqliteExecutorInjection injectedImpl;
    StringBuilder b = new StringBuilder();
    StringBuilder debug = new StringBuilder();

    public static void setExecutorImpl(SqliteExecutorInjection injectedImpl) {
        SqliteExecutor.injectedImpl = injectedImpl;
    }

    public SqliteExecutor(SQLConnection connection) {
        this.connection = connection;
    }

    public void executeStream(InputStream in) throws IOException, SQLException {
        System.out.println("SqliteExecutor.executeStream");
        if (injectedImpl != null) {
            injectedImpl.executeStream(this.connection, in);
        } else {
            Scanner s = new Scanner(in, "UTF-8");
            s.useDelimiter("\n|\r");
            try {
                int begin = 0;
                boolean comment = false;
                while (s.hasNext()) {
                    String line = s.next();
                    String trimmed = line.trim().toLowerCase();
                    boolean ap = false;
                    if (trimmed.startsWith("begin") && !trimmed.startsWith("begin transaction")) {
                        ++begin;
                        this.append(line);
                        ap = true;
                    } else if (trimmed.startsWith("end")) {
                        --begin;
                        this.append(line);
                        ap = true;
                    } else if (trimmed.startsWith("/*")) {
                        comment = true;
                    } else if (trimmed.endsWith("*/")) {
                        comment = false;
                    }
                    if (begin == 0) {
                        if (line.endsWith(";")) {
                            if (!ap) {
                                this.append(line);
                            }
                            this.statement = this.b.toString();
                            this.debug.append(this.statement).append("\n");
                            try {
                                SQLStatement st = this.connection.prepareStatement(this.statement);
                                st.execute();
                                st.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            this.b = new StringBuilder();
                            continue;
                        }
                        if (ap) continue;
                        this.append(line);
                        continue;
                    }
                    if (ap) continue;
                    this.append(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void append(String line) {
        boolean string = false;
        String[] parts = line.split("\\-\\-");
        this.b.append(" ");
        this.b.append(parts[0]);
    }

    private boolean isValid(String line) {
        return line.trim().length() > 0 && !line.trim().startsWith("--") && line.trim().endsWith(";");
    }

    public boolean checkTablesExist(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!this.checkTableExists(name)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkTableExists(String tableName) {
        try {
            if (injectedImpl == null) {
                String query = "select * from " + tableName;
                this.connection.prepareStatement(query).execute();
                return true;
            }
            if (injectedImpl.checkTableExists(this.connection, tableName)) {
                return true;
            }
            System.err.println("SqliteExecutor.checkTableExists(" + tableName + ")=false :(");
            return false;
        }
        catch (Exception e) {
            System.out.println("SqliteExecutor.checkTableExists.false");
        }
        return false;
    }
}

