/*
 * Decompiled with CFR 0.152.
 */
package de.mein.sql;

import de.mein.sql.ISQLQueries;
import de.mein.sql.RWLock;

public abstract class Dao {
    protected ISQLQueries sqlQueries;
    protected final boolean lock;

    public Dao(ISQLQueries sqlQueries) {
        this(sqlQueries, true);
    }

    public Dao(ISQLQueries sqlQueries, boolean lock) {
        this.sqlQueries = sqlQueries;
        this.lock = lock;
    }

    public ISQLQueries getSqlQueries() {
        return this.sqlQueries;
    }

    public static abstract class ConnectionLockingDao
    extends Dao {
        public ConnectionLockingDao(ISQLQueries ISQLQueries2) {
            super(ISQLQueries2);
        }

        public ConnectionLockingDao(ISQLQueries ISQLQueries2, boolean lock) {
            super(ISQLQueries2, lock);
        }

        public void lockWrite() {
            this.sqlQueries.lockWrite();
        }

        public void lockRead() {
            this.sqlQueries.lockRead();
        }

        public void unlockWrite() {
            this.sqlQueries.unlockWrite();
        }

        public void unlockRead() {
            this.sqlQueries.unlockRead();
        }
    }

    public static class LockingDao
    extends ConnectionLockingDao {
        protected RWLock lock = new RWLock();

        public LockingDao(ISQLQueries ISQLQueries2) {
            super(ISQLQueries2);
        }

        public LockingDao(ISQLQueries ISQLQueries2, boolean lock) {
            super(ISQLQueries2, lock);
        }

        @Override
        public void lockRead() {
            this.lock.lockRead();
        }

        @Override
        public void lockWrite() {
            this.lock.lockWrite();
        }

        @Override
        public void unlockRead() {
            this.lock.unlockRead();
        }

        @Override
        public void unlockWrite() {
            this.lock.unlockWrite();
        }
    }
}

