/*
 * Decompiled with CFR 0.152.
 */
package de.mein.sql;

import de.mein.sql.ISQLResource;
import de.mein.sql.Pair;
import de.mein.sql.RWLock;
import de.mein.sql.SQLTableObject;
import de.mein.sql.SqlQueriesException;
import de.mein.sql.conn.SQLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class ISQLQueries {
    public static final boolean SYSOUT = false;
    protected RWLock lock;

    public static <T extends SQLTableObject> String buildQueryFrom(List<Pair<?>> columns, Class<T> clazz, String where) throws SqlQueriesException {
        try {
            String fromTable = ((SQLTableObject)clazz.newInstance()).getTableName();
            String selectString = ISQLQueries.buildSelectQuery(columns, fromTable);
            if (where != null) {
                selectString = String.valueOf(selectString) + " where " + where;
            }
            return selectString;
        }
        catch (Exception e) {
            throw new SqlQueriesException(e);
        }
    }

    public static List<Object> whereArgs(Object ... values) {
        ArrayList<Object> args = new ArrayList<Object>();
        if (values != null) {
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object v = objectArray[n2];
                args.add(v);
                ++n2;
            }
        }
        return args;
    }

    protected void out(String msg) {
    }

    public static String buildSelectQuery(List<Pair<?>> what, String fromTable) {
        String result2 = "select ";
        int i = 0;
        while (i < what.size()) {
            String entry = what.get(i).k();
            result2 = i < what.size() - 1 ? String.valueOf(result2) + entry + ", " : String.valueOf(result2) + entry + " ";
            ++i;
        }
        result2 = String.valueOf(result2) + " from " + fromTable;
        return result2;
    }

    protected String buildInsertModifyQuery(List<Pair<?>> what, String before, String after, String where, String fromTable) throws SqlQueriesException {
        String query;
        try {
            query = String.valueOf(before) + " " + fromTable + " " + after + " ";
            int i = 0;
            while (i < what.size()) {
                String key = what.get(i).k();
                query = i < what.size() - 1 ? String.valueOf(query) + key + "= ? , " : String.valueOf(query) + key + " = ?";
                ++i;
            }
            if (where != null) {
                query = String.valueOf(query) + " where " + where;
            }
        }
        catch (Exception e) {
            throw new SqlQueriesException(e);
        }
        return query;
    }

    public abstract SQLConnection getSQLConnection();

    public abstract void update(SQLTableObject var1, String var2, List<Object> var3) throws SqlQueriesException;

    public abstract void delete(SQLTableObject var1, String var2, List<Object> var3) throws SqlQueriesException;

    public abstract <T extends SQLTableObject> ISQLResource<T> loadResource(List<Pair<?>> var1, Class<T> var2, String var3, List<Object> var4) throws SqlQueriesException;

    public abstract <T extends SQLTableObject> List<T> load(List<Pair<?>> var1, T var2, String var3, List<Object> var4) throws SqlQueriesException;

    public abstract <T> List<T> loadColumn(Pair<T> var1, Class<T> var2, SQLTableObject var3, String var4, List<Object> var5, String var6) throws SqlQueriesException;

    public abstract <T extends SQLTableObject> List<T> load(List<Pair<?>> var1, T var2, String var3, List<Object> var4, String var5) throws SqlQueriesException;

    public abstract <T extends SQLTableObject> List<T> loadString(List<Pair<?>> var1, T var2, String var3, List<Object> var4) throws SqlQueriesException;

    public abstract <T> T queryValue(String var1, Class<T> var2) throws SqlQueriesException;

    public abstract <T> T queryValue(String var1, Class<T> var2, List<Object> var3) throws SqlQueriesException;

    public abstract void execute(String var1, List<Object> var2) throws SqlQueriesException;

    public abstract Long insert(SQLTableObject var1) throws SqlQueriesException;

    public abstract Long insertWithAttributes(SQLTableObject var1, List<Pair<?>> var2) throws SqlQueriesException;

    public abstract void lockRead();

    public abstract void unlockRead();

    public abstract void lockWrite();

    public abstract void unlockWrite();

    public abstract void commit() throws SQLException;

    public abstract <C> C querySingle(String var1, List<Object> var2, Class<C> var3) throws SqlQueriesException;

    public abstract <T> List<T> load(List<Pair<?>> var1, SQLTableObject var2, String var3, List<Object> var4, String var5, Class<T> var6) throws SqlQueriesException;
}

