/*
 * Decompiled with CFR 0.152.
 */
package de.mein.sql;

import de.mein.sql.IPairGetListener;
import de.mein.sql.IPairSetListener;
import de.mein.sql.Logger;
import de.mein.sql.NumberTransformer;
import de.mein.sql.PairTypeConverter;

public class Pair<V> {
    private static Logger logger = Logger.getLogger(Pair.class);
    private V value;
    private String key;
    private static final String OPEN_BRACE = "{";
    private static final String COMMA = ",";
    private static final String CLOSE_BRACE = "}";
    private IPairGetListener getListener = null;
    private IPairGetListener hiddenGetListener = null;
    private IPairSetListener<V> setListener = null;
    private static PairTypeConverter typeConverter = new PairTypeConverter(){

        @Override
        public <V> V convert(Class<V> type, Object value) {
            if (value != null) {
                Object v = null;
                if (type.equals(value.getClass())) {
                    v = value;
                } else if (type.isEnum() && value instanceof String) {
                    Class<V> eType = type;
                    v = Enum.valueOf(eType, (String)value);
                } else if (Number.class.isAssignableFrom(type)) {
                    NumberTransformer numberTransformer = NumberTransformer.forType(type);
                    v = numberTransformer.cast((Number)value);
                } else if (type.equals(Boolean.class) && value.getClass().equals(String.class)) {
                    v = new Boolean(Boolean.parseBoolean((String)value));
                } else if (type.equals(Boolean.class) && value.getClass().equals(Integer.class)) {
                    v = new Boolean((Integer)value == 1);
                } else {
                    logger.warn(".setValueUnsecure().class.mismatch: class is " + type);
                    logger.warn("delivered class is " + value.getClass());
                    logger.warn("{key,value} is " + this.toString());
                }
                return (V)v;
            }
            return null;
        }
    };
    private Class<V> type;

    public static void setTypeConverter(PairTypeConverter typeConverter) {
        Pair.typeConverter = typeConverter;
    }

    public Class<V> getGenericClass() {
        return this.type;
    }

    public Pair(Class<V> type, String key) {
        this.type = type;
        this.key = key;
    }

    public Pair(Class<V> type, String key, V value) {
        this.type = type;
        this.key = key;
        this.v(value);
    }

    public String k() {
        return this.key;
    }

    public V v() {
        if (this.getListener != null) {
            this.getListener.onGetCalled();
        }
        if (this.hiddenGetListener != null) {
            this.getListener = this.hiddenGetListener;
            this.hiddenGetListener = null;
        }
        return this.value;
    }

    public Pair<V> setSetListener(IPairSetListener<V> setListener) {
        this.setListener = setListener;
        return this;
    }

    public Pair<V> ignoreListener() {
        if (this.hiddenGetListener == null) {
            this.hiddenGetListener = this.getListener;
            this.getListener = null;
        }
        return this;
    }

    public String valueAsString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public Pair<V> v(V value) {
        this.value = this.setListener != null ? this.setListener.onSetCalled(value) : value;
        return this;
    }

    public Pair<V> v(Pair<V> pair) {
        this.value = pair.v();
        return this;
    }

    public String toString() {
        return OPEN_BRACE + this.key + COMMA + this.value + CLOSE_BRACE;
    }

    public void setValueUnsecure(Object value) {
        try {
            V v = typeConverter.convert(this.type, value);
            this.value = this.setListener != null ? this.setListener.onSetCalled(v) : v;
        }
        catch (Exception e) {
            System.err.println("Pair{name:'" + this.k() + "'}.setValueUnsecure('" + value + "')");
            logger.error("stacktrace", e);
        }
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return this.key.hashCode();
    }

    public int calcHash() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    public Pair<V> setGetListener(IPairGetListener<V> getListener) {
        this.getListener = getListener;
        this.hiddenGetListener = null;
        return this;
    }

    public IPairGetListener getGetListener() {
        return this.getListener;
    }

    public Pair<V> nul() {
        this.value = null;
        return this;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

