/*
 * Decompiled with CFR 0.152.
 */
package de.mein.sql;

public class RWLock {
    private SimpleLock lock;
    private boolean read = false;
    private boolean write = false;
    private ReadLockCounter readLockCounter = new ReadLockCounter();
    private static boolean PRINT_STACK = false;

    public RWLock() {
        this.lock = new SimpleLock(this);
    }

    public synchronized RWLock lockRead() {
        if (this.write || !this.read) {
            this.lock.lock();
        }
        this.write = false;
        this.read = true;
        this.readLockCounter.inc();
        RWLock.printStack("lockRead");
        return this;
    }

    public static void printStack(String methodName) {
        if (PRINT_STACK) {
            System.out.println("RWLock.printStack.called: " + methodName);
            Exception e = new Exception();
            int max = e.getStackTrace().length;
            max = max > 5 ? 5 : max;
            int i = 0;
            while (i < max) {
                StackTraceElement element = e.getStackTrace()[i];
                System.out.println("RWLock.printStack[" + i + "]: " + element.getClassName() + "(" + element.getLineNumber() + ") ." + element.getMethodName());
                ++i;
            }
        }
    }

    public synchronized RWLock unlockRead() {
        this.readLockCounter.dec();
        if (this.lock.isLocked() && this.readLockCounter.getReadLockCount() == 0) {
            this.lock.unlock();
            this.read = false;
        }
        RWLock.printStack("unlockRead");
        return this;
    }

    public synchronized RWLock unlockWrite() {
        if (!this.read && this.write) {
            this.lock.unlock();
            this.write = false;
        }
        RWLock.printStack("unlockWrite");
        return this;
    }

    public synchronized RWLock lockWrite() {
        this.lock.lock();
        this.write = true;
        this.read = false;
        RWLock.printStack("lockWrite");
        return this;
    }

    class ReadLockCounter {
        private int readLockCount = 0;

        ReadLockCounter() {
        }

        public synchronized void inc() {
            ++this.readLockCount;
        }

        public synchronized void dec() {
            --this.readLockCount;
        }

        public int getReadLockCount() {
            return this.readLockCount;
        }
    }

    class SimpleLock {
        private final RWLock rwLock;
        private boolean isLocked = false;

        SimpleLock(RWLock rwLock) {
            this.rwLock = rwLock;
        }

        public synchronized void lock() {
            while (this.isLocked) {
                try {
                    this.rwLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isLocked = true;
        }

        public boolean isLocked() {
            return this.isLocked;
        }

        public void unlock() {
            this.isLocked = false;
            this.rwLock.notify();
        }
    }
}

