/*
 * Decompiled with CFR 0.152.
 */
package de.mein.sql;

import de.mein.sql.ISQLQueries;
import de.mein.sql.ISQLResource;
import de.mein.sql.Pair;
import de.mein.sql.RWLock;
import de.mein.sql.SQLResource;
import de.mein.sql.SQLTableObject;
import de.mein.sql.SqlQueriesException;
import de.mein.sql.conn.JDBCConnection;
import de.mein.sql.conn.SQLConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SQLQueries
extends ISQLQueries {
    private RWLock lock;
    public static final boolean SYSOUT = false;
    private final JDBCConnection sqlConnection;
    private final Connection connection;

    public SQLQueries(JDBCConnection connection) {
        this.sqlConnection = connection;
        this.connection = this.sqlConnection.getConnection();
    }

    public SQLQueries(JDBCConnection connection, RWLock lock) {
        this.sqlConnection = connection;
        this.connection = this.sqlConnection.getConnection();
        this.lock = lock;
    }

    @Override
    public SQLConnection getSQLConnection() {
        return this.sqlConnection;
    }

    @Override
    public void update(SQLTableObject sqlTableObject, String where, List<Object> whereArgs) throws SqlQueriesException {
        this.lockWrite();
        this.out("update()");
        List<Pair<?>> what = sqlTableObject.getInsertAttributes();
        String fromTable = sqlTableObject.getTableName();
        String query = this.buildInsertModifyQuery(what, "update", "set", where, fromTable);
        this.out("update().query= " + query);
        try {
            try {
                PreparedStatement pstmt = this.connection.prepareStatement(query);
                int count = 1;
                for (Pair<?> attribute : what) {
                    pstmt.setObject(count, attribute.v());
                    ++count;
                }
                if (where != null && whereArgs != null) {
                    this.insertArguments(pstmt, whereArgs, count);
                }
                int changed = pstmt.executeUpdate();
                pstmt.close();
            }
            catch (SQLException e) {
                System.err.println(e.getSQLState());
                throw new SqlQueriesException(e);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public void delete(SQLTableObject sqlTableObject, String where, List<Object> whereArgs) throws SqlQueriesException {
        this.lockWrite();
        String query = "delete from " + sqlTableObject.getTableName();
        if (where != null) {
            query = String.valueOf(query) + " where " + where;
        }
        this.out("delete().query= " + query);
        try {
            try {
                PreparedStatement pstmt = this.connection.prepareStatement(query);
                if (where != null && whereArgs != null) {
                    this.insertArguments(pstmt, whereArgs);
                }
                pstmt.executeUpdate();
                pstmt.close();
            }
            catch (Exception e) {
                throw new SqlQueriesException(e);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    private void insertArguments(PreparedStatement pstmt, List<Object> whereArgs, int count) throws SQLException {
        for (Object o : whereArgs) {
            pstmt.setObject(count, o);
            ++count;
        }
    }

    private void insertArguments(PreparedStatement pstmt, Object[] whereArgs, int count) throws SQLException {
        Object[] objectArray = whereArgs;
        int n = whereArgs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            pstmt.setObject(count, o);
            ++count;
            ++n2;
        }
    }

    private void insertArguments(PreparedStatement pstmt, List<Object> whereArgs) throws SQLException {
        this.insertArguments(pstmt, whereArgs, 1);
    }

    @Override
    public <T extends SQLTableObject> ISQLResource<T> loadResource(List<Pair<?>> columns, Class<T> clazz, String where, List<Object> whereArgs) throws SqlQueriesException {
        String selectString = ISQLQueries.buildQueryFrom(columns, clazz, where);
        if (this.connection == null) {
            return null;
        }
        try {
            PreparedStatement pstmt = this.connection.prepareStatement(selectString);
            if (where != null && whereArgs != null) {
                this.insertArguments(pstmt, whereArgs);
            }
            pstmt.execute();
            return new SQLResource<T>(pstmt, clazz);
        }
        catch (Exception e) {
            throw new SqlQueriesException(e);
        }
    }

    @Override
    public <T extends SQLTableObject> List<T> load(List<Pair<?>> columns, T sqlTableObject, String where, List<Object> whereArgs) throws SqlQueriesException {
        return this.load(columns, sqlTableObject, where, whereArgs, null);
    }

    @Override
    public <T> List<T> loadColumn(Pair<T> column, Class<T> clazz, SQLTableObject sqlTableObject, String where, List<Object> whereArgs, String whatElse) throws SqlQueriesException {
        ArrayList<Object> result2 = new ArrayList<Object>();
        this.out("load()");
        String fromTable = sqlTableObject.getTableName();
        String selectString = SQLQueries.buildSelectQuery(new ArrayList<Pair<?>>(column){
            {
                this.add(pair);
            }
        }, fromTable);
        if (where != null) {
            selectString = String.valueOf(selectString) + " where " + where;
        }
        if (whatElse != null) {
            selectString = String.valueOf(selectString) + " " + whatElse;
        }
        this.out(selectString);
        if (this.connection == null) {
            return null;
        }
        try {
            PreparedStatement pstmt = this.connection.prepareStatement(selectString);
            if (where != null && whereArgs != null) {
                this.insertArguments(pstmt, whereArgs);
            }
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            boolean hasResult = resultSet.next();
            if (hasResult && resultSet.getRow() > 0) {
                while (!resultSet.isAfterLast()) {
                    block10: {
                        try {
                            Object res = resultSet.getObject(column.k());
                            result2.add(res);
                        }
                        catch (Exception e) {
                            if (e.getClass().equals(SQLException.class)) break block10;
                            this.out("load().exception." + e.getClass().toString() + " " + e.getMessage());
                        }
                    }
                    resultSet.next();
                }
            }
            resultSet.close();
            pstmt.close();
            return result2;
        }
        catch (Exception e) {
            System.err.println("SQLQueries.loadColumn.failed.query: " + selectString);
            throw new SqlQueriesException(e);
        }
    }

    @Override
    public <T extends SQLTableObject> List<T> load(List<Pair<?>> columns, T sqlTableObject, String where, List<Object> whereArgs, String whatElse) throws SqlQueriesException {
        ArrayList<SQLTableObject> result2 = new ArrayList<SQLTableObject>();
        this.out("load()");
        String fromTable = sqlTableObject.getTableName();
        String selectString = SQLQueries.buildSelectQuery(columns, fromTable);
        if (where != null) {
            selectString = String.valueOf(selectString) + " where " + where;
        }
        if (whatElse != null) {
            selectString = String.valueOf(selectString) + " " + whatElse;
        }
        this.out(selectString);
        if (this.connection == null) {
            return null;
        }
        try {
            PreparedStatement pstmt = this.connection.prepareStatement(selectString);
            if (where != null && whereArgs != null) {
                this.insertArguments(pstmt, whereArgs);
            }
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            boolean hasResult = resultSet.next();
            if (hasResult && resultSet.getRow() > 0) {
                while (!resultSet.isAfterLast()) {
                    SQLTableObject sqlTable = (SQLTableObject)sqlTableObject.getClass().newInstance();
                    List<Pair<?>> attributes = sqlTable.getAllAttributes();
                    for (Pair<?> pair : attributes) {
                        try {
                            Object res = resultSet.getObject(pair.k());
                            pair.setValueUnsecure(res);
                        }
                        catch (Exception e) {
                            if (e.getClass().equals(SQLException.class)) continue;
                            this.out("load().exception." + e.getClass().toString() + " " + e.getMessage());
                            System.err.println("SQLQueries.load.Exception on setting Pair: " + pair.k());
                        }
                    }
                    result2.add(sqlTable);
                    resultSet.next();
                }
            }
            resultSet.close();
            pstmt.close();
            return result2;
        }
        catch (Exception e) {
            throw new SqlQueriesException(e);
        }
    }

    @Override
    public <T extends SQLTableObject> List<T> loadString(List<Pair<?>> columns, T sqlTableObject, String selectString, List<Object> arguments) throws SqlQueriesException {
        this.lockRead();
        ArrayList<SQLTableObject> result2 = new ArrayList<SQLTableObject>();
        this.out("loadString()");
        this.out(selectString);
        try {
            PreparedStatement pstmt = this.connection.prepareStatement(selectString);
            if (arguments != null) {
                int count = 1;
                for (Object object : arguments) {
                    pstmt.setObject(count, object);
                    ++count;
                }
            }
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            while (resultSet.next() && !resultSet.isAfterLast()) {
                SQLTableObject sqlObjInstance = (SQLTableObject)sqlTableObject.getClass().newInstance();
                List<Pair<?>> attributes = sqlObjInstance.getAllAttributes();
                for (Pair<?> pair : attributes) {
                    Object res = resultSet.getObject(pair.k());
                    pair.setValueUnsecure(res);
                }
                result2.add(sqlObjInstance);
            }
            resultSet.close();
            pstmt.close();
            ArrayList<SQLTableObject> arrayList = result2;
            return arrayList;
        }
        catch (Exception e) {
            throw new SqlQueriesException(e);
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public <T> T queryValue(String query, Class<T> clazz) throws SqlQueriesException {
        return this.queryValue(query, clazz, null);
    }

    @Override
    public <T> T queryValue(String query, Class<T> clazz, List<Object> args) throws SqlQueriesException {
        Object result2;
        block9: {
            this.lockRead();
            result2 = null;
            try {
                PreparedStatement pstmt = this.connection.prepareStatement(query);
                if (args != null) {
                    int count = 1;
                    for (Object arg : args) {
                        pstmt.setObject(count, arg);
                    }
                }
                if (((Boolean)(result2 = Boolean.valueOf(pstmt.execute()))).booleanValue()) {
                    ResultSet resultSet = pstmt.getResultSet();
                    resultSet.next();
                    if (resultSet.getRow() > 0) {
                        result2 = resultSet.getObject(1);
                        resultSet.close();
                        pstmt.close();
                    }
                    break block9;
                }
                pstmt.close();
                return null;
            }
            catch (Exception e) {
                throw new SqlQueriesException(e);
            }
            finally {
                this.unlockRead();
            }
        }
        return (T)result2;
    }

    @Override
    public void execute(String statement, List<Object> whereArgs) throws SqlQueriesException {
        this.lockRead();
        try {
            try {
                PreparedStatement pstmt = this.connection.prepareStatement(statement);
                if (whereArgs != null && whereArgs != null) {
                    this.insertArguments(pstmt, whereArgs, 1);
                }
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                throw new SqlQueriesException(e);
            }
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public Long insert(SQLTableObject sqlTableObject) throws SqlQueriesException {
        return this.insertWithAttributes(sqlTableObject, sqlTableObject.getInsertAttributes());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Long insertWithAttributes(SQLTableObject sqlTableObject, List<Pair<?>> attributes) throws SqlQueriesException {
        block17: {
            block15: {
                block16: {
                    this.lockWrite();
                    this.out("insert()");
                    query = null;
                    fromTable = sqlTableObject.getTableName();
                    if (attributes == null) {
                        System.err.println("SQLQueries.insertWithAttributes: attributes are null.");
                        System.err.println("SQLQueries.insertWithAttributes: have you called init() in the constructor of " + sqlTableObject.getClass().getSimpleName() + "?");
                    }
                    try {
                        query = " insert into " + fromTable + " (";
                        toConcat = ") values (";
                        i = 0;
                        while (i < attributes.size()) {
                            key = attributes.get(i).k();
                            if (i < attributes.size() - 1) {
                                query = String.valueOf(query) + key + ", ";
                                toConcat = String.valueOf(toConcat) + " ? , ";
                            } else {
                                query = String.valueOf(query) + key;
                                toConcat = String.valueOf(toConcat) + " ? ";
                            }
                            ++i;
                        }
                        query = String.valueOf(query) + toConcat + ")";
                        this.out("insert.query: " + query);
                    }
                    catch (Exception e) {
                        throw new SqlQueriesException(e);
                    }
                    pstmt = this.connection.prepareStatement(query, 1);
                    i = 1;
                    while (i <= attributes.size()) {
                        attribute = attributes.get(i - 1);
                        pstmt.setObject(i, attribute.v());
                        ++i;
                    }
                    pstmt.executeUpdate();
                    resultSet = pstmt.getGeneratedKeys();
                    resultSet.next();
                    if (resultSet.getRow() <= 0) break block15;
                    id = resultSet.getObject(1);
                    if (!(id instanceof Integer)) break block16;
                    var9_12 = (long)((Integer)id);
                    this.unlockWrite();
                    return var9_12;
                }
                if (!(id instanceof Long)) break block15;
                var9_13 = (Long)id;
                this.unlockWrite();
                return var9_13;
            }
            try {
                try {
                    resultSet.close();
                    pstmt.close();
                    break block17;
                }
                catch (Exception e) {
                    System.err.println("SQLQueries.insert.query: " + query);
                    System.err.println("SQLQueries.insert.attributes: ");
                    ** for (pair : attributes)
                }
lbl-1000:
                // 1 sources

                {
                    System.err.print(pair.v() + ", ");
                    continue;
                }
lbl64:
                // 1 sources

                throw new SqlQueriesException(e);
            }
            catch (Throwable var8_14) {
                throw var8_14;
            }
            finally {
                this.unlockWrite();
            }
        }
        this.out("insert().doing nothing right now");
        return null;
    }

    @Override
    public void lockRead() {
    }

    @Override
    public void unlockRead() {
    }

    @Override
    public void lockWrite() {
    }

    @Override
    public void unlockWrite() {
    }

    public void beginTransaction() throws SQLException {
        this.connection.setAutoCommit(false);
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
        this.connection.setAutoCommit(true);
    }

    @Override
    public <C> C querySingle(String query, List<Object> arguments, Class<C> resultClass) throws SqlQueriesException {
        this.lockRead();
        try {
            this.out("SQLQueries.query");
            PreparedStatement pstmt = this.connection.prepareStatement(query);
            if (arguments != null) {
                int count = 1;
                for (Object object : arguments) {
                    pstmt.setObject(count, object);
                    ++count;
                }
            }
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            resultSet.next();
            if (resultSet.getRow() > 0 && !resultSet.isAfterLast()) {
                Object object = resultSet.getObject(1);
                return (C)object;
            }
            try {
                resultSet.close();
                pstmt.close();
            }
            catch (Exception e) {
                throw new SqlQueriesException(e);
            }
        }
        finally {
            this.unlockRead();
        }
        return null;
    }

    @Override
    public <T> List<T> load(List<Pair<?>> columns, SQLTableObject sqlTableObject, String where, List<Object> whereArgs, String whatElse, Class<T> castClass) throws SqlQueriesException {
        ArrayList<SQLTableObject> result2 = new ArrayList<SQLTableObject>();
        this.out("load()");
        String fromTable = sqlTableObject.getTableName();
        String selectString = SQLQueries.buildSelectQuery(columns, fromTable);
        if (where != null) {
            selectString = String.valueOf(selectString) + " where " + where;
        }
        if (whatElse != null) {
            selectString = String.valueOf(selectString) + " " + whatElse;
        }
        this.out(selectString);
        if (this.connection == null) {
            return null;
        }
        try {
            PreparedStatement pstmt = this.connection.prepareStatement(selectString);
            if (where != null && whereArgs != null) {
                this.insertArguments(pstmt, whereArgs);
            }
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            boolean hasResult = resultSet.next();
            if (hasResult && resultSet.getRow() > 0) {
                while (!resultSet.isAfterLast()) {
                    SQLTableObject sqlTable = (SQLTableObject)sqlTableObject.getClass().newInstance();
                    List<Pair<?>> attributes = sqlTable.getAllAttributes();
                    for (Pair<?> pair : attributes) {
                        try {
                            Object res = resultSet.getObject(pair.k());
                            pair.setValueUnsecure(res);
                        }
                        catch (Exception e) {
                            if (e.getClass().equals(SQLException.class)) continue;
                            this.out("load().exception." + e.getClass().toString() + " " + e.getMessage());
                        }
                    }
                    result2.add(sqlTable);
                    resultSet.next();
                }
            }
            resultSet.close();
            pstmt.close();
            return result2;
        }
        catch (Exception e) {
            throw new SqlQueriesException(e);
        }
    }
}

