/*
 * Decompiled with CFR 0.152.
 */
package de.mein.sql;

import de.mein.sql.ISQLResource;
import de.mein.sql.Pair;
import de.mein.sql.SQLTableObject;
import de.mein.sql.SqlQueriesException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SQLResource<T extends SQLTableObject>
implements ISQLResource<T> {
    private final Class<T> clazz;
    private final PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public SQLResource(PreparedStatement preparedStatement, Class<T> clazz) throws SQLException {
        this.clazz = clazz;
        this.preparedStatement = preparedStatement;
        this.resultSet = preparedStatement.getResultSet();
    }

    @Override
    public T getNext() throws SqlQueriesException {
        SQLTableObject sqlTable = null;
        try {
            if (this.resultSet.next()) {
                sqlTable = (SQLTableObject)this.clazz.newInstance();
                List<Pair<?>> attributes = sqlTable.getAllAttributes();
                for (Pair<?> pair : attributes) {
                    try {
                        Object res = this.resultSet.getObject(pair.k());
                        pair.setValueUnsecure(res);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SqlQueriesException(e);
        }
        return (T)sqlTable;
    }

    @Override
    public void close() throws SQLException {
        this.resultSet.close();
        this.preparedStatement.close();
    }
}

