/*
 * Decompiled with CFR 0.152.
 */
package de.mein.sql;

import de.mein.core.serialize.JsonIgnore;
import de.mein.sql.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class SQLTableObject {
    @JsonIgnore
    protected transient ArrayList<Pair<?>> allAttributes;
    @JsonIgnore
    protected transient ArrayList<Pair<?>> insertAttributes;

    public abstract String getTableName();

    public List<Pair<?>> getAllAttributes() {
        return this.allAttributes;
    }

    protected void addToList(ArrayList<Pair<?>> list, Pair ... pairs) {
        Pair[] pairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            Pair pair = pairArray[n2];
            list.add(pair);
            ++n2;
        }
    }

    protected void populateInsert(Pair ... pairs) {
        if (this.insertAttributes == null) {
            this.insertAttributes = new ArrayList();
        }
        this.addToList(this.insertAttributes, pairs);
    }

    protected void populateAll(Pair ... pairs) {
        this.allAttributes = new ArrayList(this.insertAttributes);
        if (pairs != null && pairs.length > 0) {
            this.addToList(this.allAttributes, pairs);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(String.valueOf(this.getClass().toString()) + ".toString()");
        builder.append("\n");
        for (Pair<?> pair : this.allAttributes) {
            builder.append(pair.k());
            builder.append(" : ");
            builder.append(pair.valueAsString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public List<Pair<?>> getInsertAttributes() {
        return this.insertAttributes;
    }

    protected abstract void init();

    public int getHashCode() {
        int result2 = 0;
        for (Pair<?> pair : this.allAttributes) {
            result2 += pair.hashCode();
        }
        return result2;
    }
}

