/*
 * Decompiled with CFR 0.152.
 */
package de.mein.thread;

import de.mein.DeferredRunnable;
import de.mein.MeinRunnable;
import de.mein.MeinThread;
import de.mein.sql.RWLock;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ThreadTest {
    private Semaphore threadSemaphore = new Semaphore(1, true);
    private LinkedList<MeinThread> threadQueue = new LinkedList();
    private ExecutorService executorService;

    @Before
    public void prepare() {
        this.executorService = Executors.newCachedThreadPool(r -> {
            MeinThread meinThread = null;
            try {
                this.threadSemaphore.acquire();
                meinThread = this.threadQueue.poll();
                this.threadSemaphore.release();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return meinThread;
        });
    }

    @Test
    public void interrupt() {
        final RWLock threadLock = new RWLock();
        RWLock endLock = new RWLock();
        threadLock.lockWrite();
        final DeferredRunnable meinRunnable1 = new DeferredRunnable(){

            @Override
            public String getRunnableName() {
                return "runnable1";
            }

            @Override
            public void onShutDown() {
                System.out.println("ThreadTest.onShutDown1");
            }

            @Override
            public void runImpl() {
                System.out.println("ThreadTest.run1.lock");
                int i = 0;
                while (!Thread.currentThread().isInterrupted()) {
                    ++i;
                }
                System.out.println("ThreadTest.run1.stopped");
                threadLock.unlockWrite();
            }
        };
        DeferredRunnable meinRunnable2 = new DeferredRunnable(){

            @Override
            public String getRunnableName() {
                return "runnable2";
            }

            @Override
            public void onShutDown() {
                System.out.println("ThreadTest.onShutDown2");
            }

            @Override
            public void runImpl() {
                meinRunnable1.shutDown();
            }
        };
        this.execute(meinRunnable1);
        this.execute(meinRunnable2);
        threadLock.lockWrite();
    }

    public void execute(MeinRunnable runnable) {
        try {
            this.threadSemaphore.acquire();
            this.threadQueue.add(new MeinThread(runnable));
            this.threadSemaphore.release();
            this.executorService.execute(runnable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @After
    public void after() {
        this.executorService.shutdownNow();
    }

    class TestThread
    extends MeinThread {
        public TestThread(MeinRunnable target) {
            super(target);
        }

        @Override
        public synchronized void start() {
            System.out.println("TestThread.start");
            super.start();
        }

        @Override
        public void interrupt() {
            System.out.println("TestThread.interrupt");
            super.interrupt();
        }

        @Override
        public boolean isInterrupted() {
            return super.isInterrupted();
        }

        public void destroy() {
            System.out.println("TestThread.destroy");
            super.destroy();
        }

        @Override
        public int countStackFrames() {
            System.out.println("TestThread.countStackFrames");
            return super.countStackFrames();
        }
    }
}

