/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java8.lang.Integers;
import java8.lang.Longs;
import java8.util.Comparators$$Lambda$1;
import java8.util.Comparators$$Lambda$2;
import java8.util.Comparators$$Lambda$3;
import java8.util.Comparators$$Lambda$4;
import java8.util.Comparators$$Lambda$5;
import java8.util.Comparators$$Lambda$6;
import java8.util.Objects;
import java8.util.function.Function;
import java8.util.function.ToDoubleFunction;
import java8.util.function.ToIntFunction;
import java8.util.function.ToLongFunction;

public final class Comparators {
    public static <T extends Comparable<? super T>> Comparator<T> reverseOrder() {
        return Collections.reverseOrder();
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return NaturalOrderComparator.INSTANCE;
    }

    public static <T, U> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return (Comparator)((Object)((Serializable)((Object)Comparators$$Lambda$1.lambdaFactory$(keyComparator, keyExtractor))));
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (Comparator)((Object)((Serializable)((Object)Comparators$$Lambda$2.lambdaFactory$(keyExtractor))));
    }

    public static <T> Comparator<T> comparingInt(ToIntFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (Comparator)((Object)((Serializable)((Object)Comparators$$Lambda$3.lambdaFactory$(keyExtractor))));
    }

    public static <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (Comparator)((Object)((Serializable)((Object)Comparators$$Lambda$4.lambdaFactory$(keyExtractor))));
    }

    public static <T> Comparator<T> comparingDouble(ToDoubleFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (Comparator)((Object)((Serializable)((Object)Comparators$$Lambda$5.lambdaFactory$(keyExtractor))));
    }

    public static <T> Comparator<T> thenComparing(Comparator<? super T> this_, Comparator<? super T> other) {
        Objects.requireNonNull(this_);
        Objects.requireNonNull(other);
        if (this_ instanceof NullComparator) {
            return ((NullComparator)this_).thenComparing(other);
        }
        return (Comparator)((Object)((Serializable)((Object)Comparators$$Lambda$6.lambdaFactory$(this_, other))));
    }

    public static <T, U> Comparator<T> thenComparing(Comparator<? super T> this_, Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        return Comparators.thenComparing(this_, Comparators.comparing(keyExtractor, keyComparator));
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> thenComparing(Comparator<? super T> this_, Function<? super T, ? extends U> keyExtractor) {
        return Comparators.thenComparing(this_, Comparators.comparing(keyExtractor));
    }

    public static <T> Comparator<T> thenComparingInt(Comparator<? super T> this_, ToIntFunction<? super T> keyExtractor) {
        return Comparators.thenComparing(this_, Comparators.comparingInt(keyExtractor));
    }

    public static <T> Comparator<T> thenComparingLong(Comparator<? super T> this_, ToLongFunction<? super T> keyExtractor) {
        return Comparators.thenComparing(this_, Comparators.comparingLong(keyExtractor));
    }

    public static <T> Comparator<T> thenComparingDouble(Comparator<? super T> this_, ToDoubleFunction<? super T> keyExtractor) {
        return Comparators.thenComparing(this_, Comparators.comparingDouble(keyExtractor));
    }

    public static <T> Comparator<T> reversed(Comparator<T> comparator) {
        if (comparator instanceof NullComparator) {
            return ((NullComparator)comparator).reversed();
        }
        return Collections.reverseOrder(comparator);
    }

    public static <T> Comparator<T> nullsFirst(Comparator<? super T> comparator) {
        return new NullComparator<T>(true, comparator);
    }

    public static <T> Comparator<T> nullsLast(Comparator<? super T> comparator) {
        return new NullComparator<T>(false, comparator);
    }

    private Comparators() {
    }

    private static /* synthetic */ int lambda$thenComparing$aafead48$1(Comparator comparator, Comparator comparator2, Object c1, Object c2) {
        int res = comparator.compare(c1, c2);
        return res != 0 ? res : comparator2.compare(c1, c2);
    }

    private static /* synthetic */ int lambda$comparingDouble$57709dbc$1(ToDoubleFunction toDoubleFunction, Object c1, Object c2) {
        return Double.compare(toDoubleFunction.applyAsDouble(c1), toDoubleFunction.applyAsDouble(c2));
    }

    private static /* synthetic */ int lambda$comparingLong$c3a37e6$1(ToLongFunction toLongFunction, Object c1, Object c2) {
        return Longs.compare(toLongFunction.applyAsLong(c1), toLongFunction.applyAsLong(c2));
    }

    private static /* synthetic */ int lambda$comparingInt$134fc06a$1(ToIntFunction toIntFunction, Object c1, Object c2) {
        return Integers.compare(toIntFunction.applyAsInt(c1), toIntFunction.applyAsInt(c2));
    }

    private static /* synthetic */ int lambda$comparing$628f93f7$1(Function function, Object c1, Object c2) {
        return ((Comparable)function.apply(c1)).compareTo(function.apply(c2));
    }

    static /* synthetic */ int access$lambda$0(Comparator comparator, Function function, Object object, Object object2) {
        return comparator.compare(function.apply(object), function.apply(object2));
    }

    static /* synthetic */ int access$lambda$1(Function function, Object object, Object object2) {
        return Comparators.lambda$comparing$628f93f7$1(function, object, object2);
    }

    static /* synthetic */ int access$lambda$2(ToIntFunction toIntFunction, Object object, Object object2) {
        return Comparators.lambda$comparingInt$134fc06a$1(toIntFunction, object, object2);
    }

    static /* synthetic */ int access$lambda$3(ToLongFunction toLongFunction, Object object, Object object2) {
        return Comparators.lambda$comparingLong$c3a37e6$1(toLongFunction, object, object2);
    }

    static /* synthetic */ int access$lambda$4(ToDoubleFunction toDoubleFunction, Object object, Object object2) {
        return Comparators.lambda$comparingDouble$57709dbc$1(toDoubleFunction, object, object2);
    }

    static /* synthetic */ int access$lambda$5(Comparator comparator, Comparator comparator2, Object object, Object object2) {
        return Comparators.lambda$thenComparing$aafead48$1(comparator, comparator2, object, object2);
    }

    private static final class NullComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = -7569533591570686392L;
        private final boolean nullFirst;
        private final Comparator<T> real;

        NullComparator(boolean nullFirst, Comparator<? super T> real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(T a2, T b2) {
            if (a2 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real == null ? 0 : this.real.compare(a2, b2);
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            Objects.requireNonNull(other);
            return new NullComparator<T>(this.nullFirst, this.real == null ? other : Comparators.thenComparing(this.real, other));
        }

        @Override
        public Comparator<T> reversed() {
            return new NullComparator<T>(!this.nullFirst, this.real == null ? null : Collections.reverseOrder(this.real));
        }
    }

    private static enum NaturalOrderComparator implements Comparator<Comparable<Object>>
    {
        INSTANCE;


        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c1.compareTo(c2);
        }

        @Override
        public Comparator<Comparable<Object>> reversed() {
            return Comparators.reverseOrder();
        }
    }
}

