/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

final class DualPivotQuicksort {
    private static final int MAX_RUN_COUNT = 67;
    private static final int QUICKSORT_THRESHOLD = 286;
    private static final int INSERTION_SORT_THRESHOLD = 47;
    private static final int COUNTING_SORT_THRESHOLD_FOR_BYTE = 29;
    private static final int COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR = 3200;
    private static final int NUM_SHORT_VALUES = 65536;
    private static final int NUM_CHAR_VALUES = 65536;
    private static final int NUM_BYTE_VALUES = 256;

    private DualPivotQuicksort() {
    }

    static void sort(int[] a2, int left, int right, int[] work, int workBase, int workLen) {
        int ao;
        int bo;
        int[] b2;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a2, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a2[k] == a2[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a2[k] < a2[k + 1]) {
                while (++k <= right && a2[k - 1] <= a2[k]) {
                }
            } else if (a2[k] > a2[k + 1]) {
                while (++k <= right && a2[k - 1] >= a2[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    int t = a2[lo];
                    a2[lo] = a2[hi];
                    a2[hi] = t;
                }
            }
            if (run[count] > left && a2[run[count]] >= a2[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a2, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (count == 0) {
            return;
        }
        if (count == 1 && run[count] > right) {
            return;
        }
        if (run[count] < ++right) {
            run[++count] = right;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new int[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a2, left, work, workBase, blen);
            b2 = a2;
            bo = 0;
            a2 = work;
            ao = workBase - left;
        } else {
            b2 = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b2[i + bo] = q >= hi || p < mi && a2[p + ao] <= a2[q + ao] ? a2[p++ + ao] : a2[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b2[i + bo] = a2[i + ao];
                }
                run[++last] = right;
            }
            int[] t = a2;
            a2 = b2;
            b2 = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(int[] a2, int left, int right, boolean leftmost) {
        int t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    int ai = a2[i + 1];
                    while (ai < a2[j]) {
                        a2[j + 1] = a2[j];
                        if (j-- != left) continue;
                    }
                    a2[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a2[++left] >= a2[left - 1]);
                int k = left;
                while (++left <= right) {
                    int a1 = a2[k];
                    int a22 = a2[left];
                    if (a1 < a22) {
                        a22 = a1;
                        a1 = a2[left];
                    }
                    while (a1 < a2[--k]) {
                        a2[k + 2] = a2[k];
                    }
                    a2[++k + 1] = a1;
                    while (a22 < a2[--k]) {
                        a2[k + 1] = a2[k];
                    }
                    a2[k + 1] = a22;
                    k = ++left;
                }
                int last = a2[right];
                while (last < a2[--right]) {
                    a2[right + 1] = a2[right];
                }
                a2[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a2[e2] < a2[e1]) {
            t = a2[e2];
            a2[e2] = a2[e1];
            a2[e1] = t;
        }
        if (a2[e3] < a2[e2]) {
            t = a2[e3];
            a2[e3] = a2[e2];
            a2[e2] = t;
            if (t < a2[e1]) {
                a2[e2] = a2[e1];
                a2[e1] = t;
            }
        }
        if (a2[e4] < a2[e3]) {
            t = a2[e4];
            a2[e4] = a2[e3];
            a2[e3] = t;
            if (t < a2[e2]) {
                a2[e3] = a2[e2];
                a2[e2] = t;
                if (t < a2[e1]) {
                    a2[e2] = a2[e1];
                    a2[e1] = t;
                }
            }
        }
        if (a2[e5] < a2[e4]) {
            t = a2[e5];
            a2[e5] = a2[e4];
            a2[e4] = t;
            if (t < a2[e3]) {
                a2[e4] = a2[e3];
                a2[e3] = t;
                if (t < a2[e2]) {
                    a2[e3] = a2[e2];
                    a2[e2] = t;
                    if (t < a2[e1]) {
                        a2[e2] = a2[e1];
                        a2[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a2[e1] != a2[e2] && a2[e2] != a2[e3] && a2[e3] != a2[e4] && a2[e4] != a2[e5]) {
            int ak;
            int pivot1 = a2[e2];
            int pivot2 = a2[e4];
            a2[e2] = a2[left];
            a2[e4] = a2[right];
            while (a2[++less] < pivot1) {
            }
            while (a2[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a2[k];
                if (ak < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a2[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a2[great] < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = a2[great];
                }
                a2[great] = ak;
                --great;
            }
            a2[left] = a2[less - 1];
            a2[less - 1] = pivot1;
            a2[right] = a2[great + 1];
            a2[great + 1] = pivot2;
            DualPivotQuicksort.sort(a2, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a2, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a2[less] == pivot1) {
                    ++less;
                }
                while (a2[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a2[k];
                    if (ak == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a2[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a2[great] == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = pivot1;
                        ++less;
                    } else {
                        a2[k] = a2[great];
                    }
                    a2[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a2, less, great, false);
        } else {
            int pivot = a2[e3];
            for (int k = less; k <= great; ++k) {
                if (a2[k] == pivot) continue;
                int ak = a2[k];
                if (ak < pivot) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                while (a2[great] > pivot) {
                    --great;
                }
                if (a2[great] < pivot) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = pivot;
                }
                a2[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a2, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a2, great + 1, right, false);
        }
    }

    static void sort(long[] a2, int left, int right, long[] work, int workBase, int workLen) {
        int ao;
        int bo;
        long[] b2;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a2, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a2[k] == a2[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a2[k] < a2[k + 1]) {
                while (++k <= right && a2[k - 1] <= a2[k]) {
                }
            } else if (a2[k] > a2[k + 1]) {
                while (++k <= right && a2[k - 1] >= a2[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    long t = a2[lo];
                    a2[lo] = a2[hi];
                    a2[hi] = t;
                }
            }
            if (run[count] > left && a2[run[count]] >= a2[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a2, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (count == 0) {
            return;
        }
        if (count == 1 && run[count] > right) {
            return;
        }
        if (run[count] < ++right) {
            run[++count] = right;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new long[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a2, left, work, workBase, blen);
            b2 = a2;
            bo = 0;
            a2 = work;
            ao = workBase - left;
        } else {
            b2 = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b2[i + bo] = q >= hi || p < mi && a2[p + ao] <= a2[q + ao] ? a2[p++ + ao] : a2[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b2[i + bo] = a2[i + ao];
                }
                run[++last] = right;
            }
            long[] t = a2;
            a2 = b2;
            b2 = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(long[] a2, int left, int right, boolean leftmost) {
        long t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    long ai = a2[i + 1];
                    while (ai < a2[j]) {
                        a2[j + 1] = a2[j];
                        if (j-- != left) continue;
                    }
                    a2[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a2[++left] >= a2[left - 1]);
                int k = left;
                while (++left <= right) {
                    long a1 = a2[k];
                    long a22 = a2[left];
                    if (a1 < a22) {
                        a22 = a1;
                        a1 = a2[left];
                    }
                    while (a1 < a2[--k]) {
                        a2[k + 2] = a2[k];
                    }
                    a2[++k + 1] = a1;
                    while (a22 < a2[--k]) {
                        a2[k + 1] = a2[k];
                    }
                    a2[k + 1] = a22;
                    k = ++left;
                }
                long last = a2[right];
                while (last < a2[--right]) {
                    a2[right + 1] = a2[right];
                }
                a2[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a2[e2] < a2[e1]) {
            t = a2[e2];
            a2[e2] = a2[e1];
            a2[e1] = t;
        }
        if (a2[e3] < a2[e2]) {
            t = a2[e3];
            a2[e3] = a2[e2];
            a2[e2] = t;
            if (t < a2[e1]) {
                a2[e2] = a2[e1];
                a2[e1] = t;
            }
        }
        if (a2[e4] < a2[e3]) {
            t = a2[e4];
            a2[e4] = a2[e3];
            a2[e3] = t;
            if (t < a2[e2]) {
                a2[e3] = a2[e2];
                a2[e2] = t;
                if (t < a2[e1]) {
                    a2[e2] = a2[e1];
                    a2[e1] = t;
                }
            }
        }
        if (a2[e5] < a2[e4]) {
            t = a2[e5];
            a2[e5] = a2[e4];
            a2[e4] = t;
            if (t < a2[e3]) {
                a2[e4] = a2[e3];
                a2[e3] = t;
                if (t < a2[e2]) {
                    a2[e3] = a2[e2];
                    a2[e2] = t;
                    if (t < a2[e1]) {
                        a2[e2] = a2[e1];
                        a2[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a2[e1] != a2[e2] && a2[e2] != a2[e3] && a2[e3] != a2[e4] && a2[e4] != a2[e5]) {
            long ak;
            long pivot1 = a2[e2];
            long pivot2 = a2[e4];
            a2[e2] = a2[left];
            a2[e4] = a2[right];
            while (a2[++less] < pivot1) {
            }
            while (a2[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a2[k];
                if (ak < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a2[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a2[great] < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = a2[great];
                }
                a2[great] = ak;
                --great;
            }
            a2[left] = a2[less - 1];
            a2[less - 1] = pivot1;
            a2[right] = a2[great + 1];
            a2[great + 1] = pivot2;
            DualPivotQuicksort.sort(a2, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a2, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a2[less] == pivot1) {
                    ++less;
                }
                while (a2[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a2[k];
                    if (ak == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a2[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a2[great] == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = pivot1;
                        ++less;
                    } else {
                        a2[k] = a2[great];
                    }
                    a2[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a2, less, great, false);
        } else {
            long pivot = a2[e3];
            for (int k = less; k <= great; ++k) {
                if (a2[k] == pivot) continue;
                long ak = a2[k];
                if (ak < pivot) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                while (a2[great] > pivot) {
                    --great;
                }
                if (a2[great] < pivot) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = pivot;
                }
                a2[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a2, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a2, great + 1, right, false);
        }
    }

    static void sort(short[] a2, int left, int right, short[] work, int workBase, int workLen) {
        if (right - left > 3200) {
            int[] count = new int[65536];
            int i = left - 1;
            while (++i <= right) {
                int n = a2[i] - Short.MIN_VALUE;
                count[n] = count[n] + 1;
            }
            i = 65536;
            int k = right + 1;
            while (k > left) {
                while (count[--i] == 0) {
                }
                short value = (short)(i + Short.MIN_VALUE);
                int s = count[i];
                do {
                    a2[--k] = value;
                } while (--s > 0);
            }
        } else {
            DualPivotQuicksort.doSort(a2, left, right, work, workBase, workLen);
        }
    }

    private static void doSort(short[] a2, int left, int right, short[] work, int workBase, int workLen) {
        int ao;
        int bo;
        short[] b2;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a2, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a2[k] == a2[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a2[k] < a2[k + 1]) {
                while (++k <= right && a2[k - 1] <= a2[k]) {
                }
            } else if (a2[k] > a2[k + 1]) {
                while (++k <= right && a2[k - 1] >= a2[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    short t = a2[lo];
                    a2[lo] = a2[hi];
                    a2[hi] = t;
                }
            }
            if (run[count] > left && a2[run[count]] >= a2[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a2, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (count == 0) {
            return;
        }
        if (count == 1 && run[count] > right) {
            return;
        }
        if (run[count] < ++right) {
            run[++count] = right;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new short[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a2, left, work, workBase, blen);
            b2 = a2;
            bo = 0;
            a2 = work;
            ao = workBase - left;
        } else {
            b2 = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b2[i + bo] = q >= hi || p < mi && a2[p + ao] <= a2[q + ao] ? a2[p++ + ao] : a2[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b2[i + bo] = a2[i + ao];
                }
                run[++last] = right;
            }
            short[] t = a2;
            a2 = b2;
            b2 = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(short[] a2, int left, int right, boolean leftmost) {
        short t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    short ai = a2[i + 1];
                    while (ai < a2[j]) {
                        a2[j + 1] = a2[j];
                        if (j-- != left) continue;
                    }
                    a2[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a2[++left] >= a2[left - 1]);
                int k = left;
                while (++left <= right) {
                    short a1 = a2[k];
                    short a22 = a2[left];
                    if (a1 < a22) {
                        a22 = a1;
                        a1 = a2[left];
                    }
                    while (a1 < a2[--k]) {
                        a2[k + 2] = a2[k];
                    }
                    a2[++k + 1] = a1;
                    while (a22 < a2[--k]) {
                        a2[k + 1] = a2[k];
                    }
                    a2[k + 1] = a22;
                    k = ++left;
                }
                short last = a2[right];
                while (last < a2[--right]) {
                    a2[right + 1] = a2[right];
                }
                a2[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a2[e2] < a2[e1]) {
            t = a2[e2];
            a2[e2] = a2[e1];
            a2[e1] = t;
        }
        if (a2[e3] < a2[e2]) {
            t = a2[e3];
            a2[e3] = a2[e2];
            a2[e2] = t;
            if (t < a2[e1]) {
                a2[e2] = a2[e1];
                a2[e1] = t;
            }
        }
        if (a2[e4] < a2[e3]) {
            t = a2[e4];
            a2[e4] = a2[e3];
            a2[e3] = t;
            if (t < a2[e2]) {
                a2[e3] = a2[e2];
                a2[e2] = t;
                if (t < a2[e1]) {
                    a2[e2] = a2[e1];
                    a2[e1] = t;
                }
            }
        }
        if (a2[e5] < a2[e4]) {
            t = a2[e5];
            a2[e5] = a2[e4];
            a2[e4] = t;
            if (t < a2[e3]) {
                a2[e4] = a2[e3];
                a2[e3] = t;
                if (t < a2[e2]) {
                    a2[e3] = a2[e2];
                    a2[e2] = t;
                    if (t < a2[e1]) {
                        a2[e2] = a2[e1];
                        a2[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a2[e1] != a2[e2] && a2[e2] != a2[e3] && a2[e3] != a2[e4] && a2[e4] != a2[e5]) {
            short ak;
            short pivot1 = a2[e2];
            short pivot2 = a2[e4];
            a2[e2] = a2[left];
            a2[e4] = a2[right];
            while (a2[++less] < pivot1) {
            }
            while (a2[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a2[k];
                if (ak < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a2[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a2[great] < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = a2[great];
                }
                a2[great] = ak;
                --great;
            }
            a2[left] = a2[less - 1];
            a2[less - 1] = pivot1;
            a2[right] = a2[great + 1];
            a2[great + 1] = pivot2;
            DualPivotQuicksort.sort(a2, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a2, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a2[less] == pivot1) {
                    ++less;
                }
                while (a2[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a2[k];
                    if (ak == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a2[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a2[great] == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = pivot1;
                        ++less;
                    } else {
                        a2[k] = a2[great];
                    }
                    a2[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a2, less, great, false);
        } else {
            short pivot = a2[e3];
            for (int k = less; k <= great; ++k) {
                if (a2[k] == pivot) continue;
                short ak = a2[k];
                if (ak < pivot) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                while (a2[great] > pivot) {
                    --great;
                }
                if (a2[great] < pivot) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = pivot;
                }
                a2[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a2, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a2, great + 1, right, false);
        }
    }

    static void sort(char[] a2, int left, int right, char[] work, int workBase, int workLen) {
        if (right - left > 3200) {
            int[] count = new int[65536];
            int i = left - 1;
            while (++i <= right) {
                char c2 = a2[i];
                count[c2] = count[c2] + 1;
            }
            i = 65536;
            int k = right + 1;
            while (k > left) {
                while (count[--i] == 0) {
                }
                char value = (char)i;
                int s = count[i];
                do {
                    a2[--k] = value;
                } while (--s > 0);
            }
        } else {
            DualPivotQuicksort.doSort(a2, left, right, work, workBase, workLen);
        }
    }

    private static void doSort(char[] a2, int left, int right, char[] work, int workBase, int workLen) {
        int ao;
        int bo;
        char[] b2;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a2, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a2[k] == a2[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a2[k] < a2[k + 1]) {
                while (++k <= right && a2[k - 1] <= a2[k]) {
                }
            } else if (a2[k] > a2[k + 1]) {
                while (++k <= right && a2[k - 1] >= a2[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    char t = a2[lo];
                    a2[lo] = a2[hi];
                    a2[hi] = t;
                }
            }
            if (run[count] > left && a2[run[count]] >= a2[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a2, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (count == 0) {
            return;
        }
        if (count == 1 && run[count] > right) {
            return;
        }
        if (run[count] < ++right) {
            run[++count] = right;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new char[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a2, left, work, workBase, blen);
            b2 = a2;
            bo = 0;
            a2 = work;
            ao = workBase - left;
        } else {
            b2 = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b2[i + bo] = q >= hi || p < mi && a2[p + ao] <= a2[q + ao] ? a2[p++ + ao] : a2[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b2[i + bo] = a2[i + ao];
                }
                run[++last] = right;
            }
            char[] t = a2;
            a2 = b2;
            b2 = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(char[] a2, int left, int right, boolean leftmost) {
        char t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    char ai = a2[i + 1];
                    while (ai < a2[j]) {
                        a2[j + 1] = a2[j];
                        if (j-- != left) continue;
                    }
                    a2[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a2[++left] >= a2[left - 1]);
                int k = left;
                while (++left <= right) {
                    char a1 = a2[k];
                    char a22 = a2[left];
                    if (a1 < a22) {
                        a22 = a1;
                        a1 = a2[left];
                    }
                    while (a1 < a2[--k]) {
                        a2[k + 2] = a2[k];
                    }
                    a2[++k + 1] = a1;
                    while (a22 < a2[--k]) {
                        a2[k + 1] = a2[k];
                    }
                    a2[k + 1] = a22;
                    k = ++left;
                }
                char last = a2[right];
                while (last < a2[--right]) {
                    a2[right + 1] = a2[right];
                }
                a2[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a2[e2] < a2[e1]) {
            t = a2[e2];
            a2[e2] = a2[e1];
            a2[e1] = t;
        }
        if (a2[e3] < a2[e2]) {
            t = a2[e3];
            a2[e3] = a2[e2];
            a2[e2] = t;
            if (t < a2[e1]) {
                a2[e2] = a2[e1];
                a2[e1] = t;
            }
        }
        if (a2[e4] < a2[e3]) {
            t = a2[e4];
            a2[e4] = a2[e3];
            a2[e3] = t;
            if (t < a2[e2]) {
                a2[e3] = a2[e2];
                a2[e2] = t;
                if (t < a2[e1]) {
                    a2[e2] = a2[e1];
                    a2[e1] = t;
                }
            }
        }
        if (a2[e5] < a2[e4]) {
            t = a2[e5];
            a2[e5] = a2[e4];
            a2[e4] = t;
            if (t < a2[e3]) {
                a2[e4] = a2[e3];
                a2[e3] = t;
                if (t < a2[e2]) {
                    a2[e3] = a2[e2];
                    a2[e2] = t;
                    if (t < a2[e1]) {
                        a2[e2] = a2[e1];
                        a2[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a2[e1] != a2[e2] && a2[e2] != a2[e3] && a2[e3] != a2[e4] && a2[e4] != a2[e5]) {
            char ak;
            char pivot1 = a2[e2];
            char pivot2 = a2[e4];
            a2[e2] = a2[left];
            a2[e4] = a2[right];
            while (a2[++less] < pivot1) {
            }
            while (a2[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a2[k];
                if (ak < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a2[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a2[great] < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = a2[great];
                }
                a2[great] = ak;
                --great;
            }
            a2[left] = a2[less - 1];
            a2[less - 1] = pivot1;
            a2[right] = a2[great + 1];
            a2[great + 1] = pivot2;
            DualPivotQuicksort.sort(a2, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a2, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a2[less] == pivot1) {
                    ++less;
                }
                while (a2[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a2[k];
                    if (ak == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a2[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a2[great] == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = pivot1;
                        ++less;
                    } else {
                        a2[k] = a2[great];
                    }
                    a2[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a2, less, great, false);
        } else {
            char pivot = a2[e3];
            for (int k = less; k <= great; ++k) {
                if (a2[k] == pivot) continue;
                char ak = a2[k];
                if (ak < pivot) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                while (a2[great] > pivot) {
                    --great;
                }
                if (a2[great] < pivot) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = pivot;
                }
                a2[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a2, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a2, great + 1, right, false);
        }
    }

    static void sort(byte[] a2, int left, int right) {
        if (right - left > 29) {
            int[] count = new int[256];
            int i = left - 1;
            while (++i <= right) {
                int n = a2[i] - -128;
                count[n] = count[n] + 1;
            }
            i = 256;
            int k = right + 1;
            while (k > left) {
                while (count[--i] == 0) {
                }
                byte value = (byte)(i + -128);
                int s = count[i];
                do {
                    a2[--k] = value;
                } while (--s > 0);
            }
        } else {
            int i;
            int j = i = left;
            while (i < right) {
                byte ai = a2[i + 1];
                while (ai < a2[j]) {
                    a2[j + 1] = a2[j];
                    if (j-- != left) continue;
                }
                a2[j + 1] = ai;
                j = ++i;
            }
        }
    }

    static void sort(float[] a2, int left, int right, float[] work, int workBase, int workLen) {
        float ak;
        while (left <= right && Float.isNaN(a2[right])) {
            --right;
        }
        int k = right;
        while (--k >= left) {
            float ak2 = a2[k];
            if (ak2 == ak2) continue;
            a2[k] = a2[right];
            a2[right] = ak2;
            --right;
        }
        DualPivotQuicksort.doSort(a2, left, right, work, workBase, workLen);
        int hi = right;
        while (left < hi) {
            int middle = left + hi >>> 1;
            float middleValue = a2[middle];
            if (middleValue < 0.0f) {
                left = middle + 1;
                continue;
            }
            hi = middle;
        }
        while (left <= right && Float.floatToRawIntBits(a2[left]) < 0) {
            ++left;
        }
        int k2 = left;
        int p = left - 1;
        while (++k2 <= right && (ak = a2[k2]) == 0.0f) {
            if (Float.floatToRawIntBits(ak) >= 0) continue;
            a2[k2] = 0.0f;
            a2[++p] = -0.0f;
        }
    }

    private static void doSort(float[] a2, int left, int right, float[] work, int workBase, int workLen) {
        int ao;
        int bo;
        float[] b2;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a2, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a2[k] == a2[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a2[k] < a2[k + 1]) {
                while (++k <= right && a2[k - 1] <= a2[k]) {
                }
            } else if (a2[k] > a2[k + 1]) {
                while (++k <= right && a2[k - 1] >= a2[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    float t = a2[lo];
                    a2[lo] = a2[hi];
                    a2[hi] = t;
                }
            }
            if (run[count] > left && a2[run[count]] >= a2[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a2, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (count == 0) {
            return;
        }
        if (count == 1 && run[count] > right) {
            return;
        }
        if (run[count] < ++right) {
            run[++count] = right;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new float[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a2, left, work, workBase, blen);
            b2 = a2;
            bo = 0;
            a2 = work;
            ao = workBase - left;
        } else {
            b2 = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b2[i + bo] = q >= hi || p < mi && a2[p + ao] <= a2[q + ao] ? a2[p++ + ao] : a2[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b2[i + bo] = a2[i + ao];
                }
                run[++last] = right;
            }
            float[] t = a2;
            a2 = b2;
            b2 = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(float[] a2, int left, int right, boolean leftmost) {
        float t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    float ai = a2[i + 1];
                    while (ai < a2[j]) {
                        a2[j + 1] = a2[j];
                        if (j-- != left) continue;
                    }
                    a2[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a2[++left] >= a2[left - 1]);
                int k = left;
                while (++left <= right) {
                    float a1 = a2[k];
                    float a22 = a2[left];
                    if (a1 < a22) {
                        a22 = a1;
                        a1 = a2[left];
                    }
                    while (a1 < a2[--k]) {
                        a2[k + 2] = a2[k];
                    }
                    a2[++k + 1] = a1;
                    while (a22 < a2[--k]) {
                        a2[k + 1] = a2[k];
                    }
                    a2[k + 1] = a22;
                    k = ++left;
                }
                float last = a2[right];
                while (last < a2[--right]) {
                    a2[right + 1] = a2[right];
                }
                a2[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a2[e2] < a2[e1]) {
            t = a2[e2];
            a2[e2] = a2[e1];
            a2[e1] = t;
        }
        if (a2[e3] < a2[e2]) {
            t = a2[e3];
            a2[e3] = a2[e2];
            a2[e2] = t;
            if (t < a2[e1]) {
                a2[e2] = a2[e1];
                a2[e1] = t;
            }
        }
        if (a2[e4] < a2[e3]) {
            t = a2[e4];
            a2[e4] = a2[e3];
            a2[e3] = t;
            if (t < a2[e2]) {
                a2[e3] = a2[e2];
                a2[e2] = t;
                if (t < a2[e1]) {
                    a2[e2] = a2[e1];
                    a2[e1] = t;
                }
            }
        }
        if (a2[e5] < a2[e4]) {
            t = a2[e5];
            a2[e5] = a2[e4];
            a2[e4] = t;
            if (t < a2[e3]) {
                a2[e4] = a2[e3];
                a2[e3] = t;
                if (t < a2[e2]) {
                    a2[e3] = a2[e2];
                    a2[e2] = t;
                    if (t < a2[e1]) {
                        a2[e2] = a2[e1];
                        a2[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a2[e1] != a2[e2] && a2[e2] != a2[e3] && a2[e3] != a2[e4] && a2[e4] != a2[e5]) {
            float ak;
            float pivot1 = a2[e2];
            float pivot2 = a2[e4];
            a2[e2] = a2[left];
            a2[e4] = a2[right];
            while (a2[++less] < pivot1) {
            }
            while (a2[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a2[k];
                if (ak < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                if (!(ak > pivot2)) continue;
                while (a2[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a2[great] < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = a2[great];
                }
                a2[great] = ak;
                --great;
            }
            a2[left] = a2[less - 1];
            a2[less - 1] = pivot1;
            a2[right] = a2[great + 1];
            a2[great + 1] = pivot2;
            DualPivotQuicksort.sort(a2, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a2, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a2[less] == pivot1) {
                    ++less;
                }
                while (a2[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a2[k];
                    if (ak == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a2[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a2[great] == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = a2[great];
                        ++less;
                    } else {
                        a2[k] = a2[great];
                    }
                    a2[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a2, less, great, false);
        } else {
            float pivot = a2[e3];
            for (int k = less; k <= great; ++k) {
                if (a2[k] == pivot) continue;
                float ak = a2[k];
                if (ak < pivot) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                while (a2[great] > pivot) {
                    --great;
                }
                if (a2[great] < pivot) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = a2[great];
                }
                a2[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a2, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a2, great + 1, right, false);
        }
    }

    static void sort(double[] a2, int left, int right, double[] work, int workBase, int workLen) {
        double ak;
        while (left <= right && Double.isNaN(a2[right])) {
            --right;
        }
        int k = right;
        while (--k >= left) {
            double ak2 = a2[k];
            if (ak2 == ak2) continue;
            a2[k] = a2[right];
            a2[right] = ak2;
            --right;
        }
        DualPivotQuicksort.doSort(a2, left, right, work, workBase, workLen);
        int hi = right;
        while (left < hi) {
            int middle = left + hi >>> 1;
            double middleValue = a2[middle];
            if (middleValue < 0.0) {
                left = middle + 1;
                continue;
            }
            hi = middle;
        }
        while (left <= right && Double.doubleToRawLongBits(a2[left]) < 0L) {
            ++left;
        }
        int k2 = left;
        int p = left - 1;
        while (++k2 <= right && (ak = a2[k2]) == 0.0) {
            if (Double.doubleToRawLongBits(ak) >= 0L) continue;
            a2[k2] = 0.0;
            a2[++p] = -0.0;
        }
    }

    private static void doSort(double[] a2, int left, int right, double[] work, int workBase, int workLen) {
        int ao;
        int bo;
        double[] b2;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a2, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            while (k < right && a2[k] == a2[k + 1]) {
                ++k;
            }
            if (k == right) break;
            if (a2[k] < a2[k + 1]) {
                while (++k <= right && a2[k - 1] <= a2[k]) {
                }
            } else if (a2[k] > a2[k + 1]) {
                while (++k <= right && a2[k - 1] >= a2[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    double t = a2[lo];
                    a2[lo] = a2[hi];
                    a2[hi] = t;
                }
            }
            if (run[count] > left && a2[run[count]] >= a2[run[count] - 1]) {
                --count;
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a2, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (count == 0) {
            return;
        }
        if (count == 1 && run[count] > right) {
            return;
        }
        if (run[count] < ++right) {
            run[++count] = right;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        int blen = right - left;
        if (work == null || workLen < blen || workBase + blen > work.length) {
            work = new double[blen];
            workBase = 0;
        }
        if (odd == 0) {
            System.arraycopy(a2, left, work, workBase, blen);
            b2 = a2;
            bo = 0;
            a2 = work;
            ao = workBase - left;
        } else {
            b2 = work;
            ao = 0;
            bo = workBase - left;
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b2[i + bo] = q >= hi || p < mi && a2[p + ao] <= a2[q + ao] ? a2[p++ + ao] : a2[q++ + ao];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b2[i + bo] = a2[i + ao];
                }
                run[++last] = right;
            }
            double[] t = a2;
            a2 = b2;
            b2 = t;
            int o = ao;
            ao = bo;
            bo = o;
            count = last;
        }
    }

    private static void sort(double[] a2, int left, int right, boolean leftmost) {
        double t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    double ai = a2[i + 1];
                    while (ai < a2[j]) {
                        a2[j + 1] = a2[j];
                        if (j-- != left) continue;
                    }
                    a2[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a2[++left] >= a2[left - 1]);
                int k = left;
                while (++left <= right) {
                    double a1 = a2[k];
                    double a22 = a2[left];
                    if (a1 < a22) {
                        a22 = a1;
                        a1 = a2[left];
                    }
                    while (a1 < a2[--k]) {
                        a2[k + 2] = a2[k];
                    }
                    a2[++k + 1] = a1;
                    while (a22 < a2[--k]) {
                        a2[k + 1] = a2[k];
                    }
                    a2[k + 1] = a22;
                    k = ++left;
                }
                double last = a2[right];
                while (last < a2[--right]) {
                    a2[right + 1] = a2[right];
                }
                a2[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a2[e2] < a2[e1]) {
            t = a2[e2];
            a2[e2] = a2[e1];
            a2[e1] = t;
        }
        if (a2[e3] < a2[e2]) {
            t = a2[e3];
            a2[e3] = a2[e2];
            a2[e2] = t;
            if (t < a2[e1]) {
                a2[e2] = a2[e1];
                a2[e1] = t;
            }
        }
        if (a2[e4] < a2[e3]) {
            t = a2[e4];
            a2[e4] = a2[e3];
            a2[e3] = t;
            if (t < a2[e2]) {
                a2[e3] = a2[e2];
                a2[e2] = t;
                if (t < a2[e1]) {
                    a2[e2] = a2[e1];
                    a2[e1] = t;
                }
            }
        }
        if (a2[e5] < a2[e4]) {
            t = a2[e5];
            a2[e5] = a2[e4];
            a2[e4] = t;
            if (t < a2[e3]) {
                a2[e4] = a2[e3];
                a2[e3] = t;
                if (t < a2[e2]) {
                    a2[e3] = a2[e2];
                    a2[e2] = t;
                    if (t < a2[e1]) {
                        a2[e2] = a2[e1];
                        a2[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a2[e1] != a2[e2] && a2[e2] != a2[e3] && a2[e3] != a2[e4] && a2[e4] != a2[e5]) {
            double ak;
            double pivot1 = a2[e2];
            double pivot2 = a2[e4];
            a2[e2] = a2[left];
            a2[e4] = a2[right];
            while (a2[++less] < pivot1) {
            }
            while (a2[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a2[k];
                if (ak < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                if (!(ak > pivot2)) continue;
                while (a2[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a2[great] < pivot1) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = a2[great];
                }
                a2[great] = ak;
                --great;
            }
            a2[left] = a2[less - 1];
            a2[less - 1] = pivot1;
            a2[right] = a2[great + 1];
            a2[great + 1] = pivot2;
            DualPivotQuicksort.sort(a2, left, less - 2, leftmost);
            DualPivotQuicksort.sort(a2, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a2[less] == pivot1) {
                    ++less;
                }
                while (a2[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a2[k];
                    if (ak == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a2[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a2[great] == pivot1) {
                        a2[k] = a2[less];
                        a2[less] = a2[great];
                        ++less;
                    } else {
                        a2[k] = a2[great];
                    }
                    a2[great] = ak;
                    --great;
                }
            }
            DualPivotQuicksort.sort(a2, less, great, false);
        } else {
            double pivot = a2[e3];
            for (int k = less; k <= great; ++k) {
                if (a2[k] == pivot) continue;
                double ak = a2[k];
                if (ak < pivot) {
                    a2[k] = a2[less];
                    a2[less] = ak;
                    ++less;
                    continue;
                }
                while (a2[great] > pivot) {
                    --great;
                }
                if (a2[great] < pivot) {
                    a2[k] = a2[less];
                    a2[less] = a2[great];
                    ++less;
                } else {
                    a2[k] = a2[great];
                }
                a2[great] = ak;
                --great;
            }
            DualPivotQuicksort.sort(a2, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a2, great + 1, right, false);
        }
    }
}

