/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.NoSuchElementException;
import java8.util.function.IntConsumer;
import java8.util.function.IntSupplier;
import java8.util.function.Supplier;
import java8.util.stream.IntStream;
import java8.util.stream.IntStreams;

public final class OptionalInt {
    private static final OptionalInt EMPTY = new OptionalInt();
    private final boolean isPresent;
    private final int value;

    private OptionalInt() {
        this.isPresent = false;
        this.value = 0;
    }

    public static OptionalInt empty() {
        return EMPTY;
    }

    OptionalInt(int value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalInt of(int value) {
        int offset = 128;
        if (value >= -128 && value <= 127) {
            return OICache.cache[value + offset];
        }
        return new OptionalInt(value);
    }

    public int getAsInt() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(IntConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(IntConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public IntStream stream() {
        if (this.isPresent) {
            return IntStreams.of(this.value);
        }
        return IntStreams.empty();
    }

    public int orElse(int other) {
        return this.isPresent ? this.value : other;
    }

    public int orElseGet(IntSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsInt();
    }

    public <X extends Throwable> int orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalInt)) {
            return false;
        }
        OptionalInt other = (OptionalInt)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? this.value : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalInt[%s]", this.value) : "OptionalInt.empty";
    }

    private static final class OICache {
        static final OptionalInt[] cache = new OptionalInt[256];

        private OICache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                OICache.cache[i] = new OptionalInt(i - 128);
            }
        }
    }
}

