/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.NoSuchElementException;
import java8.lang.Longs;
import java8.util.function.LongConsumer;
import java8.util.function.LongSupplier;
import java8.util.function.Supplier;
import java8.util.stream.LongStream;
import java8.util.stream.LongStreams;

public final class OptionalLong {
    private static final OptionalLong EMPTY = new OptionalLong();
    private final boolean isPresent;
    private final long value;

    private OptionalLong() {
        this.isPresent = false;
        this.value = 0L;
    }

    public static OptionalLong empty() {
        return EMPTY;
    }

    OptionalLong(long value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalLong of(long value) {
        int offset = 128;
        if (value >= -128L && value <= 127L) {
            return OLCache.cache[(int)value + offset];
        }
        return new OptionalLong(value);
    }

    public long getAsLong() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(LongConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(LongConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public LongStream stream() {
        if (this.isPresent) {
            return LongStreams.of(this.value);
        }
        return LongStreams.empty();
    }

    public long orElse(long other) {
        return this.isPresent ? this.value : other;
    }

    public long orElseGet(LongSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsLong();
    }

    public <X extends Throwable> long orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalLong)) {
            return false;
        }
        OptionalLong other = (OptionalLong)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? Longs.hashCode(this.value) : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalLong[%s]", this.value) : "OptionalLong.empty";
    }

    private static final class OLCache {
        static final OptionalLong[] cache = new OptionalLong[256];

        private OLCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                OLCache.cache[i] = new OptionalLong(i - 128);
            }
        }
    }
}

