/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java8.util.ArrayDequeSpliterator;
import java8.util.ArrayListSpliterator;
import java8.util.ArraysArrayListSpliterator;
import java8.util.COWArrayListSpliterator;
import java8.util.COWArraySetSpliterator;
import java8.util.DelegatingSpliterator;
import java8.util.HMSpliterators;
import java8.util.Iterators;
import java8.util.LBDSpliterator;
import java8.util.LBQSpliterator;
import java8.util.LinkedListSpliterator;
import java8.util.Objects;
import java8.util.PBQueueSpliterator;
import java8.util.PQueueSpliterator;
import java8.util.PrimitiveIterator;
import java8.util.RASpliterator;
import java8.util.Spliterator;
import java8.util.Spliterators$OfDouble$$Lambda$1;
import java8.util.Spliterators$OfDouble$$Lambda$2;
import java8.util.Spliterators$OfInt$$Lambda$1;
import java8.util.Spliterators$OfInt$$Lambda$2;
import java8.util.Spliterators$OfLong$$Lambda$1;
import java8.util.Spliterators$OfLong$$Lambda$2;
import java8.util.VectorSpliterator;
import java8.util.function.Consumer;
import java8.util.function.DoubleConsumer;
import java8.util.function.IntConsumer;
import java8.util.function.LongConsumer;

public final class Spliterators {
    private static final String NATIVE_OPT_ENABLED_P = Spliterators.class.getName() + ".assume.oracle.collections.impl";
    private static final String JRE_DELEGATION_ENABLED_P = Spliterators.class.getName() + ".jre.delegation.enabled";
    private static final String RNDACC_SPLITER_ENABLED_P = Spliterators.class.getName() + ".randomaccess.spliterator.enabled";
    static final boolean NATIVE_SPECIALIZATION = Spliterators.getBooleanPropVal(NATIVE_OPT_ENABLED_P, true);
    static final boolean JRE_DELEGATION_ENABLED = Spliterators.getBooleanPropVal(JRE_DELEGATION_ENABLED_P, true);
    private static final boolean ALLOW_RNDACC_SPLITER_OPT = Spliterators.getBooleanPropVal(RNDACC_SPLITER_ENABLED_P, true);
    private static final boolean IS_ROBOVM = Spliterators.isClassPresent("org.robovm.rt.bro.Bro");
    static final boolean IS_ANDROID = Spliterators.isClassPresent("android.util.DisplayMetrics") || IS_ROBOVM;
    static final boolean IS_HARMONY_ANDROID = IS_ANDROID && !Spliterators.isClassPresent("android.opengl.GLES32$DebugProc");
    static final boolean IS_JAVA6 = !IS_ANDROID && Spliterators.isJava6();
    static final boolean JRE_HAS_STREAMS = Spliterators.isStreamEnabledJRE();
    private static final Spliterator<Object> EMPTY_SPLITERATOR = new EmptySpliterator.OfRef<Object>();
    private static final Spliterator.OfInt EMPTY_INT_SPLITERATOR = new EmptySpliterator.OfInt();
    private static final Spliterator.OfLong EMPTY_LONG_SPLITERATOR = new EmptySpliterator.OfLong();
    private static final Spliterator.OfDouble EMPTY_DOUBLE_SPLITERATOR = new EmptySpliterator.OfDouble();

    private Spliterators() {
    }

    public static <T> void forEachRemaining(Spliterator<T> this_, Consumer<? super T> action) {
        while (this_.tryAdvance(action)) {
        }
    }

    public static <T> long getExactSizeIfKnown(Spliterator<T> this_) {
        return (this_.characteristics() & 0x40) == 0 ? -1L : this_.estimateSize();
    }

    public static <T> boolean hasCharacteristics(Spliterator<T> this_, int characteristics) {
        return (this_.characteristics() & characteristics) == characteristics;
    }

    public static <T> Comparator<? super T> getComparator(Spliterator<T> this_) {
        throw new IllegalStateException();
    }

    public static <T> Spliterator<T> emptySpliterator() {
        return EMPTY_SPLITERATOR;
    }

    public static Spliterator.OfInt emptyIntSpliterator() {
        return EMPTY_INT_SPLITERATOR;
    }

    public static Spliterator.OfLong emptyLongSpliterator() {
        return EMPTY_LONG_SPLITERATOR;
    }

    public static Spliterator.OfDouble emptyDoubleSpliterator() {
        return EMPTY_DOUBLE_SPLITERATOR;
    }

    public static <T> Spliterator<T> spliterator(Object[] array, int additionalCharacteristics) {
        return new ArraySpliterator(Objects.requireNonNull(array), additionalCharacteristics);
    }

    public static <T> Spliterator<T> spliterator(Object[] array, int fromIndex, int toIndex, int additionalCharacteristics) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(array).length, fromIndex, toIndex);
        return new ArraySpliterator(array, fromIndex, toIndex, additionalCharacteristics);
    }

    public static Spliterator.OfInt spliterator(int[] array, int additionalCharacteristics) {
        return new IntArraySpliterator(Objects.requireNonNull(array), additionalCharacteristics);
    }

    public static Spliterator.OfInt spliterator(int[] array, int fromIndex, int toIndex, int additionalCharacteristics) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(array).length, fromIndex, toIndex);
        return new IntArraySpliterator(array, fromIndex, toIndex, additionalCharacteristics);
    }

    public static Spliterator.OfLong spliterator(long[] array, int additionalCharacteristics) {
        return new LongArraySpliterator(Objects.requireNonNull(array), additionalCharacteristics);
    }

    public static Spliterator.OfLong spliterator(long[] array, int fromIndex, int toIndex, int additionalCharacteristics) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(array).length, fromIndex, toIndex);
        return new LongArraySpliterator(array, fromIndex, toIndex, additionalCharacteristics);
    }

    public static Spliterator.OfDouble spliterator(double[] array, int additionalCharacteristics) {
        return new DoubleArraySpliterator(Objects.requireNonNull(array), additionalCharacteristics);
    }

    public static Spliterator.OfDouble spliterator(double[] array, int fromIndex, int toIndex, int additionalCharacteristics) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(array).length, fromIndex, toIndex);
        return new DoubleArraySpliterator(array, fromIndex, toIndex, additionalCharacteristics);
    }

    private static void checkFromToBounds(int arrayLength, int origin, int fence) {
        if (origin > fence) {
            throw new ArrayIndexOutOfBoundsException("origin(" + origin + ") > fence(" + fence + ")");
        }
        if (origin < 0) {
            throw new ArrayIndexOutOfBoundsException(origin);
        }
        if (fence > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(fence);
        }
    }

    public static <T> Spliterator<T> spliterator(Collection<? extends T> c2) {
        Objects.requireNonNull(c2);
        if (JRE_HAS_STREAMS && JRE_DELEGATION_ENABLED) {
            return Spliterators.jreDelegatingSpliterator(c2);
        }
        String name = c2.getClass().getName();
        if (c2 instanceof List) {
            return Spliterators.listSpliterator((List)c2, name);
        }
        if (c2 instanceof Set) {
            return Spliterators.setSpliterator((Set)c2, name);
        }
        if (c2 instanceof Queue) {
            return Spliterators.queueSpliterator((Queue)c2);
        }
        if (!IS_HARMONY_ANDROID && NATIVE_SPECIALIZATION && "java.util.HashMap$Values".equals(name)) {
            return HMSpliterators.getValuesSpliterator(c2);
        }
        return Spliterators.spliterator(c2, 0);
    }

    private static <T> Spliterator<T> listSpliterator(List<? extends T> c2, String name) {
        if (NATIVE_SPECIALIZATION || IS_ANDROID) {
            if (c2 instanceof ArrayList) {
                return ArrayListSpliterator.spliterator((ArrayList)c2);
            }
            if ("java.util.Arrays$ArrayList".equals(name)) {
                return ArraysArrayListSpliterator.spliterator(c2);
            }
            if (c2 instanceof CopyOnWriteArrayList) {
                return COWArrayListSpliterator.spliterator((CopyOnWriteArrayList)c2);
            }
            if (c2 instanceof LinkedList) {
                return LinkedListSpliterator.spliterator((LinkedList)c2);
            }
            if (c2 instanceof Vector) {
                return VectorSpliterator.spliterator((Vector)c2);
            }
        }
        if (ALLOW_RNDACC_SPLITER_OPT && c2 instanceof RandomAccess) {
            if (!(c2 instanceof AbstractList) && Spliterators.isFromJdk(name)) {
                return Spliterators.spliterator(c2, 16);
            }
            return RASpliterator.spliterator(c2);
        }
        return Spliterators.spliterator(c2, 16);
    }

    private static <T> Spliterator<T> setSpliterator(final Set<? extends T> c2, String name) {
        if (!IS_HARMONY_ANDROID && NATIVE_SPECIALIZATION) {
            if ("java.util.HashMap$EntrySet".equals(name)) {
                return HMSpliterators.getEntrySetSpliterator(c2);
            }
            if ("java.util.HashMap$KeySet".equals(name)) {
                return HMSpliterators.getKeySetSpliterator(c2);
            }
        }
        if (c2 instanceof LinkedHashSet) {
            return Spliterators.spliterator(c2, 17);
        }
        if (!IS_HARMONY_ANDROID && NATIVE_SPECIALIZATION && c2 instanceof HashSet) {
            return HMSpliterators.getHashSetSpliterator((HashSet)c2);
        }
        if (c2 instanceof SortedSet) {
            return new IteratorSpliterator<T>(c2, 21){

                @Override
                public Comparator<? super T> getComparator() {
                    return ((SortedSet)c2).comparator();
                }
            };
        }
        if ((NATIVE_SPECIALIZATION || IS_ANDROID) && c2 instanceof CopyOnWriteArraySet) {
            return COWArraySetSpliterator.spliterator((CopyOnWriteArraySet)c2);
        }
        return Spliterators.spliterator(c2, 1);
    }

    private static <T> Spliterator<T> queueSpliterator(Queue<? extends T> c2) {
        if (c2 instanceof ArrayBlockingQueue) {
            return Spliterators.spliterator(c2, 4368);
        }
        if (NATIVE_SPECIALIZATION || IS_ANDROID) {
            if (c2 instanceof LinkedBlockingQueue) {
                return LBQSpliterator.spliterator((LinkedBlockingQueue)c2);
            }
            if (c2 instanceof ArrayDeque) {
                return ArrayDequeSpliterator.spliterator((ArrayDeque)c2);
            }
            if (c2 instanceof LinkedBlockingDeque) {
                return LBDSpliterator.spliterator((LinkedBlockingDeque)c2);
            }
            if (c2 instanceof PriorityBlockingQueue) {
                return PBQueueSpliterator.spliterator((PriorityBlockingQueue)c2);
            }
            if (c2 instanceof PriorityQueue) {
                return PQueueSpliterator.spliterator((PriorityQueue)c2);
            }
        }
        return Spliterators.spliterator(c2, 0);
    }

    private static <T> Spliterator<T> jreDelegatingSpliterator(Collection<? extends T> c2) {
        return new DelegatingSpliterator<T>(c2.spliterator());
    }

    public static <T> Spliterator<T> spliterator(Collection<? extends T> c2, int characteristics) {
        return new IteratorSpliterator<T>(Objects.requireNonNull(c2), characteristics);
    }

    public static <T> Spliterator<T> spliterator(Iterator<? extends T> iterator, long size, int characteristics) {
        return new IteratorSpliterator<T>(Objects.requireNonNull(iterator), size, characteristics);
    }

    public static <T> Spliterator<T> spliteratorUnknownSize(Iterator<? extends T> iterator, int characteristics) {
        return new IteratorSpliterator<T>(Objects.requireNonNull(iterator), characteristics);
    }

    public static Spliterator.OfInt spliterator(PrimitiveIterator.OfInt iterator, long size, int characteristics) {
        return new IntIteratorSpliterator(Objects.requireNonNull(iterator), size, characteristics);
    }

    public static Spliterator.OfInt spliteratorUnknownSize(PrimitiveIterator.OfInt iterator, int characteristics) {
        return new IntIteratorSpliterator(Objects.requireNonNull(iterator), characteristics);
    }

    public static Spliterator.OfLong spliterator(PrimitiveIterator.OfLong iterator, long size, int characteristics) {
        return new LongIteratorSpliterator(Objects.requireNonNull(iterator), size, characteristics);
    }

    public static Spliterator.OfLong spliteratorUnknownSize(PrimitiveIterator.OfLong iterator, int characteristics) {
        return new LongIteratorSpliterator(Objects.requireNonNull(iterator), characteristics);
    }

    public static Spliterator.OfDouble spliterator(PrimitiveIterator.OfDouble iterator, long size, int characteristics) {
        return new DoubleIteratorSpliterator(Objects.requireNonNull(iterator), size, characteristics);
    }

    public static Spliterator.OfDouble spliteratorUnknownSize(PrimitiveIterator.OfDouble iterator, int characteristics) {
        return new DoubleIteratorSpliterator(Objects.requireNonNull(iterator), characteristics);
    }

    public static <T> Iterator<T> iterator(Spliterator<? extends T> spliterator) {
        Objects.requireNonNull(spliterator);
        class Adapter
        implements Iterator<T>,
        Consumer<T> {
            boolean valueReady = false;
            T nextElement;
            final /* synthetic */ Spliterator val$spliterator;

            Adapter(Spliterator spliterator) {
                this.val$spliterator = spliterator;
            }

            @Override
            public void accept(T t) {
                this.valueReady = true;
                this.nextElement = t;
            }

            @Override
            public boolean hasNext() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public T next() {
                if (!this.valueReady && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                return this.nextElement;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
        return new Adapter(spliterator);
    }

    public static PrimitiveIterator.OfInt iterator(Spliterator.OfInt spliterator) {
        Objects.requireNonNull(spliterator);
        class Adapter
        implements PrimitiveIterator.OfInt,
        IntConsumer {
            boolean valueReady = false;
            int nextElement;
            final /* synthetic */ Spliterator.OfInt val$spliterator;

            Adapter(Spliterator.OfInt ofInt) {
                this.val$spliterator = ofInt;
            }

            @Override
            public void accept(int t) {
                this.valueReady = true;
                this.nextElement = t;
            }

            @Override
            public boolean hasNext() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public int nextInt() {
                if (!this.valueReady && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                return this.nextElement;
            }

            @Override
            public Integer next() {
                return this.nextInt();
            }

            @Override
            public void forEachRemaining(IntConsumer action) {
                Iterators.forEachRemaining(this, action);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
        return new Adapter(spliterator);
    }

    public static PrimitiveIterator.OfLong iterator(Spliterator.OfLong spliterator) {
        Objects.requireNonNull(spliterator);
        class Adapter
        implements PrimitiveIterator.OfLong,
        LongConsumer {
            boolean valueReady = false;
            long nextElement;
            final /* synthetic */ Spliterator.OfLong val$spliterator;

            Adapter(Spliterator.OfLong ofLong) {
                this.val$spliterator = ofLong;
            }

            @Override
            public void accept(long t) {
                this.valueReady = true;
                this.nextElement = t;
            }

            @Override
            public boolean hasNext() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public long nextLong() {
                if (!this.valueReady && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                return this.nextElement;
            }

            @Override
            public Long next() {
                return this.nextLong();
            }

            @Override
            public void forEachRemaining(LongConsumer action) {
                Iterators.forEachRemaining(this, action);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
        return new Adapter(spliterator);
    }

    public static PrimitiveIterator.OfDouble iterator(Spliterator.OfDouble spliterator) {
        Objects.requireNonNull(spliterator);
        class Adapter
        implements PrimitiveIterator.OfDouble,
        DoubleConsumer {
            boolean valueReady = false;
            double nextElement;
            final /* synthetic */ Spliterator.OfDouble val$spliterator;

            Adapter(Spliterator.OfDouble ofDouble) {
                this.val$spliterator = ofDouble;
            }

            @Override
            public void accept(double t) {
                this.valueReady = true;
                this.nextElement = t;
            }

            @Override
            public boolean hasNext() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public double nextDouble() {
                if (!this.valueReady && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                return this.nextElement;
            }

            @Override
            public Double next() {
                return this.nextDouble();
            }

            @Override
            public void forEachRemaining(DoubleConsumer action) {
                Iterators.forEachRemaining(this, action);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
        return new Adapter(spliterator);
    }

    private static boolean getBooleanPropVal(final String prop, final boolean defVal) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean val = defVal;
                try {
                    String s = System.getProperty(prop, Boolean.toString(defVal));
                    val = Boolean.parseBoolean(s.trim());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return val;
            }
        });
    }

    private static boolean isClassPresent(String name) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name, false, Spliterators.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz != null;
    }

    private static boolean isJava6() {
        return Spliterators.isVersionBelow("java.class.version", 51.0);
    }

    private static boolean isStreamEnabledJRE() {
        if (Spliterators.isVersionBelow("java.class.version", 52.0)) {
            return false;
        }
        Class<?> c2 = null;
        for (String cn : new String[]{"java.util.function.Consumer", "java.util.Spliterator"}) {
            try {
                c2 = Class.forName(cn);
            }
            catch (Exception ignore) {
                return false;
            }
        }
        Method m = null;
        if (c2 != null) {
            try {
                m = Collection.class.getDeclaredMethod("spliterator", new Class[0]);
            }
            catch (Exception ignore) {
                return false;
            }
        }
        return m != null;
    }

    private static boolean isVersionBelow(String prop, double maxVer) {
        try {
            double d;
            String v = System.getProperty(prop);
            if (v != null && (d = Double.parseDouble(v)) < maxVer) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isFromJdk(String name) {
        return name.startsWith("java.util.Collections$", 0) && name.endsWith("RandomAccessList");
    }

    static final class DoubleIteratorSpliterator
    implements Spliterator.OfDouble {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private PrimitiveIterator.OfDouble it;
        private final int characteristics;
        private long est;
        private int batch;

        public DoubleIteratorSpliterator(PrimitiveIterator.OfDouble iterator, long size, int characteristics) {
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public DoubleIteratorSpliterator(PrimitiveIterator.OfDouble iterator, int characteristics) {
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            PrimitiveIterator.OfDouble i = this.it;
            long s = this.est;
            if (s > 1L && i.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                double[] a2 = new double[n];
                int j = 0;
                do {
                    a2[j] = i.nextDouble();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new DoubleArraySpliterator(a2, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            Iterators.forEachRemaining(this.it, Objects.requireNonNull(action));
        }

        @Override
        public void forEachRemaining(Consumer<? super Double> action) {
            OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            Objects.requireNonNull(action);
            if (this.it.hasNext()) {
                action.accept(this.it.nextDouble());
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Double> action) {
            return OfDouble.tryAdvance(this, action);
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Double> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class LongIteratorSpliterator
    implements Spliterator.OfLong {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private PrimitiveIterator.OfLong it;
        private final int characteristics;
        private long est;
        private int batch;

        public LongIteratorSpliterator(PrimitiveIterator.OfLong iterator, long size, int characteristics) {
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public LongIteratorSpliterator(PrimitiveIterator.OfLong iterator, int characteristics) {
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            PrimitiveIterator.OfLong i = this.it;
            long s = this.est;
            if (s > 1L && i.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                long[] a2 = new long[n];
                int j = 0;
                do {
                    a2[j] = i.nextLong();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new LongArraySpliterator(a2, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            Iterators.forEachRemaining(this.it, Objects.requireNonNull(action));
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> action) {
            OfLong.forEachRemaining((Spliterator.OfLong)this, action);
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            Objects.requireNonNull(action);
            if (this.it.hasNext()) {
                action.accept(this.it.nextLong());
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Long> action) {
            return OfLong.tryAdvance(this, action);
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class IntIteratorSpliterator
    implements Spliterator.OfInt {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private PrimitiveIterator.OfInt it;
        private final int characteristics;
        private long est;
        private int batch;

        public IntIteratorSpliterator(PrimitiveIterator.OfInt iterator, long size, int characteristics) {
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public IntIteratorSpliterator(PrimitiveIterator.OfInt iterator, int characteristics) {
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            PrimitiveIterator.OfInt i = this.it;
            long s = this.est;
            if (s > 1L && i.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                int[] a2 = new int[n];
                int j = 0;
                do {
                    a2[j] = i.nextInt();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new IntArraySpliterator(a2, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            Iterators.forEachRemaining(this.it, Objects.requireNonNull(action));
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            Objects.requireNonNull(action);
            if (this.it.hasNext()) {
                action.accept(this.it.nextInt());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super Integer> action) {
            return OfInt.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> action) {
            OfInt.forEachRemaining((Spliterator.OfInt)this, action);
        }
    }

    static class IteratorSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final Collection<? extends T> collection;
        private Iterator<? extends T> it;
        private final int characteristics;
        private long est;
        private int batch;

        public IteratorSpliterator(Collection<? extends T> collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        @Override
        public Spliterator<T> trySplit() {
            long s;
            Iterator<Object> i = this.it;
            if (i == null) {
                this.it = this.collection.iterator();
                i = this.it;
                s = this.est = (long)this.collection.size();
            } else {
                s = this.est;
            }
            if (s > 1L && i.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] a2 = new Object[n];
                int j = 0;
                do {
                    a2[j] = i.next();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new ArraySpliterator(a2, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            Iterator<Object> i = this.it;
            if (i == null) {
                i = this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            Iterators.forEachRemaining(i, action);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            if (this.it.hasNext()) {
                action.accept(this.it.next());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
                return this.est;
            }
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    public static abstract class AbstractDoubleSpliterator
    implements Spliterator.OfDouble {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractDoubleSpliterator(long est, int additionalCharacteristics) {
            this.est = est;
            this.characteristics = (additionalCharacteristics & 0x40) != 0 ? additionalCharacteristics | 0x4000 : additionalCharacteristics;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            HoldingDoubleConsumer holder = new HoldingDoubleConsumer();
            long s = this.est;
            if (s > 1L && this.tryAdvance(holder)) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                double[] a2 = new double[n];
                int j = 0;
                do {
                    a2[j] = holder.value;
                } while (++j < n && this.tryAdvance(holder));
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new DoubleArraySpliterator(a2, 0, j, this.characteristics());
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return (this.characteristics() & 0x40) == 0 ? -1L : this.estimateSize();
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return (this.characteristics() & characteristics) == characteristics;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            throw new IllegalStateException();
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            while (this.tryAdvance(action)) {
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Double> action) {
            OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Double> action) {
            return OfDouble.tryAdvance(this, action);
        }

        static final class HoldingDoubleConsumer
        implements DoubleConsumer {
            double value;

            HoldingDoubleConsumer() {
            }

            @Override
            public void accept(double value) {
                this.value = value;
            }
        }
    }

    public static abstract class AbstractLongSpliterator
    implements Spliterator.OfLong {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractLongSpliterator(long est, int additionalCharacteristics) {
            this.est = est;
            this.characteristics = (additionalCharacteristics & 0x40) != 0 ? additionalCharacteristics | 0x4000 : additionalCharacteristics;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            HoldingLongConsumer holder = new HoldingLongConsumer();
            long s = this.est;
            if (s > 1L && this.tryAdvance(holder)) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                long[] a2 = new long[n];
                int j = 0;
                do {
                    a2[j] = holder.value;
                } while (++j < n && this.tryAdvance(holder));
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new LongArraySpliterator(a2, 0, j, this.characteristics());
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return (this.characteristics() & 0x40) == 0 ? -1L : this.estimateSize();
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return (this.characteristics() & characteristics) == characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            throw new IllegalStateException();
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            while (this.tryAdvance(action)) {
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> action) {
            OfLong.forEachRemaining((Spliterator.OfLong)this, action);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Long> action) {
            return OfLong.tryAdvance(this, action);
        }

        static final class HoldingLongConsumer
        implements LongConsumer {
            long value;

            HoldingLongConsumer() {
            }

            @Override
            public void accept(long value) {
                this.value = value;
            }
        }
    }

    public static abstract class AbstractIntSpliterator
    implements Spliterator.OfInt {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractIntSpliterator(long est, int additionalCharacteristics) {
            this.est = est;
            this.characteristics = (additionalCharacteristics & 0x40) != 0 ? additionalCharacteristics | 0x4000 : additionalCharacteristics;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            HoldingIntConsumer holder = new HoldingIntConsumer();
            long s = this.est;
            if (s > 1L && this.tryAdvance(holder)) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                int[] a2 = new int[n];
                int j = 0;
                do {
                    a2[j] = holder.value;
                } while (++j < n && this.tryAdvance(holder));
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new IntArraySpliterator(a2, 0, j, this.characteristics());
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return (this.characteristics() & 0x40) == 0 ? -1L : this.estimateSize();
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return (this.characteristics() & characteristics) == characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            throw new IllegalStateException();
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            while (this.tryAdvance(action)) {
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> action) {
            OfInt.forEachRemaining((Spliterator.OfInt)this, action);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Integer> action) {
            return OfInt.tryAdvance(this, action);
        }

        static final class HoldingIntConsumer
        implements IntConsumer {
            int value;

            HoldingIntConsumer() {
            }

            @Override
            public void accept(int value) {
                this.value = value;
            }
        }
    }

    public static abstract class AbstractSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractSpliterator(long est, int additionalCharacteristics) {
            this.est = est;
            this.characteristics = (additionalCharacteristics & 0x40) != 0 ? additionalCharacteristics | 0x4000 : additionalCharacteristics;
        }

        @Override
        public Spliterator<T> trySplit() {
            HoldingConsumer holder = new HoldingConsumer();
            long s = this.est;
            if (s > 1L && this.tryAdvance(holder)) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] a2 = new Object[n];
                int j = 0;
                do {
                    a2[j] = holder.value;
                } while (++j < n && this.tryAdvance(holder));
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new ArraySpliterator(a2, 0, j, this.characteristics());
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return (this.characteristics() & 0x40) == 0 ? -1L : this.estimateSize();
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return (this.characteristics() & characteristics) == characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            throw new IllegalStateException();
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            while (this.tryAdvance(action)) {
            }
        }

        static final class HoldingConsumer<T>
        implements Consumer<T> {
            Object value;

            HoldingConsumer() {
            }

            @Override
            public void accept(T value) {
                this.value = value;
            }
        }
    }

    static final class DoubleArraySpliterator
    implements Spliterator.OfDouble {
        private final double[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public DoubleArraySpliterator(double[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public DoubleArraySpliterator(double[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            DoubleArraySpliterator doubleArraySpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                doubleArraySpliterator = null;
            } else {
                this.index = mid;
                DoubleArraySpliterator doubleArraySpliterator2 = new DoubleArraySpliterator(this.array, lo, this.index, this.characteristics);
                doubleArraySpliterator = doubleArraySpliterator2;
            }
            return doubleArraySpliterator;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            int i;
            Objects.requireNonNull(action);
            double[] a2 = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a2[i]);
                } while (++i < hi);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Double> action) {
            OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            Objects.requireNonNull(action);
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Double> action) {
            return OfDouble.tryAdvance(this, action);
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Double> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class LongArraySpliterator
    implements Spliterator.OfLong {
        private final long[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public LongArraySpliterator(long[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public LongArraySpliterator(long[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            LongArraySpliterator longArraySpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                longArraySpliterator = null;
            } else {
                this.index = mid;
                LongArraySpliterator longArraySpliterator2 = new LongArraySpliterator(this.array, lo, this.index, this.characteristics);
                longArraySpliterator = longArraySpliterator2;
            }
            return longArraySpliterator;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            int i;
            Objects.requireNonNull(action);
            long[] a2 = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a2[i]);
                } while (++i < hi);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> action) {
            OfLong.forEachRemaining((Spliterator.OfLong)this, action);
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            Objects.requireNonNull(action);
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Long> action) {
            return OfLong.tryAdvance(this, action);
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class IntArraySpliterator
    implements Spliterator.OfInt {
        private final int[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public IntArraySpliterator(int[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public IntArraySpliterator(int[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            IntArraySpliterator intArraySpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                intArraySpliterator = null;
            } else {
                this.index = mid;
                IntArraySpliterator intArraySpliterator2 = new IntArraySpliterator(this.array, lo, this.index, this.characteristics);
                intArraySpliterator = intArraySpliterator2;
            }
            return intArraySpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            Objects.requireNonNull(action);
            int[] a2 = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a2[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            Objects.requireNonNull(action);
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Integer> action) {
            return OfInt.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> action) {
            OfInt.forEachRemaining((Spliterator.OfInt)this, action);
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class ArraySpliterator<T>
    implements Spliterator<T> {
        private final Object[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public ArraySpliterator(Object[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public ArraySpliterator(Object[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Spliterator<T> trySplit() {
            ArraySpliterator<T> arraySpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                arraySpliterator = null;
            } else {
                this.index = mid;
                ArraySpliterator<T> arraySpliterator2 = new ArraySpliterator<T>(this.array, lo, this.index, this.characteristics);
                arraySpliterator = arraySpliterator2;
            }
            return arraySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            int i;
            Objects.requireNonNull(action);
            Object[] a2 = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a2[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            if (this.index >= 0 && this.index < this.fence) {
                Object e = this.array[this.index++];
                action.accept(e);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    private static abstract class EmptySpliterator<T, S extends Spliterator<T>, C> {
        EmptySpliterator() {
        }

        public S trySplit() {
            return null;
        }

        public boolean tryAdvance(C consumer) {
            Objects.requireNonNull(consumer);
            return false;
        }

        public void forEachRemaining(C consumer) {
            Objects.requireNonNull(consumer);
        }

        public long estimateSize() {
            return 0L;
        }

        public int characteristics() {
            return 16448;
        }

        private static final class OfDouble
        extends EmptySpliterator<Double, Spliterator.OfDouble, DoubleConsumer>
        implements Spliterator.OfDouble {
            OfDouble() {
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super Double> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Double> action) {
                return java8.util.Spliterators$OfDouble.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Double> action) {
                java8.util.Spliterators$OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
            }
        }

        private static final class OfLong
        extends EmptySpliterator<Long, Spliterator.OfLong, LongConsumer>
        implements Spliterator.OfLong {
            OfLong() {
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super Long> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Long> action) {
                return java8.util.Spliterators$OfLong.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Long> action) {
                java8.util.Spliterators$OfLong.forEachRemaining((Spliterator.OfLong)this, action);
            }
        }

        private static final class OfInt
        extends EmptySpliterator<Integer, Spliterator.OfInt, IntConsumer>
        implements Spliterator.OfInt {
            OfInt() {
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super Integer> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Integer> action) {
                return java8.util.Spliterators$OfInt.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Integer> action) {
                java8.util.Spliterators$OfInt.forEachRemaining((Spliterator.OfInt)this, action);
            }
        }

        private static final class OfRef<T>
        extends EmptySpliterator<T, Spliterator<T>, Consumer<? super T>>
        implements Spliterator<T> {
            OfRef() {
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super T> getComparator() {
                return Spliterators.getComparator(this);
            }
        }
    }

    public static final class OfDouble {
        public static void forEachRemaining(Spliterator.OfDouble this_, DoubleConsumer action) {
            while (this_.tryAdvance(action)) {
            }
        }

        public static boolean tryAdvance(Spliterator.OfDouble this_, Consumer<? super Double> action) {
            if (action instanceof DoubleConsumer) {
                return this_.tryAdvance((DoubleConsumer)((Object)action));
            }
            Consumer<? super Double> consumer = action;
            consumer.getClass();
            return this_.tryAdvance(Spliterators$OfDouble$$Lambda$1.lambdaFactory$(consumer));
        }

        public static void forEachRemaining(Spliterator.OfDouble this_, Consumer<? super Double> action) {
            if (action instanceof DoubleConsumer) {
                this_.forEachRemaining((DoubleConsumer)((Object)action));
            } else {
                Consumer<? super Double> consumer = action;
                consumer.getClass();
                this_.forEachRemaining(Spliterators$OfDouble$$Lambda$2.lambdaFactory$(consumer));
            }
        }

        private OfDouble() {
        }
    }

    public static final class OfLong {
        public static void forEachRemaining(Spliterator.OfLong this_, LongConsumer action) {
            while (this_.tryAdvance(action)) {
            }
        }

        public static boolean tryAdvance(Spliterator.OfLong this_, Consumer<? super Long> action) {
            if (action instanceof LongConsumer) {
                return this_.tryAdvance((LongConsumer)((Object)action));
            }
            Consumer<? super Long> consumer = action;
            consumer.getClass();
            return this_.tryAdvance(Spliterators$OfLong$$Lambda$1.lambdaFactory$(consumer));
        }

        public static void forEachRemaining(Spliterator.OfLong this_, Consumer<? super Long> action) {
            if (action instanceof LongConsumer) {
                this_.forEachRemaining((LongConsumer)((Object)action));
            } else {
                Consumer<? super Long> consumer = action;
                consumer.getClass();
                this_.forEachRemaining(Spliterators$OfLong$$Lambda$2.lambdaFactory$(consumer));
            }
        }

        private OfLong() {
        }
    }

    public static final class OfInt {
        public static void forEachRemaining(Spliterator.OfInt this_, IntConsumer action) {
            while (this_.tryAdvance(action)) {
            }
        }

        public static boolean tryAdvance(Spliterator.OfInt this_, Consumer<? super Integer> action) {
            if (action instanceof IntConsumer) {
                return this_.tryAdvance((IntConsumer)((Object)action));
            }
            Consumer<? super Integer> consumer = action;
            consumer.getClass();
            return this_.tryAdvance(Spliterators$OfInt$$Lambda$1.lambdaFactory$(consumer));
        }

        public static void forEachRemaining(Spliterator.OfInt this_, Consumer<? super Integer> action) {
            if (action instanceof IntConsumer) {
                this_.forEachRemaining((IntConsumer)((Object)action));
            } else {
                Consumer<? super Integer> consumer = action;
                consumer.getClass();
                this_.forEachRemaining(Spliterators$OfInt$$Lambda$2.lambdaFactory$(consumer));
            }
        }

        private OfInt() {
        }
    }

    public static final class OfPrimitive {
        public static <T, T_CONS, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>> void forEachRemaining(Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> this_, T_CONS action) {
            while (this_.tryAdvance(action)) {
            }
        }

        private OfPrimitive() {
        }
    }
}

