/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java8.util.concurrent.UnsafeAccess;
import sun.misc.Unsafe;

final class TLRandom {
    private static final long GAMMA = -7046029254386353131L;
    private static final int PROBE_INCREMENT = -1640531527;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long VALUE_OFF;
    private static final boolean IS_PRE8_IBM;
    private static final boolean IS_ANDROID;
    private static final long THREADLOCALS;
    private static final long INHERITABLETHREADLOCALS;
    private static final long INHERITEDACCESSCONTROLCONTEXT;
    private static final ThreadLocal<SeedsHolder> localSeeds;
    private static final AtomicInteger probeGenerator;
    private static final AtomicLong seeder;

    static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    static int mix32(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        return (int)((z ^ z >>> 33) * -4265267296055464877L >>> 32);
    }

    private TLRandom() {
    }

    static final void localInit() {
        int p = probeGenerator.addAndGet(-1640531527);
        int probe = p == 0 ? 1 : p;
        long seed = TLRandom.mix64(seeder.getAndAdd(-4942790177534073029L));
        TLRandom.setThreadLocalRandomSeed(seed);
        TLRandom.setThreadLocalRandomProbe(probe);
    }

    static final long nextSeed() {
        long r = TLRandom.getThreadLocalRandomSeed() + -7046029254386353131L;
        TLRandom.setThreadLocalRandomSeed(r);
        return r;
    }

    static final int getProbe() {
        return TLRandom.getThreadLocalRandomProbe();
    }

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        TLRandom.setThreadLocalRandomProbe(probe);
        return probe;
    }

    static final int nextSecondarySeed() {
        int r = TLRandom.getThreadLocalRandomSecondarySeed();
        if (r != 0) {
            r ^= r << 13;
            r ^= r >>> 17;
            r ^= r << 5;
        } else {
            r = TLRandom.mix32(seeder.getAndAdd(-4942790177534073029L));
            if (r == 0) {
                r = 1;
            }
        }
        TLRandom.setThreadLocalRandomSecondarySeed(r);
        return r;
    }

    static long getThreadLocalRandomSeed() {
        return TLRandom.localSeeds.get().threadSeed;
    }

    private static void setThreadLocalRandomSeed(long seed) {
        TLRandom.localSeeds.get().threadSeed = seed;
    }

    static int getThreadLocalRandomProbe() {
        return TLRandom.localSeeds.get().threadProbe;
    }

    private static void setThreadLocalRandomProbe(int probe) {
        TLRandom.localSeeds.get().threadProbe = probe;
    }

    private static int getThreadLocalRandomSecondarySeed() {
        return TLRandom.localSeeds.get().threadSecondarySeed;
    }

    private static void setThreadLocalRandomSecondarySeed(int secondary) {
        TLRandom.localSeeds.get().threadSecondarySeed = secondary;
    }

    private static void setUncontendedToTrue(Integer isUncontended) {
        U.putInt(isUncontended, VALUE_OFF, 1);
    }

    private static int getInitializedProbe(Integer uncontended) {
        int p = TLRandom.getThreadLocalRandomProbe();
        if (p == 0) {
            TLRandom.localInit();
            p = TLRandom.getThreadLocalRandomProbe();
            TLRandom.setUncontendedToTrue(uncontended);
        }
        return p;
    }

    static final void eraseThreadLocals(Thread thread) {
        if (!IS_ANDROID) {
            U.putObject(thread, THREADLOCALS, null);
            U.putObject(thread, INHERITABLETHREADLOCALS, null);
        }
    }

    static final void setInheritedAccessControlContext(Thread thread, AccessControlContext acc) {
        if (!IS_ANDROID) {
            U.putOrderedObject(thread, INHERITEDACCESSCONTROLCONTEXT, acc);
        }
    }

    static final ThreadGroup createThreadGroup(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String groupFieldName = IS_PRE8_IBM ? "threadGroup" : "group";
            long tg = U.objectFieldOffset(Thread.class.getDeclaredField(groupFieldName));
            long gp = U.objectFieldOffset(ThreadGroup.class.getDeclaredField("parent"));
            ThreadGroup group = (ThreadGroup)U.getObject(Thread.currentThread(), tg);
            while (group != null) {
                ThreadGroup parent = (ThreadGroup)U.getObject(group, gp);
                if (parent == null) {
                    return new ThreadGroup(group, name);
                }
                group = parent;
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        throw new Error("Cannot create ThreadGroup");
    }

    private static boolean isAndroid() {
        if (TLRandom.isClassPresent("android.util.DisplayMetrics")) {
            return true;
        }
        return TLRandom.isClassPresent("org.robovm.rt.bro.Bro");
    }

    private static boolean isIBMPre8() {
        String ver;
        return TLRandom.isClassPresent("com.ibm.misc.JarVersion") && (ver = System.getProperty("java.class.version", "45")) != null && ver.length() >= 2 && "52".compareTo(ver = ver.substring(0, 2)) > 0;
    }

    private static boolean isClassPresent(String name) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name, false, TLRandom.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz != null;
    }

    static {
        try {
            IS_PRE8_IBM = TLRandom.isIBMPre8();
            IS_ANDROID = TLRandom.isAndroid();
            if (!IS_ANDROID) {
                THREADLOCALS = U.objectFieldOffset(Thread.class.getDeclaredField("threadLocals"));
                INHERITABLETHREADLOCALS = U.objectFieldOffset(Thread.class.getDeclaredField("inheritableThreadLocals"));
                String accFieldName = IS_PRE8_IBM ? "accessControlContext" : "inheritedAccessControlContext";
                INHERITEDACCESSCONTROLCONTEXT = U.objectFieldOffset(Thread.class.getDeclaredField(accFieldName));
            } else {
                THREADLOCALS = 0L;
                INHERITABLETHREADLOCALS = 0L;
                INHERITEDACCESSCONTROLCONTEXT = 0L;
            }
            VALUE_OFF = U.objectFieldOffset(Integer.class.getDeclaredField("value"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
        localSeeds = new ThreadLocal<SeedsHolder>(){

            @Override
            protected SeedsHolder initialValue() {
                return new SeedsHolder();
            }
        };
        probeGenerator = new AtomicInteger();
        seeder = new AtomicLong(TLRandom.mix64(System.currentTimeMillis()) ^ TLRandom.mix64(System.nanoTime()));
        if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("java.util.secureRandomSeed");
            }
        }).booleanValue()) {
            byte[] seedBytes = SecureRandom.getSeed(8);
            long s = (long)seedBytes[0] & 0xFFL;
            for (int i = 1; i < 8; ++i) {
                s = s << 8 | (long)seedBytes[i] & 0xFFL;
            }
            seeder.set(s);
        }
    }

    private static final class SeedsHolder {
        long threadSeed;
        int threadProbe;
        int threadSecondarySeed;

        private SeedsHolder() {
        }
    }
}

