/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.Spliterators;
import java8.util.function.DoubleConsumer;
import java8.util.function.DoublePredicate;
import java8.util.function.DoubleSupplier;
import java8.util.function.DoubleUnaryOperator;
import java8.util.stream.DoubleStream;
import java8.util.stream.DoubleStreams$$Lambda$1;
import java8.util.stream.DoubleStreams$$Lambda$2;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.StreamSupport;
import java8.util.stream.Streams;
import java8.util.stream.WhileOps;

public final class DoubleStreams {
    public static DoubleStream takeWhile(DoubleStream stream, DoublePredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        DoubleStream doubleStream = StreamSupport.doubleStream(new WhileOps.UnorderedWhileSpliterator.OfDouble.Taking(stream.spliterator(), true, predicate), stream.isParallel());
        DoubleStream doubleStream2 = stream;
        doubleStream2.getClass();
        return (DoubleStream)doubleStream.onClose(DoubleStreams$$Lambda$1.lambdaFactory$(doubleStream2));
    }

    public static DoubleStream dropWhile(DoubleStream stream, DoublePredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        DoubleStream doubleStream = StreamSupport.doubleStream(new WhileOps.UnorderedWhileSpliterator.OfDouble.Dropping(stream.spliterator(), true, predicate), stream.isParallel());
        DoubleStream doubleStream2 = stream;
        doubleStream2.getClass();
        return (DoubleStream)doubleStream.onClose(DoubleStreams$$Lambda$2.lambdaFactory$(doubleStream2));
    }

    public static DoubleStream.Builder builder() {
        return new Streams.DoubleStreamBuilderImpl();
    }

    public static DoubleStream empty() {
        return StreamSupport.doubleStream(Spliterators.emptyDoubleSpliterator(), false);
    }

    public static DoubleStream of(double t) {
        return StreamSupport.doubleStream(new Streams.DoubleStreamBuilderImpl(t), false);
    }

    public static DoubleStream of(double ... values) {
        return J8Arrays.stream(values);
    }

    public static DoubleStream iterate(final double seed, final DoubleUnaryOperator f) {
        Objects.requireNonNull(f);
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 1296){
            double prev;
            boolean started;

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                double t;
                Objects.requireNonNull(action);
                if (this.started) {
                    t = f.applyAsDouble(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }
        };
        return StreamSupport.doubleStream(spliterator, false);
    }

    public static DoubleStream iterate(final double seed, final DoublePredicate hasNext, final DoubleUnaryOperator next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 1296){
            double prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                double t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = next.applyAsDouble(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!hasNext.test(t)) {
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(DoubleConsumer action) {
                double t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                double d = t = this.started ? next.applyAsDouble(this.prev) : seed;
                while (hasNext.test(t)) {
                    action.accept(t);
                    t = next.applyAsDouble(t);
                }
            }
        };
        return StreamSupport.doubleStream(spliterator, false);
    }

    public static DoubleStream generate(DoubleSupplier s) {
        Objects.requireNonNull(s);
        return StreamSupport.doubleStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfDouble(Long.MAX_VALUE, s), false);
    }

    public static DoubleStream concat(DoubleStream a2, DoubleStream b2) {
        Objects.requireNonNull(a2);
        Objects.requireNonNull(b2);
        Streams.ConcatSpliterator.OfDouble split = new Streams.ConcatSpliterator.OfDouble(a2.spliterator(), b2.spliterator());
        DoubleStream stream = StreamSupport.doubleStream(split, a2.isParallel() || b2.isParallel());
        return (DoubleStream)stream.onClose(Streams.composedClose(a2, b2));
    }

    private DoubleStreams() {
    }
}

