/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.Spliterators;
import java8.util.function.IntConsumer;
import java8.util.function.IntPredicate;
import java8.util.function.IntSupplier;
import java8.util.function.IntUnaryOperator;
import java8.util.stream.IntStream;
import java8.util.stream.IntStreams$$Lambda$1;
import java8.util.stream.IntStreams$$Lambda$2;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.StreamSupport;
import java8.util.stream.Streams;
import java8.util.stream.WhileOps;

public final class IntStreams {
    public static IntStream takeWhile(IntStream stream, IntPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        IntStream intStream = StreamSupport.intStream(new WhileOps.UnorderedWhileSpliterator.OfInt.Taking(stream.spliterator(), true, predicate), stream.isParallel());
        IntStream intStream2 = stream;
        intStream2.getClass();
        return (IntStream)intStream.onClose(IntStreams$$Lambda$1.lambdaFactory$(intStream2));
    }

    public static IntStream dropWhile(IntStream stream, IntPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        IntStream intStream = StreamSupport.intStream(new WhileOps.UnorderedWhileSpliterator.OfInt.Dropping(stream.spliterator(), true, predicate), stream.isParallel());
        IntStream intStream2 = stream;
        intStream2.getClass();
        return (IntStream)intStream.onClose(IntStreams$$Lambda$2.lambdaFactory$(intStream2));
    }

    public static IntStream.Builder builder() {
        return new Streams.IntStreamBuilderImpl();
    }

    public static IntStream empty() {
        return StreamSupport.intStream(Spliterators.emptyIntSpliterator(), false);
    }

    public static IntStream of(int t) {
        return StreamSupport.intStream(new Streams.IntStreamBuilderImpl(t), false);
    }

    public static IntStream of(int ... values) {
        return J8Arrays.stream(values);
    }

    public static IntStream iterate(final int seed, final IntUnaryOperator f) {
        Objects.requireNonNull(f);
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 1296){
            int prev;
            boolean started;

            @Override
            public boolean tryAdvance(IntConsumer action) {
                int t;
                Objects.requireNonNull(action);
                if (this.started) {
                    t = f.applyAsInt(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }
        };
        return StreamSupport.intStream(spliterator, false);
    }

    public static IntStream iterate(final int seed, final IntPredicate hasNext, final IntUnaryOperator next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 1296){
            int prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(IntConsumer action) {
                int t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = next.applyAsInt(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!hasNext.test(t)) {
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(IntConsumer action) {
                int t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                int n = t = this.started ? next.applyAsInt(this.prev) : seed;
                while (hasNext.test(t)) {
                    action.accept(t);
                    t = next.applyAsInt(t);
                }
            }
        };
        return StreamSupport.intStream(spliterator, false);
    }

    public static IntStream generate(IntSupplier s) {
        Objects.requireNonNull(s);
        return StreamSupport.intStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfInt(Long.MAX_VALUE, s), false);
    }

    public static IntStream range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return IntStreams.empty();
        }
        return StreamSupport.intStream(new Streams.RangeIntSpliterator(startInclusive, endExclusive, false), false);
    }

    public static IntStream rangeClosed(int startInclusive, int endInclusive) {
        if (startInclusive > endInclusive) {
            return IntStreams.empty();
        }
        return StreamSupport.intStream(new Streams.RangeIntSpliterator(startInclusive, endInclusive, true), false);
    }

    public static IntStream concat(IntStream a2, IntStream b2) {
        Objects.requireNonNull(a2);
        Objects.requireNonNull(b2);
        Streams.ConcatSpliterator.OfInt split = new Streams.ConcatSpliterator.OfInt(a2.spliterator(), b2.spliterator());
        IntStream stream = StreamSupport.intStream(split, a2.isParallel() || b2.isParallel());
        return (IntStream)stream.onClose(Streams.composedClose(a2, b2));
    }

    private IntStreams() {
    }
}

