/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.LongSummaryStatistics;
import java8.util.Objects;
import java8.util.OptionalDouble;
import java8.util.OptionalLong;
import java8.util.PrimitiveIterator;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.function.BiConsumer;
import java8.util.function.BinaryOperator;
import java8.util.function.IntFunction;
import java8.util.function.LongBinaryOperator;
import java8.util.function.LongConsumer;
import java8.util.function.LongFunction;
import java8.util.function.LongPredicate;
import java8.util.function.LongToDoubleFunction;
import java8.util.function.LongToIntFunction;
import java8.util.function.LongUnaryOperator;
import java8.util.function.ObjLongConsumer;
import java8.util.function.Supplier;
import java8.util.stream.AbstractPipeline;
import java8.util.stream.BaseStream;
import java8.util.stream.DoublePipeline;
import java8.util.stream.DoubleStream;
import java8.util.stream.FindOps;
import java8.util.stream.ForEachOps;
import java8.util.stream.IntPipeline;
import java8.util.stream.IntStream;
import java8.util.stream.LongPipeline$$Lambda$1;
import java8.util.stream.LongPipeline$$Lambda$10;
import java8.util.stream.LongPipeline$$Lambda$11;
import java8.util.stream.LongPipeline$$Lambda$12;
import java8.util.stream.LongPipeline$$Lambda$13;
import java8.util.stream.LongPipeline$$Lambda$14;
import java8.util.stream.LongPipeline$$Lambda$2;
import java8.util.stream.LongPipeline$$Lambda$3;
import java8.util.stream.LongPipeline$$Lambda$4;
import java8.util.stream.LongPipeline$$Lambda$5;
import java8.util.stream.LongPipeline$$Lambda$6;
import java8.util.stream.LongPipeline$$Lambda$7;
import java8.util.stream.LongPipeline$$Lambda$8;
import java8.util.stream.LongPipeline$$Lambda$9;
import java8.util.stream.LongPipeline$6$1$$Lambda$1;
import java8.util.stream.LongStream;
import java8.util.stream.MatchOps;
import java8.util.stream.Node;
import java8.util.stream.Nodes;
import java8.util.stream.PipelineHelper;
import java8.util.stream.ReduceOps;
import java8.util.stream.ReferencePipeline;
import java8.util.stream.Sink;
import java8.util.stream.SliceOps;
import java8.util.stream.SortedOps;
import java8.util.stream.Stream;
import java8.util.stream.StreamOpFlag;
import java8.util.stream.StreamShape;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.WhileOps;

abstract class LongPipeline<E_IN>
extends AbstractPipeline<E_IN, Long, LongStream>
implements LongStream {
    LongPipeline(Supplier<? extends Spliterator<Long>> source, int sourceFlags, boolean parallel) {
        super(source, sourceFlags, parallel);
    }

    LongPipeline(Spliterator<Long> source, int sourceFlags, boolean parallel) {
        super(source, sourceFlags, parallel);
    }

    LongPipeline(AbstractPipeline<?, E_IN, ?> upstream, int opFlags) {
        super(upstream, opFlags);
    }

    private static LongConsumer adapt(Sink<Long> sink) {
        if (sink instanceof LongConsumer) {
            return (LongConsumer)((Object)sink);
        }
        Sink<Long> sink2 = sink;
        sink2.getClass();
        return LongPipeline$$Lambda$1.lambdaFactory$(sink2);
    }

    private static Spliterator.OfLong adapt(Spliterator<Long> s) {
        if (s instanceof Spliterator.OfLong) {
            return (Spliterator.OfLong)s;
        }
        throw new UnsupportedOperationException("LongStream.adapt(Spliterator<Long> s)");
    }

    @Override
    final StreamShape getOutputShape() {
        return StreamShape.LONG_VALUE;
    }

    @Override
    final <P_IN> Node<Long> evaluateToNode(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator, boolean flattenTree, IntFunction<Long[]> generator) {
        return Nodes.collectLong(helper, spliterator, flattenTree);
    }

    @Override
    final <P_IN> Spliterator<Long> wrap(PipelineHelper<Long> ph, Supplier<Spliterator<P_IN>> supplier, boolean isParallel) {
        return new StreamSpliterators.LongWrappingSpliterator<P_IN>(ph, supplier, isParallel);
    }

    final Spliterator.OfLong lazySpliterator(Supplier<? extends Spliterator<Long>> supplier) {
        return new StreamSpliterators.DelegatingSpliterator.OfLong((Supplier<Spliterator.OfLong>)supplier);
    }

    @Override
    final boolean forEachWithCancel(Spliterator<Long> spliterator, Sink<Long> sink) {
        boolean cancelled;
        Spliterator.OfLong spl = LongPipeline.adapt(spliterator);
        LongConsumer adaptedSink = LongPipeline.adapt(sink);
        while (!(cancelled = sink.cancellationRequested()) && spl.tryAdvance(adaptedSink)) {
        }
        return cancelled;
    }

    @Override
    final Node.Builder<Long> makeNodeBuilder(long exactSizeIfKnown, IntFunction<Long[]> generator) {
        return Nodes.longBuilder(exactSizeIfKnown);
    }

    private <U> Stream<U> mapToObj(final LongFunction<? extends U> mapper, int opFlags) {
        return new ReferencePipeline.StatelessOp<Long, U>(this, StreamShape.LONG_VALUE, opFlags){

            @Override
            Sink<Long> opWrapSink(int flags, Sink<U> sink) {
                return new Sink.ChainedLong<U>(sink){

                    @Override
                    public void accept(long t) {
                        this.downstream.accept(mapper.apply(t));
                    }
                };
            }
        };
    }

    @Override
    public final PrimitiveIterator.OfLong iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public final Spliterator.OfLong spliterator() {
        return LongPipeline.adapt(super.spliterator());
    }

    @Override
    public final DoubleStream asDoubleStream() {
        return new DoublePipeline.StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedLong<Double>(sink){

                    @Override
                    public void accept(long t) {
                        this.downstream.accept((double)t);
                    }
                };
            }
        };
    }

    @Override
    public final Stream<Long> boxed() {
        return this.mapToObj(LongPipeline$$Lambda$2.lambdaFactory$(), 0);
    }

    @Override
    public final LongStream map(final LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){

                    @Override
                    public void accept(long t) {
                        this.downstream.accept(mapper.applyAsLong(t));
                    }
                };
            }
        };
    }

    @Override
    public final <U> Stream<U> mapToObj(LongFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.mapToObj(mapper, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT);
    }

    @Override
    public final IntStream mapToInt(final LongToIntFunction mapper) {
        Objects.requireNonNull(mapper);
        return new IntPipeline.StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Integer> sink) {
                return new Sink.ChainedLong<Integer>(sink){

                    @Override
                    public void accept(long t) {
                        this.downstream.accept(mapper.applyAsInt(t));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream mapToDouble(final LongToDoubleFunction mapper) {
        Objects.requireNonNull(mapper);
        return new DoublePipeline.StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedLong<Double>(sink){

                    @Override
                    public void accept(long t) {
                        this.downstream.accept(mapper.applyAsDouble(t));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream flatMap(final LongFunction<? extends LongStream> mapper) {
        Objects.requireNonNull(mapper);
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(long t) {
                        BaseStream result2 = null;
                        try {
                            result2 = (LongStream)mapper.apply(t);
                            if (result2 != null) {
                                result2.sequential().forEach(LongPipeline$6$1$$Lambda$1.lambdaFactory$(this));
                            }
                        }
                        finally {
                            if (result2 != null) {
                                result2.close();
                            }
                        }
                    }

                    private /* synthetic */ void lambda$accept$13(long i) {
                        this.downstream.accept(i);
                    }

                    static /* synthetic */ void access$lambda$0(1 var0, long l) {
                        var0.lambda$accept$13(l);
                    }
                };
            }
        };
    }

    @Override
    public LongStream unordered() {
        if (!this.isOrdered()) {
            return this;
        }
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_ORDERED){

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Long> sink) {
                return sink;
            }
        };
    }

    @Override
    public final LongStream filter(final LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(long t) {
                        if (predicate.test(t)) {
                            this.downstream.accept(t);
                        }
                    }
                };
            }
        };
    }

    @Override
    public final LongStream peek(final LongConsumer action) {
        Objects.requireNonNull(action);
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, 0){

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){

                    @Override
                    public void accept(long t) {
                        action.accept(t);
                        this.downstream.accept(t);
                    }
                };
            }
        };
    }

    @Override
    public final LongStream limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException(Long.toString(maxSize));
        }
        return SliceOps.makeLong(this, 0L, maxSize);
    }

    @Override
    public final LongStream skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        if (n == 0L) {
            return this;
        }
        return SliceOps.makeLong(this, n, -1L);
    }

    @Override
    public final LongStream takeWhile(LongPredicate predicate) {
        return WhileOps.makeTakeWhileLong(this, predicate);
    }

    @Override
    public final LongStream dropWhile(LongPredicate predicate) {
        return WhileOps.makeDropWhileLong(this, predicate);
    }

    @Override
    public final LongStream sorted() {
        return SortedOps.makeLong(this);
    }

    @Override
    public final LongStream distinct() {
        return this.boxed().distinct().mapToLong(LongPipeline$$Lambda$3.lambdaFactory$());
    }

    @Override
    public void forEach(LongConsumer action) {
        this.evaluate(ForEachOps.makeLong(action, false));
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        this.evaluate(ForEachOps.makeLong(action, true));
    }

    @Override
    public final long sum() {
        return this.reduce(0L, LongPipeline$$Lambda$4.lambdaFactory$());
    }

    @Override
    public final OptionalLong min() {
        return this.reduce(LongPipeline$$Lambda$5.lambdaFactory$());
    }

    @Override
    public final OptionalLong max() {
        return this.reduce(LongPipeline$$Lambda$6.lambdaFactory$());
    }

    @Override
    public final OptionalDouble average() {
        long[] avg = (long[])this.collect(LongPipeline$$Lambda$7.lambdaFactory$(), LongPipeline$$Lambda$8.lambdaFactory$(), LongPipeline$$Lambda$9.lambdaFactory$());
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public final long count() {
        return this.evaluate(ReduceOps.makeLongCounting());
    }

    @Override
    public final LongSummaryStatistics summaryStatistics() {
        return (LongSummaryStatistics)this.collect(LongPipeline$$Lambda$10.lambdaFactory$(), LongPipeline$$Lambda$11.lambdaFactory$(), LongPipeline$$Lambda$12.lambdaFactory$());
    }

    @Override
    public final long reduce(long identity, LongBinaryOperator op) {
        return this.evaluate(ReduceOps.makeLong(identity, op));
    }

    @Override
    public final OptionalLong reduce(LongBinaryOperator op) {
        return this.evaluate(ReduceOps.makeLong(op));
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(combiner);
        BinaryOperator operator = LongPipeline$$Lambda$13.lambdaFactory$(combiner);
        return this.evaluate(ReduceOps.makeLong(supplier, accumulator, operator));
    }

    @Override
    public final boolean anyMatch(LongPredicate predicate) {
        return this.evaluate(MatchOps.makeLong(predicate, MatchOps.MatchKind.ANY));
    }

    @Override
    public final boolean allMatch(LongPredicate predicate) {
        return this.evaluate(MatchOps.makeLong(predicate, MatchOps.MatchKind.ALL));
    }

    @Override
    public final boolean noneMatch(LongPredicate predicate) {
        return this.evaluate(MatchOps.makeLong(predicate, MatchOps.MatchKind.NONE));
    }

    @Override
    public final OptionalLong findFirst() {
        return this.evaluate(FindOps.makeLong(true));
    }

    @Override
    public final OptionalLong findAny() {
        return this.evaluate(FindOps.makeLong(false));
    }

    @Override
    public final long[] toArray() {
        return (long[])Nodes.flattenLong((Node.OfLong)this.evaluateToArrayNode(LongPipeline$$Lambda$14.lambdaFactory$())).asPrimitiveArray();
    }

    private static /* synthetic */ Long[] lambda$toArray$19(int x$0) {
        return new Long[x$0];
    }

    private static /* synthetic */ Object lambda$collect$18(BiConsumer biConsumer, Object left, Object right) {
        biConsumer.accept(left, right);
        return left;
    }

    private static /* synthetic */ void lambda$average$17(long[] ll, long[] rr) {
        ll[0] = ll[0] + rr[0];
        ll[1] = ll[1] + rr[1];
    }

    private static /* synthetic */ void lambda$average$16(long[] ll, long i) {
        ll[0] = ll[0] + 1L;
        ll[1] = ll[1] + i;
    }

    private static /* synthetic */ long[] lambda$average$15() {
        return new long[2];
    }

    static /* synthetic */ long access$lambda$0(Long l) {
        return l;
    }

    static /* synthetic */ long[] access$lambda$1() {
        return LongPipeline.lambda$average$15();
    }

    static /* synthetic */ void access$lambda$2(long[] lArray, long l) {
        LongPipeline.lambda$average$16(lArray, l);
    }

    static /* synthetic */ void access$lambda$3(long[] lArray, long[] lArray2) {
        LongPipeline.lambda$average$17(lArray, lArray2);
    }

    static /* synthetic */ Object access$lambda$4(BiConsumer biConsumer, Object object, Object object2) {
        return LongPipeline.lambda$collect$18(biConsumer, object, object2);
    }

    static /* synthetic */ Long[] access$lambda$5(int n) {
        return LongPipeline.lambda$toArray$19(n);
    }

    static abstract class StatefulOp<E_IN>
    extends LongPipeline<E_IN> {
        StatefulOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
        }

        @Override
        final boolean opIsStateful() {
            return true;
        }

        @Override
        abstract <P_IN> Node<Long> opEvaluateParallel(PipelineHelper<Long> var1, Spliterator<P_IN> var2, IntFunction<Long[]> var3);
    }

    static abstract class StatelessOp<E_IN>
    extends LongPipeline<E_IN> {
        StatelessOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
        }

        @Override
        final boolean opIsStateful() {
            return false;
        }
    }

    static class Head<E_IN>
    extends LongPipeline<E_IN> {
        Head(Supplier<? extends Spliterator<Long>> source, int sourceFlags, boolean parallel) {
            super(source, sourceFlags, parallel);
        }

        Head(Spliterator<Long> source, int sourceFlags, boolean parallel) {
            super(source, sourceFlags, parallel);
        }

        @Override
        final boolean opIsStateful() {
            throw new UnsupportedOperationException();
        }

        @Override
        final Sink<E_IN> opWrapSink(int flags, Sink<Long> sink) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(LongConsumer action) {
            if (!this.isParallel()) {
                LongPipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(action);
            } else {
                super.forEach(action);
            }
        }

        @Override
        public void forEachOrdered(LongConsumer action) {
            if (!this.isParallel()) {
                LongPipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(action);
            } else {
                super.forEachOrdered(action);
            }
        }
    }
}

