/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.Spliterators;
import java8.util.function.Consumer;
import java8.util.function.Predicate;
import java8.util.function.Supplier;
import java8.util.function.UnaryOperator;
import java8.util.stream.RefStreams$$Lambda$1;
import java8.util.stream.RefStreams$$Lambda$2;
import java8.util.stream.Stream;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.StreamSupport;
import java8.util.stream.Streams;
import java8.util.stream.WhileOps;

public final class RefStreams {
    public static <T> Stream<T> takeWhile(Stream<? extends T> stream, Predicate<? super T> predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        Stream<T> s = stream;
        Stream<T> stream2 = StreamSupport.stream(new WhileOps.UnorderedWhileSpliterator.OfRef.Taking<T>(s.spliterator(), true, predicate), s.isParallel());
        Stream<T> stream3 = s;
        stream3.getClass();
        return (Stream)stream2.onClose(RefStreams$$Lambda$1.lambdaFactory$(stream3));
    }

    public static <T> Stream<T> dropWhile(Stream<? extends T> stream, Predicate<? super T> predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        Stream<T> s = stream;
        Stream<T> stream2 = StreamSupport.stream(new WhileOps.UnorderedWhileSpliterator.OfRef.Dropping<T>(s.spliterator(), true, predicate), s.isParallel());
        Stream<T> stream3 = s;
        stream3.getClass();
        return (Stream)stream2.onClose(RefStreams$$Lambda$2.lambdaFactory$(stream3));
    }

    public static <T> Stream.Builder<T> builder() {
        return new Streams.StreamBuilderImpl();
    }

    public static <T> Stream<T> empty() {
        return StreamSupport.stream(Spliterators.emptySpliterator(), false);
    }

    public static <T> Stream<T> of(T t) {
        return StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> ofNullable(T t) {
        return t == null ? RefStreams.empty() : StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> of(T ... values) {
        return J8Arrays.stream(values);
    }

    public static <T, S extends T> Stream<T> iterate(final S seed, final UnaryOperator<S> f) {
        Objects.requireNonNull(f);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            S prev;
            boolean started;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object s;
                Objects.requireNonNull(action);
                if (this.started) {
                    s = f.apply(this.prev);
                } else {
                    s = seed;
                    this.started = true;
                }
                this.prev = s;
                action.accept(this.prev);
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static <T, S extends T> Stream<T> iterate(final S seed, final Predicate<S> hasNext, final UnaryOperator<S> next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            S prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object s;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    s = next.apply(this.prev);
                } else {
                    s = seed;
                    this.started = true;
                }
                if (!hasNext.test(s)) {
                    this.prev = null;
                    this.finished = true;
                    return false;
                }
                this.prev = s;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                Object s = this.started ? next.apply(this.prev) : seed;
                this.prev = null;
                while (hasNext.test(s)) {
                    action.accept(s);
                    s = next.apply(s);
                }
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> generate(Supplier<? extends T> s) {
        Objects.requireNonNull(s);
        return StreamSupport.stream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfRef<T>(Long.MAX_VALUE, s), false);
    }

    public static <T> Stream<T> concat(Stream<? extends T> a2, Stream<? extends T> b2) {
        Objects.requireNonNull(a2);
        Objects.requireNonNull(b2);
        Streams.ConcatSpliterator.OfRef split = new Streams.ConcatSpliterator.OfRef(a2.spliterator(), b2.spliterator());
        Stream stream = StreamSupport.stream(split, a2.isParallel() || b2.isParallel());
        return (Stream)stream.onClose(Streams.composedClose(a2, b2));
    }

    private RefStreams() {
    }
}

