/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.concurrent.ForkJoinPool;
import java8.util.function.BooleanSupplier;
import java8.util.function.Consumer;
import java8.util.function.DoubleConsumer;
import java8.util.function.DoubleSupplier;
import java8.util.function.IntConsumer;
import java8.util.function.IntSupplier;
import java8.util.function.LongConsumer;
import java8.util.function.LongSupplier;
import java8.util.function.Supplier;
import java8.util.stream.AbstractSpinedBuffer;
import java8.util.stream.AbstractTask;
import java8.util.stream.PipelineHelper;
import java8.util.stream.Sink;
import java8.util.stream.SinkDefaults;
import java8.util.stream.SpinedBuffer;
import java8.util.stream.StreamOpFlag;
import java8.util.stream.StreamSpliterators$DistinctSpliterator$$Lambda$1;
import java8.util.stream.StreamSpliterators$DoubleWrappingSpliterator$$Lambda$1;
import java8.util.stream.StreamSpliterators$IntWrappingSpliterator$$Lambda$1;
import java8.util.stream.StreamSpliterators$LongWrappingSpliterator$$Lambda$1;
import java8.util.stream.StreamSpliterators$SliceSpliterator$OfDouble$$Lambda$1;
import java8.util.stream.StreamSpliterators$SliceSpliterator$OfInt$$Lambda$1;
import java8.util.stream.StreamSpliterators$SliceSpliterator$OfLong$$Lambda$1;
import java8.util.stream.StreamSpliterators$SliceSpliterator$OfRef$$Lambda$1;
import java8.util.stream.StreamSpliterators$SliceSpliterator$OfRef$$Lambda$2;
import java8.util.stream.StreamSpliterators$WrappingSpliterator$$Lambda$1;
import java8.util.stream.StreamSpliterators$WrappingSpliterator$$Lambda$2;
import java8.util.stream.StreamSpliterators$WrappingSpliterator$$Lambda$3;

class StreamSpliterators {
    StreamSpliterators() {
    }

    static abstract class ArrayBuffer {
        int index;

        ArrayBuffer() {
        }

        void reset() {
            this.index = 0;
        }

        static final class OfDouble
        extends OfPrimitive<DoubleConsumer>
        implements DoubleConsumer {
            final double[] array;

            OfDouble(int size) {
                this.array = new double[size];
            }

            @Override
            public void accept(double t) {
                this.array[this.index++] = t;
            }

            @Override
            void forEach(DoubleConsumer action, long fence) {
                int i = 0;
                while ((long)i < fence) {
                    action.accept(this.array[i]);
                    ++i;
                }
            }
        }

        static final class OfLong
        extends OfPrimitive<LongConsumer>
        implements LongConsumer {
            final long[] array;

            OfLong(int size) {
                this.array = new long[size];
            }

            @Override
            public void accept(long t) {
                this.array[this.index++] = t;
            }

            @Override
            public void forEach(LongConsumer action, long fence) {
                int i = 0;
                while ((long)i < fence) {
                    action.accept(this.array[i]);
                    ++i;
                }
            }
        }

        static final class OfInt
        extends OfPrimitive<IntConsumer>
        implements IntConsumer {
            final int[] array;

            OfInt(int size) {
                this.array = new int[size];
            }

            @Override
            public void accept(int t) {
                this.array[this.index++] = t;
            }

            @Override
            public void forEach(IntConsumer action, long fence) {
                int i = 0;
                while ((long)i < fence) {
                    action.accept(this.array[i]);
                    ++i;
                }
            }
        }

        static abstract class OfPrimitive<T_CONS>
        extends ArrayBuffer {
            int index;

            OfPrimitive() {
            }

            @Override
            void reset() {
                this.index = 0;
            }

            abstract void forEach(T_CONS var1, long var2);
        }

        static final class OfRef<T>
        extends ArrayBuffer
        implements Consumer<T> {
            final Object[] array;

            OfRef(int size) {
                this.array = new Object[size];
            }

            @Override
            public void accept(T t) {
                this.array[this.index++] = t;
            }

            public void forEach(Consumer<? super T> action, long fence) {
                int i = 0;
                while ((long)i < fence) {
                    Object t = this.array[i];
                    action.accept(t);
                    ++i;
                }
            }
        }
    }

    static abstract class InfiniteSupplyingSpliterator<T>
    implements Spliterator<T> {
        long estimate;

        protected InfiniteSupplyingSpliterator(long estimate) {
            this.estimate = estimate;
        }

        @Override
        public long estimateSize() {
            return this.estimate;
        }

        @Override
        public int characteristics() {
            return 1024;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super T> getComparator() {
            return Spliterators.getComparator(this);
        }

        static final class OfDouble
        extends InfiniteSupplyingSpliterator<Double>
        implements Spliterator.OfDouble {
            final DoubleSupplier s;

            OfDouble(long size, DoubleSupplier s) {
                super(size);
                this.s = s;
            }

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                Objects.requireNonNull(action);
                action.accept(this.s.getAsDouble());
                return true;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Double> action) {
                return Spliterators.OfDouble.tryAdvance(this, action);
            }

            @Override
            public Spliterator.OfDouble trySplit() {
                if (this.estimate == 0L) {
                    return null;
                }
                return new OfDouble(this.estimate >>>= 1, this.s);
            }

            @Override
            public void forEachRemaining(DoubleConsumer action) {
                Spliterators.OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Double> action) {
                Spliterators.OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
            }
        }

        static final class OfLong
        extends InfiniteSupplyingSpliterator<Long>
        implements Spliterator.OfLong {
            final LongSupplier s;

            OfLong(long size, LongSupplier s) {
                super(size);
                this.s = s;
            }

            @Override
            public boolean tryAdvance(LongConsumer action) {
                Objects.requireNonNull(action);
                action.accept(this.s.getAsLong());
                return true;
            }

            @Override
            public Spliterator.OfLong trySplit() {
                if (this.estimate == 0L) {
                    return null;
                }
                return new OfLong(this.estimate >>>= 1, this.s);
            }

            @Override
            public void forEachRemaining(LongConsumer action) {
                Spliterators.OfLong.forEachRemaining((Spliterator.OfLong)this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Long> action) {
                Spliterators.OfLong.forEachRemaining((Spliterator.OfLong)this, action);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Long> action) {
                return Spliterators.OfLong.tryAdvance(this, action);
            }
        }

        static final class OfInt
        extends InfiniteSupplyingSpliterator<Integer>
        implements Spliterator.OfInt {
            final IntSupplier s;

            OfInt(long size, IntSupplier s) {
                super(size);
                this.s = s;
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                Objects.requireNonNull(action);
                action.accept(this.s.getAsInt());
                return true;
            }

            @Override
            public Spliterator.OfInt trySplit() {
                if (this.estimate == 0L) {
                    return null;
                }
                return new OfInt(this.estimate >>>= 1, this.s);
            }

            @Override
            public void forEachRemaining(IntConsumer action) {
                Spliterators.OfInt.forEachRemaining((Spliterator.OfInt)this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Integer> action) {
                Spliterators.OfInt.forEachRemaining((Spliterator.OfInt)this, action);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Integer> action) {
                return Spliterators.OfInt.tryAdvance(this, action);
            }
        }

        static final class OfRef<T>
        extends InfiniteSupplyingSpliterator<T> {
            final Supplier<T> s;

            OfRef(long size, Supplier<T> s) {
                super(size);
                this.s = s;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                Spliterators.forEachRemaining(this, action);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                action.accept(this.s.get());
                return true;
            }

            @Override
            public Spliterator<T> trySplit() {
                if (this.estimate == 0L) {
                    return null;
                }
                return new OfRef<T>(this.estimate >>>= 1, this.s);
            }
        }
    }

    static final class DistinctSpliterator<T>
    implements Spliterator<T>,
    Consumer<T> {
        private static final Object NULL_VALUE = new Object();
        private final Spliterator<T> s;
        private final ConcurrentMap<T, Boolean> seen;
        private T tmpSlot;

        DistinctSpliterator(Spliterator<T> s) {
            this(s, new ConcurrentHashMap(512, 0.75f, ForkJoinPool.getCommonPoolParallelism() + 1));
        }

        private DistinctSpliterator(Spliterator<T> s, ConcurrentMap<T, Boolean> seen) {
            this.s = s;
            this.seen = seen;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public void accept(T t) {
            this.tmpSlot = t;
        }

        private T mapNull(T t) {
            return (T)(t != null ? t : NULL_VALUE);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            while (this.s.tryAdvance(this)) {
                if (this.seen.putIfAbsent(this.mapNull(this.tmpSlot), Boolean.TRUE) != null) continue;
                action.accept(this.tmpSlot);
                this.tmpSlot = null;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.s.forEachRemaining(StreamSpliterators$DistinctSpliterator$$Lambda$1.lambdaFactory$(this, action));
        }

        @Override
        public Spliterator<T> trySplit() {
            Spliterator<T> split = this.s.trySplit();
            return split != null ? new DistinctSpliterator<T>(split, this.seen) : null;
        }

        @Override
        public long estimateSize() {
            return this.s.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.s.characteristics() & 0xFFFFBFAB | 1;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.s.getComparator();
        }

        private /* synthetic */ void lambda$forEachRemaining$48(Consumer consumer, Object t) {
            if (this.seen.putIfAbsent(this.mapNull(t), Boolean.TRUE) == null) {
                consumer.accept(t);
            }
        }

        static /* synthetic */ void access$lambda$0(DistinctSpliterator distinctSpliterator, Consumer consumer, Object object) {
            distinctSpliterator.lambda$forEachRemaining$48(consumer, object);
        }
    }

    static abstract class UnorderedSliceSpliterator<T, T_SPLITR extends Spliterator<T>> {
        static final int CHUNK_SIZE = 128;
        protected final T_SPLITR s;
        protected final boolean unlimited;
        protected final int chunkSize;
        private final long skipThreshold;
        private final AtomicLong permits;

        UnorderedSliceSpliterator(T_SPLITR s, long skip, long limit) {
            this.s = s;
            this.unlimited = limit < 0L;
            this.skipThreshold = limit >= 0L ? limit : 0L;
            this.chunkSize = limit >= 0L ? (int)Math.min(128L, (skip + limit) / (long)AbstractTask.LEAF_TARGET + 1L) : 128;
            this.permits = new AtomicLong(limit >= 0L ? skip + limit : skip);
        }

        UnorderedSliceSpliterator(T_SPLITR s, UnorderedSliceSpliterator<T, T_SPLITR> parent) {
            this.s = s;
            this.unlimited = parent.unlimited;
            this.permits = parent.permits;
            this.skipThreshold = parent.skipThreshold;
            this.chunkSize = parent.chunkSize;
        }

        protected final long acquirePermits(long numElements) {
            long remainingPermits;
            long grabbing;
            do {
                if ((remainingPermits = this.permits.get()) != 0L) continue;
                return this.unlimited ? numElements : 0L;
            } while ((grabbing = Math.min(remainingPermits, numElements)) > 0L && !this.permits.compareAndSet(remainingPermits, remainingPermits - grabbing));
            if (this.unlimited) {
                return Math.max(numElements - grabbing, 0L);
            }
            if (remainingPermits > this.skipThreshold) {
                return Math.max(grabbing - (remainingPermits - this.skipThreshold), 0L);
            }
            return grabbing;
        }

        protected final PermitStatus permitStatus() {
            if (this.permits.get() > 0L) {
                return PermitStatus.MAYBE_MORE;
            }
            return this.unlimited ? PermitStatus.UNLIMITED : PermitStatus.NO_MORE;
        }

        public final T_SPLITR trySplit() {
            if (this.permits.get() == 0L) {
                return null;
            }
            Spliterator split = this.s.trySplit();
            return (T_SPLITR)(split == null ? null : this.makeSpliterator(split));
        }

        protected abstract T_SPLITR makeSpliterator(T_SPLITR var1);

        public final long estimateSize() {
            return this.s.estimateSize();
        }

        public final int characteristics() {
            return this.s.characteristics() & 0xFFFFBFAF;
        }

        static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, ArrayBuffer.OfDouble, Spliterator.OfDouble>
        implements Spliterator.OfDouble,
        DoubleConsumer {
            double tmpValue;

            OfDouble(Spliterator.OfDouble s, long skip, long limit) {
                super(s, skip, limit);
            }

            OfDouble(Spliterator.OfDouble s, OfDouble parent) {
                super(s, parent);
            }

            @Override
            public void accept(double value) {
                this.tmpValue = value;
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super Double> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Double> action) {
                return Spliterators.OfDouble.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Double> action) {
                Spliterators.OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
            }

            @Override
            protected void acceptConsumed(DoubleConsumer action) {
                action.accept(this.tmpValue);
            }

            @Override
            protected ArrayBuffer.OfDouble bufferCreate(int initialCapacity) {
                return new ArrayBuffer.OfDouble(initialCapacity);
            }

            @Override
            protected Spliterator.OfDouble makeSpliterator(Spliterator.OfDouble s) {
                return new OfDouble(s, this);
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, LongConsumer, ArrayBuffer.OfLong, Spliterator.OfLong>
        implements Spliterator.OfLong,
        LongConsumer {
            long tmpValue;

            OfLong(Spliterator.OfLong s, long skip, long limit) {
                super(s, skip, limit);
            }

            OfLong(Spliterator.OfLong s, OfLong parent) {
                super(s, parent);
            }

            @Override
            public void accept(long value) {
                this.tmpValue = value;
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super Long> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Long> action) {
                return Spliterators.OfLong.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Long> action) {
                Spliterators.OfLong.forEachRemaining((Spliterator.OfLong)this, action);
            }

            @Override
            protected void acceptConsumed(LongConsumer action) {
                action.accept(this.tmpValue);
            }

            @Override
            protected ArrayBuffer.OfLong bufferCreate(int initialCapacity) {
                return new ArrayBuffer.OfLong(initialCapacity);
            }

            @Override
            protected Spliterator.OfLong makeSpliterator(Spliterator.OfLong s) {
                return new OfLong(s, this);
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, ArrayBuffer.OfInt, Spliterator.OfInt>
        implements Spliterator.OfInt,
        IntConsumer {
            int tmpValue;

            OfInt(Spliterator.OfInt s, long skip, long limit) {
                super(s, skip, limit);
            }

            OfInt(Spliterator.OfInt s, OfInt parent) {
                super(s, parent);
            }

            @Override
            public void accept(int value) {
                this.tmpValue = value;
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super Integer> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Integer> action) {
                return Spliterators.OfInt.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Integer> action) {
                Spliterators.OfInt.forEachRemaining((Spliterator.OfInt)this, action);
            }

            @Override
            protected void acceptConsumed(IntConsumer action) {
                action.accept(this.tmpValue);
            }

            @Override
            protected ArrayBuffer.OfInt bufferCreate(int initialCapacity) {
                return new ArrayBuffer.OfInt(initialCapacity);
            }

            @Override
            protected Spliterator.OfInt makeSpliterator(Spliterator.OfInt s) {
                return new OfInt(s, this);
            }
        }

        static abstract class OfPrimitive<T, T_CONS, T_BUFF extends ArrayBuffer.OfPrimitive<T_CONS>, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>>
        extends UnorderedSliceSpliterator<T, T_SPLITR>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(T_SPLITR s, long skip, long limit) {
                super(s, skip, limit);
            }

            OfPrimitive(T_SPLITR s, OfPrimitive<T, T_CONS, T_BUFF, T_SPLITR> parent) {
                super(s, parent);
            }

            @Override
            public boolean tryAdvance(T_CONS action) {
                Objects.requireNonNull(action);
                OfPrimitive consumer = this;
                while (this.permitStatus() != PermitStatus.NO_MORE) {
                    if (!((Spliterator.OfPrimitive)this.s).tryAdvance(consumer)) {
                        return false;
                    }
                    if (this.acquirePermits(1L) != 1L) continue;
                    this.acceptConsumed(action);
                    return true;
                }
                return false;
            }

            protected abstract void acceptConsumed(T_CONS var1);

            @Override
            public void forEachRemaining(T_CONS action) {
                PermitStatus permitStatus;
                Objects.requireNonNull(action);
                ArrayBuffer.OfPrimitive<Object> sb = null;
                while ((permitStatus = this.permitStatus()) != PermitStatus.NO_MORE) {
                    if (permitStatus == PermitStatus.MAYBE_MORE) {
                        if (sb == null) {
                            sb = this.bufferCreate(this.chunkSize);
                        } else {
                            sb.reset();
                        }
                        ArrayBuffer.OfPrimitive sbc = sb;
                        long permitsRequested = 0L;
                        while (((Spliterator.OfPrimitive)this.s).tryAdvance(sbc) && ++permitsRequested < (long)this.chunkSize) {
                        }
                        if (permitsRequested == 0L) {
                            return;
                        }
                        sb.forEach(action, this.acquirePermits(permitsRequested));
                        continue;
                    }
                    ((Spliterator.OfPrimitive)this.s).forEachRemaining(action);
                    return;
                }
            }

            protected abstract T_BUFF bufferCreate(int var1);
        }

        static final class OfRef<T>
        extends UnorderedSliceSpliterator<T, Spliterator<T>>
        implements Spliterator<T>,
        Consumer<T> {
            T tmpSlot;

            OfRef(Spliterator<T> s, long skip, long limit) {
                super(s, skip, limit);
            }

            OfRef(Spliterator<T> s, OfRef<T> parent) {
                super(s, parent);
            }

            @Override
            public final void accept(T t) {
                this.tmpSlot = t;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                while (this.permitStatus() != PermitStatus.NO_MORE) {
                    if (!this.s.tryAdvance(this)) {
                        return false;
                    }
                    if (this.acquirePermits(1L) != 1L) continue;
                    action.accept(this.tmpSlot);
                    this.tmpSlot = null;
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                PermitStatus permitStatus;
                Objects.requireNonNull(action);
                ArrayBuffer.OfRef<T> sb = null;
                while ((permitStatus = this.permitStatus()) != PermitStatus.NO_MORE) {
                    if (permitStatus == PermitStatus.MAYBE_MORE) {
                        if (sb == null) {
                            sb = new ArrayBuffer.OfRef<T>(this.chunkSize);
                        } else {
                            sb.reset();
                        }
                        long permitsRequested = 0L;
                        while (this.s.tryAdvance(sb) && ++permitsRequested < (long)this.chunkSize) {
                        }
                        if (permitsRequested == 0L) {
                            return;
                        }
                        sb.forEach(action, this.acquirePermits(permitsRequested));
                        continue;
                    }
                    this.s.forEachRemaining(action);
                    return;
                }
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super T> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            protected Spliterator<T> makeSpliterator(Spliterator<T> s) {
                return new OfRef<T>(s, this);
            }
        }

        static enum PermitStatus {
            NO_MORE,
            MAYBE_MORE,
            UNLIMITED;

        }
    }

    static abstract class SliceSpliterator<T, T_SPLITR extends Spliterator<T>> {
        final long sliceOrigin;
        final long sliceFence;
        T_SPLITR s;
        long index;
        long fence;

        SliceSpliterator(T_SPLITR s, long sliceOrigin, long sliceFence, long origin, long fence) {
            this.s = s;
            this.sliceOrigin = sliceOrigin;
            this.sliceFence = sliceFence;
            this.index = origin;
            this.fence = fence;
        }

        protected abstract T_SPLITR makeSpliterator(T_SPLITR var1, long var2, long var4, long var6, long var8);

        public T_SPLITR trySplit() {
            long leftSplitFence;
            long leftSplitFenceUnbounded;
            Spliterator leftSplit;
            if (this.sliceOrigin >= this.fence) {
                return null;
            }
            if (this.index >= this.fence) {
                return null;
            }
            while (true) {
                if ((leftSplit = this.s.trySplit()) == null) {
                    return null;
                }
                leftSplitFenceUnbounded = this.index + leftSplit.estimateSize();
                leftSplitFence = Math.min(leftSplitFenceUnbounded, this.sliceFence);
                if (this.sliceOrigin >= leftSplitFence) {
                    this.index = leftSplitFence;
                    continue;
                }
                if (leftSplitFence < this.sliceFence) break;
                this.s = leftSplit;
                this.fence = leftSplitFence;
            }
            if (this.index >= this.sliceOrigin && leftSplitFenceUnbounded <= this.sliceFence) {
                this.index = leftSplitFence;
                return (T_SPLITR)leftSplit;
            }
            this.index = leftSplitFence;
            return (T_SPLITR)this.makeSpliterator(leftSplit, this.sliceOrigin, this.sliceFence, this.index, this.index);
        }

        public long estimateSize() {
            return this.sliceOrigin < this.fence ? this.fence - Math.max(this.sliceOrigin, this.index) : 0L;
        }

        public int characteristics() {
            return this.s.characteristics();
        }

        static final class OfDouble
        extends OfPrimitive<Double, Spliterator.OfDouble, DoubleConsumer>
        implements Spliterator.OfDouble {
            OfDouble(Spliterator.OfDouble s, long sliceOrigin, long sliceFence) {
                super(s, sliceOrigin, sliceFence);
            }

            OfDouble(Spliterator.OfDouble s, long sliceOrigin, long sliceFence, long origin, long fence) {
                super(s, sliceOrigin, sliceFence, origin, fence);
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super Double> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Double> action) {
                return Spliterators.OfDouble.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Double> action) {
                Spliterators.OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
            }

            @Override
            protected Spliterator.OfDouble makeSpliterator(Spliterator.OfDouble s, long sliceOrigin, long sliceFence, long origin, long fence) {
                return new OfDouble(s, sliceOrigin, sliceFence, origin, fence);
            }

            @Override
            protected DoubleConsumer emptyConsumer() {
                return StreamSpliterators$SliceSpliterator$OfDouble$$Lambda$1.lambdaFactory$();
            }

            private static /* synthetic */ void lambda$emptyConsumer$47(double e) {
            }

            static /* synthetic */ void access$lambda$0(double d) {
                OfDouble.lambda$emptyConsumer$47(d);
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, Spliterator.OfLong, LongConsumer>
        implements Spliterator.OfLong {
            OfLong(Spliterator.OfLong s, long sliceOrigin, long sliceFence) {
                super(s, sliceOrigin, sliceFence);
            }

            OfLong(Spliterator.OfLong s, long sliceOrigin, long sliceFence, long origin, long fence) {
                super(s, sliceOrigin, sliceFence, origin, fence);
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super Long> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Long> action) {
                return Spliterators.OfLong.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Long> action) {
                Spliterators.OfLong.forEachRemaining((Spliterator.OfLong)this, action);
            }

            @Override
            protected Spliterator.OfLong makeSpliterator(Spliterator.OfLong s, long sliceOrigin, long sliceFence, long origin, long fence) {
                return new OfLong(s, sliceOrigin, sliceFence, origin, fence);
            }

            @Override
            protected LongConsumer emptyConsumer() {
                return StreamSpliterators$SliceSpliterator$OfLong$$Lambda$1.lambdaFactory$();
            }

            private static /* synthetic */ void lambda$emptyConsumer$46(long e) {
            }

            static /* synthetic */ void access$lambda$0(long l) {
                OfLong.lambda$emptyConsumer$46(l);
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, Spliterator.OfInt, IntConsumer>
        implements Spliterator.OfInt {
            OfInt(Spliterator.OfInt s, long sliceOrigin, long sliceFence) {
                super(s, sliceOrigin, sliceFence);
            }

            OfInt(Spliterator.OfInt s, long sliceOrigin, long sliceFence, long origin, long fence) {
                super(s, sliceOrigin, sliceFence, origin, fence);
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super Integer> getComparator() {
                return Spliterators.getComparator(this);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Integer> action) {
                return Spliterators.OfInt.tryAdvance(this, action);
            }

            @Override
            public void forEachRemaining(Consumer<? super Integer> action) {
                Spliterators.OfInt.forEachRemaining((Spliterator.OfInt)this, action);
            }

            @Override
            protected Spliterator.OfInt makeSpliterator(Spliterator.OfInt s, long sliceOrigin, long sliceFence, long origin, long fence) {
                return new OfInt(s, sliceOrigin, sliceFence, origin, fence);
            }

            @Override
            protected IntConsumer emptyConsumer() {
                return StreamSpliterators$SliceSpliterator$OfInt$$Lambda$1.lambdaFactory$();
            }

            private static /* synthetic */ void lambda$emptyConsumer$45(int e) {
            }

            static /* synthetic */ void access$lambda$0(int n) {
                OfInt.lambda$emptyConsumer$45(n);
            }
        }

        static abstract class OfPrimitive<T, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>, T_CONS>
        extends SliceSpliterator<T, T_SPLITR>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(T_SPLITR s, long sliceOrigin, long sliceFence) {
                this(s, sliceOrigin, sliceFence, 0L, Math.min(s.estimateSize(), sliceFence));
            }

            OfPrimitive(T_SPLITR s, long sliceOrigin, long sliceFence, long origin, long fence) {
                super(s, sliceOrigin, sliceFence, origin, fence);
            }

            @Override
            public boolean tryAdvance(T_CONS action) {
                Objects.requireNonNull(action);
                if (this.sliceOrigin >= this.fence) {
                    return false;
                }
                while (this.sliceOrigin > this.index) {
                    ((Spliterator.OfPrimitive)this.s).tryAdvance(this.emptyConsumer());
                    ++this.index;
                }
                if (this.index >= this.fence) {
                    return false;
                }
                ++this.index;
                return ((Spliterator.OfPrimitive)this.s).tryAdvance(action);
            }

            @Override
            public void forEachRemaining(T_CONS action) {
                Objects.requireNonNull(action);
                if (this.sliceOrigin >= this.fence) {
                    return;
                }
                if (this.index >= this.fence) {
                    return;
                }
                if (this.index >= this.sliceOrigin && this.index + ((Spliterator.OfPrimitive)this.s).estimateSize() <= this.sliceFence) {
                    ((Spliterator.OfPrimitive)this.s).forEachRemaining(action);
                    this.index = this.fence;
                } else {
                    while (this.sliceOrigin > this.index) {
                        ((Spliterator.OfPrimitive)this.s).tryAdvance(this.emptyConsumer());
                        ++this.index;
                    }
                    while (this.index < this.fence) {
                        ((Spliterator.OfPrimitive)this.s).tryAdvance(action);
                        ++this.index;
                    }
                }
            }

            protected abstract T_CONS emptyConsumer();
        }

        static final class OfRef<T>
        extends SliceSpliterator<T, Spliterator<T>>
        implements Spliterator<T> {
            OfRef(Spliterator<T> s, long sliceOrigin, long sliceFence) {
                this(s, sliceOrigin, sliceFence, 0L, Math.min(s.estimateSize(), sliceFence));
            }

            private OfRef(Spliterator<T> s, long sliceOrigin, long sliceFence, long origin, long fence) {
                super(s, sliceOrigin, sliceFence, origin, fence);
            }

            @Override
            protected Spliterator<T> makeSpliterator(Spliterator<T> s, long sliceOrigin, long sliceFence, long origin, long fence) {
                return new OfRef<T>(s, sliceOrigin, sliceFence, origin, fence);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                if (this.sliceOrigin >= this.fence) {
                    return false;
                }
                while (this.sliceOrigin > this.index) {
                    this.s.tryAdvance(StreamSpliterators$SliceSpliterator$OfRef$$Lambda$1.lambdaFactory$());
                    ++this.index;
                }
                if (this.index >= this.fence) {
                    return false;
                }
                ++this.index;
                return this.s.tryAdvance(action);
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                if (this.sliceOrigin >= this.fence) {
                    return;
                }
                if (this.index >= this.fence) {
                    return;
                }
                if (this.index >= this.sliceOrigin && this.index + this.s.estimateSize() <= this.sliceFence) {
                    this.s.forEachRemaining(action);
                    this.index = this.fence;
                } else {
                    while (this.sliceOrigin > this.index) {
                        this.s.tryAdvance(StreamSpliterators$SliceSpliterator$OfRef$$Lambda$2.lambdaFactory$());
                        ++this.index;
                    }
                    while (this.index < this.fence) {
                        this.s.tryAdvance(action);
                        ++this.index;
                    }
                }
            }

            @Override
            public long getExactSizeIfKnown() {
                return Spliterators.getExactSizeIfKnown(this);
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return Spliterators.hasCharacteristics(this, characteristics);
            }

            @Override
            public Comparator<? super T> getComparator() {
                return Spliterators.getComparator(this);
            }

            private static /* synthetic */ void lambda$forEachRemaining$44(Object e) {
            }

            private static /* synthetic */ void lambda$tryAdvance$43(Object e) {
            }

            static /* synthetic */ void access$lambda$0(Object object) {
                OfRef.lambda$tryAdvance$43(object);
            }

            static /* synthetic */ void access$lambda$1(Object object) {
                OfRef.lambda$forEachRemaining$44(object);
            }
        }
    }

    static class DelegatingSpliterator<T, T_SPLITR extends Spliterator<T>>
    implements Spliterator<T> {
        private final Supplier<? extends T_SPLITR> supplier;
        private T_SPLITR s;

        DelegatingSpliterator(Supplier<? extends T_SPLITR> supplier) {
            this.supplier = supplier;
        }

        T_SPLITR get() {
            if (this.s == null) {
                this.s = (Spliterator)this.supplier.get();
            }
            return this.s;
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        public T_SPLITR trySplit() {
            return (T_SPLITR)this.get().trySplit();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            return this.get().tryAdvance(consumer);
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            this.get().forEachRemaining(consumer);
        }

        @Override
        public long estimateSize() {
            return this.get().estimateSize();
        }

        @Override
        public int characteristics() {
            return this.get().characteristics();
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.get().getComparator();
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.get().getExactSizeIfKnown();
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.get() + "]";
        }

        static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, Spliterator.OfDouble>
        implements Spliterator.OfDouble {
            OfDouble(Supplier<Spliterator.OfDouble> supplier) {
                super(supplier);
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, LongConsumer, Spliterator.OfLong>
        implements Spliterator.OfLong {
            OfLong(Supplier<Spliterator.OfLong> supplier) {
                super(supplier);
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, Spliterator.OfInt>
        implements Spliterator.OfInt {
            OfInt(Supplier<Spliterator.OfInt> supplier) {
                super(supplier);
            }
        }

        static class OfPrimitive<T, T_CONS, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>>
        extends DelegatingSpliterator<T, T_SPLITR>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(Supplier<? extends T_SPLITR> supplier) {
                super(supplier);
            }

            @Override
            public boolean tryAdvance(T_CONS consumer) {
                return ((Spliterator.OfPrimitive)this.get()).tryAdvance(consumer);
            }

            @Override
            public void forEachRemaining(T_CONS consumer) {
                ((Spliterator.OfPrimitive)this.get()).forEachRemaining(consumer);
            }
        }
    }

    static final class DoubleWrappingSpliterator<P_IN>
    extends AbstractWrappingSpliterator<P_IN, Double, SpinedBuffer.OfDouble>
    implements Spliterator.OfDouble {
        DoubleWrappingSpliterator(PipelineHelper<Double> ph, Supplier<Spliterator<P_IN>> supplier, boolean parallel) {
            super(ph, supplier, parallel);
        }

        DoubleWrappingSpliterator(PipelineHelper<Double> ph, Spliterator<P_IN> spliterator, boolean parallel) {
            super(ph, spliterator, parallel);
        }

        @Override
        AbstractWrappingSpliterator<P_IN, Double, ?> wrap(Spliterator<P_IN> s) {
            return new DoubleWrappingSpliterator<P_IN>((PipelineHelper<Double>)this.ph, s, this.isParallel);
        }

        @Override
        void initPartialTraversalState() {
            final SpinedBuffer.OfDouble b2 = new SpinedBuffer.OfDouble();
            this.buffer = b2;
            Sink.OfDouble trampoline = new Sink.OfDouble(){

                @Override
                public void begin(long size) {
                }

                @Override
                public void end() {
                }

                @Override
                public boolean cancellationRequested() {
                    return false;
                }

                @Override
                public void accept(int value) {
                    SinkDefaults.accept(this, value);
                }

                @Override
                public void accept(long value) {
                    SinkDefaults.accept(this, value);
                }

                @Override
                public void accept(double value) {
                    b2.accept(value);
                }

                @Override
                public void accept(Double i) {
                    this.accept((double)i);
                }
            };
            this.bufferSink = this.ph.wrapSink(trampoline);
            this.pusher = StreamSpliterators$DoubleWrappingSpliterator$$Lambda$1.lambdaFactory$(this);
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            return (Spliterator.OfDouble)super.trySplit();
        }

        @Override
        public boolean tryAdvance(DoubleConsumer consumer) {
            Objects.requireNonNull(consumer);
            boolean hasNext = this.doAdvance();
            if (hasNext) {
                consumer.accept(((SpinedBuffer.OfDouble)this.buffer).get(this.nextToConsume));
            }
            return hasNext;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Double> action) {
            return Spliterators.OfDouble.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(final DoubleConsumer consumer) {
            if (this.buffer == null && !this.finished) {
                Objects.requireNonNull(consumer);
                this.init();
                Sink.OfDouble trampoline = new Sink.OfDouble(){

                    @Override
                    public void begin(long size) {
                    }

                    @Override
                    public void end() {
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return false;
                    }

                    @Override
                    public void accept(int value) {
                        SinkDefaults.accept(this, value);
                    }

                    @Override
                    public void accept(long value) {
                        SinkDefaults.accept(this, value);
                    }

                    @Override
                    public void accept(double value) {
                        consumer.accept(value);
                    }

                    @Override
                    public void accept(Double i) {
                        this.accept((double)i);
                    }
                };
                this.ph.wrapAndCopyInto(trampoline, this.spliterator);
                this.finished = true;
            } else {
                while (this.tryAdvance(consumer)) {
                }
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Double> action) {
            Spliterators.OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
        }

        private /* synthetic */ boolean lambda$initPartialTraversalState$42() {
            return this.spliterator.tryAdvance(this.bufferSink);
        }

        static /* synthetic */ boolean access$lambda$0(DoubleWrappingSpliterator doubleWrappingSpliterator) {
            return doubleWrappingSpliterator.lambda$initPartialTraversalState$42();
        }
    }

    static final class LongWrappingSpliterator<P_IN>
    extends AbstractWrappingSpliterator<P_IN, Long, SpinedBuffer.OfLong>
    implements Spliterator.OfLong {
        LongWrappingSpliterator(PipelineHelper<Long> ph, Supplier<Spliterator<P_IN>> supplier, boolean parallel) {
            super(ph, supplier, parallel);
        }

        LongWrappingSpliterator(PipelineHelper<Long> ph, Spliterator<P_IN> spliterator, boolean parallel) {
            super(ph, spliterator, parallel);
        }

        @Override
        AbstractWrappingSpliterator<P_IN, Long, ?> wrap(Spliterator<P_IN> s) {
            return new LongWrappingSpliterator<P_IN>((PipelineHelper<Long>)this.ph, s, this.isParallel);
        }

        @Override
        void initPartialTraversalState() {
            final SpinedBuffer.OfLong b2 = new SpinedBuffer.OfLong();
            this.buffer = b2;
            Sink.OfLong trampoline = new Sink.OfLong(){

                @Override
                public void end() {
                }

                @Override
                public boolean cancellationRequested() {
                    return false;
                }

                @Override
                public void begin(long size) {
                }

                @Override
                public void accept(double value) {
                    SinkDefaults.accept(this, value);
                }

                @Override
                public void accept(int value) {
                    SinkDefaults.accept(this, value);
                }

                @Override
                public void accept(Long i) {
                    this.accept((long)i);
                }

                @Override
                public void accept(long value) {
                    b2.accept(value);
                }
            };
            this.bufferSink = this.ph.wrapSink(trampoline);
            this.pusher = StreamSpliterators$LongWrappingSpliterator$$Lambda$1.lambdaFactory$(this);
        }

        @Override
        public Spliterator.OfLong trySplit() {
            return (Spliterator.OfLong)super.trySplit();
        }

        @Override
        public boolean tryAdvance(LongConsumer consumer) {
            Objects.requireNonNull(consumer);
            boolean hasNext = this.doAdvance();
            if (hasNext) {
                consumer.accept(((SpinedBuffer.OfLong)this.buffer).get(this.nextToConsume));
            }
            return hasNext;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Long> action) {
            return Spliterators.OfLong.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(final LongConsumer consumer) {
            if (this.buffer == null && !this.finished) {
                Objects.requireNonNull(consumer);
                this.init();
                Sink.OfLong trampoline = new Sink.OfLong(){

                    @Override
                    public void end() {
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return false;
                    }

                    @Override
                    public void begin(long size) {
                    }

                    @Override
                    public void accept(double value) {
                        SinkDefaults.accept(this, value);
                    }

                    @Override
                    public void accept(int value) {
                        SinkDefaults.accept(this, value);
                    }

                    @Override
                    public void accept(Long i) {
                        this.accept((long)i);
                    }

                    @Override
                    public void accept(long value) {
                        consumer.accept(value);
                    }
                };
                this.ph.wrapAndCopyInto(trampoline, this.spliterator);
                this.finished = true;
            } else {
                while (this.tryAdvance(consumer)) {
                }
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> action) {
            Spliterators.OfLong.forEachRemaining((Spliterator.OfLong)this, action);
        }

        private /* synthetic */ boolean lambda$initPartialTraversalState$41() {
            return this.spliterator.tryAdvance(this.bufferSink);
        }

        static /* synthetic */ boolean access$lambda$0(LongWrappingSpliterator longWrappingSpliterator) {
            return longWrappingSpliterator.lambda$initPartialTraversalState$41();
        }
    }

    static final class IntWrappingSpliterator<P_IN>
    extends AbstractWrappingSpliterator<P_IN, Integer, SpinedBuffer.OfInt>
    implements Spliterator.OfInt {
        IntWrappingSpliterator(PipelineHelper<Integer> ph, Supplier<Spliterator<P_IN>> supplier, boolean parallel) {
            super(ph, supplier, parallel);
        }

        IntWrappingSpliterator(PipelineHelper<Integer> ph, Spliterator<P_IN> spliterator, boolean parallel) {
            super(ph, spliterator, parallel);
        }

        @Override
        AbstractWrappingSpliterator<P_IN, Integer, ?> wrap(Spliterator<P_IN> s) {
            return new IntWrappingSpliterator<P_IN>((PipelineHelper<Integer>)this.ph, s, this.isParallel);
        }

        @Override
        void initPartialTraversalState() {
            final SpinedBuffer.OfInt b2 = new SpinedBuffer.OfInt();
            this.buffer = b2;
            Sink.OfInt trampoline = new Sink.OfInt(){

                @Override
                public void end() {
                }

                @Override
                public boolean cancellationRequested() {
                    return false;
                }

                @Override
                public void begin(long size) {
                }

                @Override
                public void accept(double value) {
                    SinkDefaults.accept(this, value);
                }

                @Override
                public void accept(long value) {
                    SinkDefaults.accept(this, value);
                }

                @Override
                public void accept(Integer i) {
                    this.accept((int)i);
                }

                @Override
                public void accept(int value) {
                    b2.accept(value);
                }
            };
            this.bufferSink = this.ph.wrapSink(trampoline);
            this.pusher = StreamSpliterators$IntWrappingSpliterator$$Lambda$1.lambdaFactory$(this);
        }

        @Override
        public Spliterator.OfInt trySplit() {
            return (Spliterator.OfInt)super.trySplit();
        }

        @Override
        public boolean tryAdvance(IntConsumer consumer) {
            Objects.requireNonNull(consumer);
            boolean hasNext = this.doAdvance();
            if (hasNext) {
                consumer.accept(((SpinedBuffer.OfInt)this.buffer).get(this.nextToConsume));
            }
            return hasNext;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Integer> action) {
            return Spliterators.OfInt.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(final IntConsumer consumer) {
            if (this.buffer == null && !this.finished) {
                Objects.requireNonNull(consumer);
                this.init();
                Sink.OfInt trampoline = new Sink.OfInt(){

                    @Override
                    public void end() {
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return false;
                    }

                    @Override
                    public void begin(long size) {
                    }

                    @Override
                    public void accept(double value) {
                        SinkDefaults.accept(this, value);
                    }

                    @Override
                    public void accept(long value) {
                        SinkDefaults.accept(this, value);
                    }

                    @Override
                    public void accept(Integer i) {
                        this.accept((int)i);
                    }

                    @Override
                    public void accept(int value) {
                        consumer.accept(value);
                    }
                };
                this.ph.wrapAndCopyInto(trampoline, this.spliterator);
                this.finished = true;
            } else {
                while (this.tryAdvance(consumer)) {
                }
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> action) {
            Spliterators.OfInt.forEachRemaining((Spliterator.OfInt)this, action);
        }

        private /* synthetic */ boolean lambda$initPartialTraversalState$40() {
            return this.spliterator.tryAdvance(this.bufferSink);
        }

        static /* synthetic */ boolean access$lambda$0(IntWrappingSpliterator intWrappingSpliterator) {
            return intWrappingSpliterator.lambda$initPartialTraversalState$40();
        }
    }

    static final class WrappingSpliterator<P_IN, P_OUT>
    extends AbstractWrappingSpliterator<P_IN, P_OUT, SpinedBuffer<P_OUT>> {
        WrappingSpliterator(PipelineHelper<P_OUT> ph, Supplier<Spliterator<P_IN>> supplier, boolean parallel) {
            super(ph, supplier, parallel);
        }

        WrappingSpliterator(PipelineHelper<P_OUT> ph, Spliterator<P_IN> spliterator, boolean parallel) {
            super(ph, spliterator, parallel);
        }

        WrappingSpliterator<P_IN, P_OUT> wrap(Spliterator<P_IN> s) {
            return new WrappingSpliterator<P_IN, P_OUT>(this.ph, s, this.isParallel);
        }

        @Override
        void initPartialTraversalState() {
            SpinedBuffer b2;
            this.buffer = b2 = new SpinedBuffer();
            SpinedBuffer spinedBuffer = b2;
            spinedBuffer.getClass();
            this.bufferSink = this.ph.wrapSink(StreamSpliterators$WrappingSpliterator$$Lambda$1.lambdaFactory$(spinedBuffer));
            this.pusher = StreamSpliterators$WrappingSpliterator$$Lambda$2.lambdaFactory$(this);
        }

        @Override
        public boolean tryAdvance(Consumer<? super P_OUT> consumer) {
            Objects.requireNonNull(consumer);
            boolean hasNext = this.doAdvance();
            if (hasNext) {
                consumer.accept(((SpinedBuffer)this.buffer).get(this.nextToConsume));
            }
            return hasNext;
        }

        @Override
        public void forEachRemaining(Consumer<? super P_OUT> consumer) {
            if (this.buffer == null && !this.finished) {
                Objects.requireNonNull(consumer);
                this.init();
                Consumer<P_OUT> consumer2 = consumer;
                consumer2.getClass();
                this.ph.wrapAndCopyInto(StreamSpliterators$WrappingSpliterator$$Lambda$3.lambdaFactory$(consumer2), this.spliterator);
                this.finished = true;
            } else {
                while (this.tryAdvance((Consumer<? super P_OUT>)consumer)) {
                }
            }
        }

        private /* synthetic */ boolean lambda$initPartialTraversalState$39() {
            return this.spliterator.tryAdvance(this.bufferSink);
        }

        static /* synthetic */ boolean access$lambda$0(WrappingSpliterator wrappingSpliterator) {
            return wrappingSpliterator.lambda$initPartialTraversalState$39();
        }
    }

    private static abstract class AbstractWrappingSpliterator<P_IN, P_OUT, T_BUFFER extends AbstractSpinedBuffer>
    implements Spliterator<P_OUT> {
        final boolean isParallel;
        final PipelineHelper<P_OUT> ph;
        private Supplier<Spliterator<P_IN>> spliteratorSupplier;
        Spliterator<P_IN> spliterator;
        Sink<P_IN> bufferSink;
        BooleanSupplier pusher;
        long nextToConsume;
        T_BUFFER buffer;
        boolean finished;

        AbstractWrappingSpliterator(PipelineHelper<P_OUT> ph, Supplier<Spliterator<P_IN>> spliteratorSupplier, boolean parallel) {
            this.ph = ph;
            this.spliteratorSupplier = spliteratorSupplier;
            this.spliterator = null;
            this.isParallel = parallel;
        }

        AbstractWrappingSpliterator(PipelineHelper<P_OUT> ph, Spliterator<P_IN> spliterator, boolean parallel) {
            this.ph = ph;
            this.spliteratorSupplier = null;
            this.spliterator = spliterator;
            this.isParallel = parallel;
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        final void init() {
            if (this.spliterator == null) {
                this.spliterator = this.spliteratorSupplier.get();
                this.spliteratorSupplier = null;
            }
        }

        final boolean doAdvance() {
            boolean hasNext;
            if (this.buffer == null) {
                if (this.finished) {
                    return false;
                }
                this.init();
                this.initPartialTraversalState();
                this.nextToConsume = 0L;
                this.bufferSink.begin(this.spliterator.getExactSizeIfKnown());
                return this.fillBuffer();
            }
            ++this.nextToConsume;
            boolean bl = hasNext = this.nextToConsume < ((AbstractSpinedBuffer)this.buffer).count();
            if (!hasNext) {
                this.nextToConsume = 0L;
                ((AbstractSpinedBuffer)this.buffer).clear();
                hasNext = this.fillBuffer();
            }
            return hasNext;
        }

        abstract AbstractWrappingSpliterator<P_IN, P_OUT, ?> wrap(Spliterator<P_IN> var1);

        abstract void initPartialTraversalState();

        @Override
        public Spliterator<P_OUT> trySplit() {
            if (this.isParallel && this.buffer == null && !this.finished) {
                this.init();
                Spliterator<P_IN> split = this.spliterator.trySplit();
                return split == null ? null : this.wrap(split);
            }
            return null;
        }

        private boolean fillBuffer() {
            while (((AbstractSpinedBuffer)this.buffer).count() == 0L) {
                if (!this.bufferSink.cancellationRequested() && this.pusher.getAsBoolean()) continue;
                if (this.finished) {
                    return false;
                }
                this.bufferSink.end();
                this.finished = true;
            }
            return true;
        }

        @Override
        public final long estimateSize() {
            this.init();
            return this.spliterator.estimateSize();
        }

        @Override
        public final long getExactSizeIfKnown() {
            this.init();
            return StreamOpFlag.SIZED.isKnown(this.ph.getStreamAndOpFlags()) ? this.spliterator.getExactSizeIfKnown() : -1L;
        }

        @Override
        public final int characteristics() {
            this.init();
            int c2 = StreamOpFlag.toCharacteristics(StreamOpFlag.toStreamFlags(this.ph.getStreamAndOpFlags()));
            if ((c2 & 0x40) != 0) {
                c2 &= 0xFFFFBFBF;
                c2 |= this.spliterator.characteristics() & 0x4040;
            }
            return c2;
        }

        @Override
        public Comparator<? super P_OUT> getComparator() {
            if (!this.hasCharacteristics(4)) {
                throw new IllegalStateException();
            }
            return null;
        }

        public final String toString() {
            return String.format("%s[%s]", this.getClass().getName(), this.spliterator);
        }
    }
}

