/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;

public class IntegerSpec
extends ModuleSpec {
    protected static int MAX_INT = Integer.MAX_VALUE;

    public IntegerSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public IntegerSpec(int nt, int nc, byte type, J2KImageWriteParamJava wp, String values, String defaultValue) {
        super(nt, nc, type);
        if (values == null) {
            try {
                this.setDefault(new Integer(defaultValue));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Non recognized value for option -: " + defaultValue);
            }
            return;
        }
        StringTokenizer stk = new StringTokenizer(values);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = ModuleSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        break;
                    }
                    curSpecType = 2;
                    break;
                }
                case 'c': {
                    compSpec = ModuleSpec.parseIdx(word, this.nComp);
                    if (curSpecType == 2) {
                        curSpecType = 3;
                        break;
                    }
                    curSpecType = 1;
                    break;
                }
                default: {
                    int i;
                    Integer value;
                    try {
                        value = new Integer(word);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Non recognized value for option -: " + word);
                    }
                    if (curSpecType == 0) {
                        this.setDefault(value);
                    } else if (curSpecType == 2) {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            if (tileSpec[i]) {
                                this.setTileDef(i, value);
                            }
                            --i;
                        }
                    } else if (curSpecType == 1) {
                        i = compSpec.length - 1;
                        while (i >= 0) {
                            if (compSpec[i]) {
                                this.setCompDef(i, value);
                            }
                            --i;
                        }
                    } else {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            int j = compSpec.length - 1;
                            while (j >= 0) {
                                if (tileSpec[i] && compSpec[j]) {
                                    this.setTileCompVal(i, j, value);
                                }
                                --j;
                            }
                            --i;
                        }
                    }
                    curSpecType = 0;
                    tileSpec = null;
                    compSpec = null;
                }
            }
        }
        if (this.getDefault() == null) {
            int c2;
            int ndefspec = 0;
            int t = nt - 1;
            while (t >= 0) {
                c2 = nc - 1;
                while (c2 >= 0) {
                    if (this.specValType[t][c2] == 0) {
                        ++ndefspec;
                    }
                    --c2;
                }
                --t;
            }
            if (ndefspec != 0) {
                try {
                    this.setDefault(new Integer(defaultValue));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Non recognized value for option - : " + defaultValue);
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        c2 = nc - 1;
                        while (c2 >= 0) {
                            if (this.specValType[0][c2] == 2) {
                                this.specValType[0][c2] = 0;
                            }
                            --c2;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        int t2 = nt - 1;
                        while (t2 >= 0) {
                            if (this.specValType[t2][0] == 1) {
                                this.specValType[t2][0] = 0;
                            }
                            --t2;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }

    public int getMax() {
        int max = (Integer)this.def;
        int t = 0;
        while (t < this.nTiles) {
            int c2 = 0;
            while (c2 < this.nComp) {
                int tmp = (Integer)this.getSpec(t, c2);
                if (max < tmp) {
                    max = tmp;
                }
                ++c2;
            }
            ++t;
        }
        return max;
    }

    public int getMin() {
        int min = (Integer)this.def;
        int t = 0;
        while (t < this.nTiles) {
            int c2 = 0;
            while (c2 < this.nComp) {
                int tmp = (Integer)this.getSpec(t, c2);
                if (min > tmp) {
                    min = tmp;
                }
                ++c2;
            }
            ++t;
        }
        return min;
    }

    public int getMaxInComp(int c2) {
        int max = 0;
        int t = 0;
        while (t < this.nTiles) {
            int tmp = (Integer)this.getSpec(t, c2);
            if (max < tmp) {
                max = tmp;
            }
            ++t;
        }
        return max;
    }

    public int getMinInComp(int c2) {
        int min = MAX_INT;
        int t = 0;
        while (t < this.nTiles) {
            int tmp = (Integer)this.getSpec(t, c2);
            if (min > tmp) {
                min = tmp;
            }
            ++t;
        }
        return min;
    }

    public int getMaxInTile(int t) {
        int max = 0;
        int c2 = 0;
        while (c2 < this.nComp) {
            int tmp = (Integer)this.getSpec(t, c2);
            if (max < tmp) {
                max = tmp;
            }
            ++c2;
        }
        return max;
    }

    public int getMinInTile(int t) {
        int min = MAX_INT;
        int c2 = 0;
        while (c2 < this.nComp) {
            int tmp = (Integer)this.getSpec(t, c2);
            if (min > tmp) {
                min = tmp;
            }
            ++c2;
        }
        return min;
    }
}

