/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k;

import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;

public class ModuleSpec
implements Cloneable {
    public static final byte SPEC_TYPE_COMP = 0;
    public static final byte SPEC_TYPE_TILE = 1;
    public static final byte SPEC_TYPE_TILE_COMP = 2;
    public static final byte SPEC_DEF = 0;
    public static final byte SPEC_COMP_DEF = 1;
    public static final byte SPEC_TILE_DEF = 2;
    public static final byte SPEC_TILE_COMP = 3;
    protected int specType;
    protected int nTiles = 0;
    protected int nComp = 0;
    protected byte[][] specValType;
    protected Object def = null;
    protected Object[] compDef = null;
    protected Object[] tileDef = null;
    protected Hashtable tileCompVal;
    protected String specified;

    public ModuleSpec getCopy() {
        return (ModuleSpec)this.clone();
    }

    public ModuleSpec(int nt, int nc, byte type) {
        this.nTiles = nt;
        this.nComp = nc;
        this.specValType = new byte[nt][nc];
        switch (type) {
            case 1: {
                this.specType = 1;
                break;
            }
            case 0: {
                this.specType = 0;
                break;
            }
            case 2: {
                this.specType = 2;
            }
        }
    }

    protected Object clone() {
        ModuleSpec ms;
        try {
            ms = (ModuleSpec)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error when cloning ModuleSpec instance");
        }
        ms.specValType = new byte[this.nTiles][this.nComp];
        int t = 0;
        while (t < this.nTiles) {
            int c2 = 0;
            while (c2 < this.nComp) {
                ms.specValType[t][c2] = this.specValType[t][c2];
                ++c2;
            }
            ++t;
        }
        if (this.tileDef != null) {
            ms.tileDef = new Object[this.nTiles];
            int t2 = 0;
            while (t2 < this.nTiles) {
                ms.tileDef[t2] = this.tileDef[t2];
                ++t2;
            }
        }
        if (this.tileCompVal != null) {
            ms.tileCompVal = new Hashtable();
            Enumeration e = this.tileCompVal.keys();
            while (e.hasMoreElements()) {
                String tmpKey = (String)e.nextElement();
                Object tmpVal = this.tileCompVal.get(tmpKey);
                ms.tileCompVal.put(tmpKey, tmpVal);
            }
        }
        return ms;
    }

    public void rotate90(Point anT) {
        int ax;
        int ay;
        byte[][] tmpsvt = new byte[this.nTiles][];
        Point bnT = new Point(anT.y, anT.x);
        int by = 0;
        while (by < bnT.y) {
            int bx = 0;
            while (bx < bnT.x) {
                ay = bx;
                ax = bnT.y - by - 1;
                tmpsvt[ay * anT.x + ax] = this.specValType[by * bnT.x + bx];
                ++bx;
            }
            ++by;
        }
        this.specValType = tmpsvt;
        if (this.tileDef != null) {
            Object[] tmptd = new Object[this.nTiles];
            int by2 = 0;
            while (by2 < bnT.y) {
                int bx = 0;
                while (bx < bnT.x) {
                    ay = bx;
                    ax = bnT.y - by2 - 1;
                    tmptd[ay * anT.x + ax] = this.tileDef[by2 * bnT.x + bx];
                    ++bx;
                }
                ++by2;
            }
            this.tileDef = tmptd;
        }
        if (this.tileCompVal != null && this.tileCompVal.size() > 0) {
            Hashtable tmptcv = new Hashtable();
            Enumeration e = this.tileCompVal.keys();
            while (e.hasMoreElements()) {
                String tmpKey = (String)e.nextElement();
                Object tmpVal = this.tileCompVal.get(tmpKey);
                int i1 = tmpKey.indexOf(116);
                int i2 = tmpKey.indexOf(99);
                int btIdx = new Integer(tmpKey.substring(i1 + 1, i2));
                int bx = btIdx % bnT.x;
                int by3 = btIdx / bnT.x;
                ay = bx;
                ax = bnT.y - by3 - 1;
                int atIdx = ax + ay * anT.x;
                tmptcv.put("t" + atIdx + tmpKey.substring(i2), tmpVal);
            }
            this.tileCompVal = tmptcv;
        }
    }

    public void setDefault(Object value) {
        this.def = value;
    }

    public Object getDefault() {
        return this.def;
    }

    public void setCompDef(int c2, Object value) {
        if (this.specType == 1) {
            String errMsg = "Option whose value is '" + value + "' cannot be " + "specified for components as it is a 'tile only' specific " + "option";
            throw new Error(errMsg);
        }
        if (this.compDef == null) {
            this.compDef = new Object[this.nComp];
        }
        int i = 0;
        while (i < this.nTiles) {
            if (this.specValType[i][c2] < 1) {
                this.specValType[i][c2] = 1;
            }
            ++i;
        }
        this.compDef[c2] = value;
    }

    public Object getCompDef(int c2) {
        if (this.specType == 1) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.compDef == null || this.compDef[c2] == null) {
            return this.getDefault();
        }
        return this.compDef[c2];
    }

    public void setTileDef(int t, Object value) {
        if (this.specType == 0) {
            String errMsg = "Option whose value is '" + value + "' cannot be " + "specified for tiles as it is a 'component only' specific " + "option";
            throw new Error(errMsg);
        }
        if (this.tileDef == null) {
            this.tileDef = new Object[this.nTiles];
        }
        int i = 0;
        while (i < this.nComp) {
            if (this.specValType[t][i] < 2) {
                this.specValType[t][i] = 2;
            }
            ++i;
        }
        this.tileDef[t] = value;
    }

    public Object getTileDef(int t) {
        if (this.specType == 0) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.tileDef == null || this.tileDef[t] == null) {
            return this.getDefault();
        }
        return this.tileDef[t];
    }

    public void setTileCompVal(int t, int c2, Object value) {
        if (this.specType != 2) {
            String errMsg = "Option whose value is '" + value + "' cannot be " + "specified for ";
            switch (this.specType) {
                case 1: {
                    errMsg = errMsg + "components as it is a 'tile only' specific option";
                    break;
                }
                case 0: {
                    errMsg = errMsg + "tiles as it is a 'component only' specific option";
                }
            }
            throw new Error(errMsg);
        }
        if (this.tileCompVal == null) {
            this.tileCompVal = new Hashtable();
        }
        this.specValType[t][c2] = 3;
        this.tileCompVal.put("t" + t + "c" + c2, value);
    }

    public Object getTileCompVal(int t, int c2) {
        if (this.specType != 2) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        return this.getSpec(t, c2);
    }

    protected Object getSpec(int t, int c2) {
        switch (this.specValType[t][c2]) {
            case 0: {
                return this.getDefault();
            }
            case 1: {
                return this.getCompDef(c2);
            }
            case 2: {
                return this.getTileDef(t);
            }
            case 3: {
                return this.tileCompVal.get("t" + t + "c" + c2);
            }
        }
        throw new IllegalArgumentException("Not recognized spec type");
    }

    public byte getSpecValType(int t, int c2) {
        return this.specValType[t][c2];
    }

    public boolean isCompSpecified(int c2) {
        return this.compDef != null && this.compDef[c2] != null;
    }

    public boolean isTileSpecified(int t) {
        return this.tileDef != null && this.tileDef[t] != null;
    }

    public boolean isTileCompSpecified(int t, int c2) {
        return this.tileCompVal != null && this.tileCompVal.get("t" + t + "c" + c2) != null;
    }

    public static final boolean[] parseIdx(String word, int maxIdx) {
        int j;
        int nChar = word.length();
        char c2 = word.charAt(0);
        int idx = -1;
        int lastIdx = -1;
        boolean isDash = false;
        boolean[] idxSet = new boolean[maxIdx];
        int i = 1;
        while (i < nChar) {
            c2 = word.charAt(i);
            if (Character.isDigit(c2)) {
                if (idx == -1) {
                    idx = 0;
                }
                idx = idx * 10 + (c2 - 48);
            } else {
                if (idx == -1 || c2 != ',' && c2 != '-') {
                    throw new IllegalArgumentException("Bad construction for parameter: " + word);
                }
                if (idx < 0 || idx >= maxIdx) {
                    throw new IllegalArgumentException("Out of range index in parameter `" + word + "' : " + idx);
                }
                if (c2 == ',') {
                    if (isDash) {
                        j = lastIdx + 1;
                        while (j < idx) {
                            idxSet[j] = true;
                            ++j;
                        }
                    }
                    isDash = false;
                } else {
                    isDash = true;
                }
                idxSet[idx] = true;
                lastIdx = idx;
                idx = -1;
            }
            ++i;
        }
        if (idx < 0 || idx >= maxIdx) {
            throw new IllegalArgumentException("Out of range index in parameter `" + word + "' : " + idx);
        }
        if (isDash) {
            j = lastIdx + 1;
            while (j < idx) {
                idxSet[j] = true;
                ++j;
            }
        }
        idxSet[idx] = true;
        return idxSet;
    }

    static {
        SPEC_TYPE_COMP = 0;
        SPEC_TYPE_TILE = 1;
        SPEC_TYPE_TILE_COMP = (byte)2;
        SPEC_DEF = 0;
        SPEC_COMP_DEF = 1;
        SPEC_TILE_DEF = (byte)2;
        SPEC_TILE_COMP = (byte)3;
    }
}

