/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.codestream.CBlkCoordInfo;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktHeaderBitReader;
import jj2000.j2k.codestream.reader.TagTreeDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class PktDecoder
implements StdEntropyCoderOptions {
    private BitstreamReaderAgent src;
    private boolean pph = false;
    private ByteArrayInputStream pphbais;
    private DecoderSpecs decSpec;
    private HeaderDecoder hd;
    private final int INIT_LBLOCK = 3;
    private PktHeaderBitReader bin;
    private RandomAccessIO ehs;
    private Point[][] numPrec;
    private int tIdx;
    private PrecInfo[][][] ppinfo;
    private int[][][][][] lblock;
    private TagTreeDecoder[][][][] ttIncl;
    private TagTreeDecoder[][][][] ttMaxBP;
    private int nl = 0;
    private int nc;
    private boolean sopUsed = false;
    private boolean ephUsed = false;
    private int pktIdx;
    private Vector[] cblks;
    private int ncb;
    private int maxCB;
    private boolean ncbQuit;
    private int tQuit;
    private int cQuit;
    private int sQuit;
    private int rQuit;
    private int xQuit;
    private int yQuit;
    private boolean isTruncMode;

    public PktDecoder(DecoderSpecs decSpec, HeaderDecoder hd, RandomAccessIO ehs, BitstreamReaderAgent src, boolean isTruncMode, int maxCB) {
        this.decSpec = decSpec;
        this.hd = hd;
        this.ehs = ehs;
        this.isTruncMode = isTruncMode;
        this.bin = new PktHeaderBitReader(ehs);
        this.src = src;
        this.ncb = 0;
        this.ncbQuit = false;
        this.maxCB = maxCB;
    }

    public CBlkInfo[][][][][] restart(int nc, int[] mdl, int nl, CBlkInfo[][][][][] cbI, boolean pph, ByteArrayInputStream pphbais) {
        this.nc = nc;
        this.nl = nl;
        this.tIdx = this.src.getTileIdx();
        this.pph = pph;
        this.pphbais = pphbais;
        this.sopUsed = (Boolean)this.decSpec.sops.getTileDef(this.tIdx);
        this.pktIdx = 0;
        this.ephUsed = (Boolean)this.decSpec.ephs.getTileDef(this.tIdx);
        cbI = new CBlkInfo[nc][][][][];
        this.lblock = new int[nc][][][][];
        this.ttIncl = new TagTreeDecoder[nc][][][];
        this.ttMaxBP = new TagTreeDecoder[nc][][][];
        this.numPrec = new Point[nc][];
        this.ppinfo = new PrecInfo[nc][][];
        Point nBlk = null;
        int cb0x = this.src.getCbULX();
        int cb0y = this.src.getCbULY();
        int c2 = 0;
        while (c2 < nc) {
            cbI[c2] = new CBlkInfo[mdl[c2] + 1][][][];
            this.lblock[c2] = new int[mdl[c2] + 1][][][];
            this.ttIncl[c2] = new TagTreeDecoder[mdl[c2] + 1][][];
            this.ttMaxBP[c2] = new TagTreeDecoder[mdl[c2] + 1][][];
            this.numPrec[c2] = new Point[mdl[c2] + 1];
            this.ppinfo[c2] = new PrecInfo[mdl[c2] + 1][];
            int tcx0 = this.src.getResULX(c2, mdl[c2]);
            int tcy0 = this.src.getResULY(c2, mdl[c2]);
            int tcx1 = tcx0 + this.src.getTileCompWidth(this.tIdx, c2, mdl[c2]);
            int tcy1 = tcy0 + this.src.getTileCompHeight(this.tIdx, c2, mdl[c2]);
            int r = 0;
            while (r <= mdl[c2]) {
                int trx0 = (int)Math.ceil((double)tcx0 / (double)(1 << mdl[c2] - r));
                int try0 = (int)Math.ceil((double)tcy0 / (double)(1 << mdl[c2] - r));
                int trx1 = (int)Math.ceil((double)tcx1 / (double)(1 << mdl[c2] - r));
                int try1 = (int)Math.ceil((double)tcy1 / (double)(1 << mdl[c2] - r));
                double twoppx = this.getPPX(this.tIdx, c2, r);
                double twoppy = this.getPPY(this.tIdx, c2, r);
                this.numPrec[c2][r] = new Point();
                this.numPrec[c2][r].x = trx1 > trx0 ? (int)Math.ceil((double)(trx1 - cb0x) / twoppx) - (int)Math.floor((double)(trx0 - cb0x) / twoppx) : 0;
                this.numPrec[c2][r].y = try1 > try0 ? (int)Math.ceil((double)(try1 - cb0y) / twoppy) - (int)Math.floor((double)(try0 - cb0y) / twoppy) : 0;
                int mins = r == 0 ? 0 : 1;
                int maxs = r == 0 ? 1 : 4;
                int maxPrec = this.numPrec[c2][r].x * this.numPrec[c2][r].y;
                this.ttIncl[c2][r] = new TagTreeDecoder[maxPrec][maxs + 1];
                this.ttMaxBP[c2][r] = new TagTreeDecoder[maxPrec][maxs + 1];
                cbI[c2][r] = new CBlkInfo[maxs + 1][][];
                this.lblock[c2][r] = new int[maxs + 1][][];
                this.ppinfo[c2][r] = new PrecInfo[maxPrec];
                this.fillPrecInfo(c2, r, mdl[c2]);
                SubbandSyn root = this.src.getSynSubbandTree(this.tIdx, c2);
                int s = mins;
                while (s < maxs) {
                    SubbandSyn sb = (SubbandSyn)root.getSubbandByIdx(r, s);
                    nBlk = sb.numCb;
                    cbI[c2][r][s] = new CBlkInfo[nBlk.y][nBlk.x];
                    this.lblock[c2][r][s] = new int[nBlk.y][nBlk.x];
                    int i = nBlk.y - 1;
                    while (i >= 0) {
                        ArrayUtil.intArraySet(this.lblock[c2][r][s][i], 3);
                        --i;
                    }
                    ++s;
                }
                ++r;
            }
            ++c2;
        }
        return cbI;
    }

    private void fillPrecInfo(int c2, int r, int mdl) {
        if (this.ppinfo[c2][r].length == 0) {
            return;
        }
        Point tileI = this.src.getTile(null);
        Point nTiles = this.src.getNumTiles(null);
        int xt0siz = this.src.getTilePartULX();
        int yt0siz = this.src.getTilePartULY();
        int xtsiz = this.src.getNomTileWidth();
        int ytsiz = this.src.getNomTileHeight();
        int x0siz = this.hd.getImgULX();
        int y0siz = this.hd.getImgULY();
        int xsiz = this.hd.getImgWidth();
        int ysiz = this.hd.getImgHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int xrsiz = this.hd.getCompSubsX(c2);
        int yrsiz = this.hd.getCompSubsY(c2);
        int tcx0 = this.src.getResULX(c2, mdl);
        int tcy0 = this.src.getResULY(c2, mdl);
        int tcx1 = tcx0 + this.src.getTileCompWidth(this.tIdx, c2, mdl);
        int tcy1 = tcy0 + this.src.getTileCompHeight(this.tIdx, c2, mdl);
        int ndl = mdl - r;
        int trx0 = (int)Math.ceil((double)tcx0 / (double)(1 << ndl));
        int try0 = (int)Math.ceil((double)tcy0 / (double)(1 << ndl));
        int trx1 = (int)Math.ceil((double)tcx1 / (double)(1 << ndl));
        int try1 = (int)Math.ceil((double)tcy1 / (double)(1 << ndl));
        int cb0x = this.src.getCbULX();
        int cb0y = this.src.getCbULY();
        double twoppx = this.getPPX(this.tIdx, c2, r);
        double twoppy = this.getPPY(this.tIdx, c2, r);
        int twoppx2 = (int)(twoppx / 2.0);
        int twoppy2 = (int)(twoppy / 2.0);
        int maxPrec = this.ppinfo[c2][r].length;
        int nPrec = 0;
        int istart = (int)Math.floor((double)(try0 - cb0y) / twoppy);
        int iend = (int)Math.floor((double)(try1 - 1 - cb0y) / twoppy);
        int jstart = (int)Math.floor((double)(trx0 - cb0x) / twoppx);
        int jend = (int)Math.floor((double)(trx1 - 1 - cb0x) / twoppx);
        SubbandSyn root = this.src.getSynSubbandTree(this.tIdx, c2);
        SubbandSyn sb = null;
        int prg_w = (int)twoppx << ndl;
        int prg_h = (int)twoppy << ndl;
        int i = istart;
        while (i <= iend) {
            int j = jstart;
            while (j <= jend) {
                int tmp2;
                int tmp1;
                CBlkCoordInfo cb;
                int l;
                int k;
                int lend;
                int lstart;
                int l0;
                int kend;
                int kstart;
                int k0;
                int ch;
                int cw;
                int s1y;
                int s0y;
                int s1x;
                int s0x;
                int p1y;
                int p0y;
                int p1x;
                int p0x;
                int acb0y;
                int acb0x;
                int prg_ulx = j == jstart && (trx0 - cb0x) % (xrsiz * (int)twoppx) != 0 ? tx0 : cb0x + j * xrsiz * ((int)twoppx << ndl);
                int prg_uly = i == istart && (try0 - cb0y) % (yrsiz * (int)twoppy) != 0 ? ty0 : cb0y + i * yrsiz * ((int)twoppy << ndl);
                this.ppinfo[c2][r][nPrec] = new PrecInfo(r, (int)((double)cb0x + (double)j * twoppx), (int)((double)cb0y + (double)i * twoppy), (int)twoppx, (int)twoppy, prg_ulx, prg_uly, prg_w, prg_h);
                if (r == 0) {
                    acb0x = cb0x;
                    acb0y = cb0y;
                    p0x = acb0x + j * (int)twoppx;
                    p1x = p0x + (int)twoppx;
                    p0y = acb0y + i * (int)twoppy;
                    p1y = p0y + (int)twoppy;
                    sb = (SubbandSyn)root.getSubbandByIdx(0, 0);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[c2][r][nPrec].nblk[0] = 0;
                        this.ttIncl[c2][r][nPrec][0] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[c2][r][nPrec][0] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[c2][r][nPrec][0] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[c2][r][nPrec][0] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[c2][r][nPrec].cblk[0] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[c2][r][nPrec].nblk[0] = (kend - kstart + 1) * (lend - lstart + 1);
                        k = kstart;
                        while (k <= kend) {
                            l = lstart;
                            while (l <= lend) {
                                cb = new CBlkCoordInfo(k - k0, l - l0);
                                cb.ulx = l == l0 ? sb.ulx : sb.ulx + l * cw - (sb.ulcx - acb0x);
                                cb.uly = k == k0 ? sb.uly : sb.uly + k * ch - (sb.ulcy - acb0y);
                                tmp1 = acb0x + l * cw;
                                tmp1 = tmp1 > sb.ulcx ? tmp1 : sb.ulcx;
                                tmp2 = acb0x + (l + 1) * cw;
                                tmp2 = tmp2 > sb.ulcx + sb.w ? sb.ulcx + sb.w : tmp2;
                                cb.w = tmp2 - tmp1;
                                tmp1 = acb0y + k * ch;
                                tmp1 = tmp1 > sb.ulcy ? tmp1 : sb.ulcy;
                                tmp2 = acb0y + (k + 1) * ch;
                                tmp2 = tmp2 > sb.ulcy + sb.h ? sb.ulcy + sb.h : tmp2;
                                cb.h = tmp2 - tmp1;
                                this.ppinfo[c2][r][nPrec].cblk[0][k - kstart][l - lstart] = cb;
                                ++l;
                            }
                            ++k;
                        }
                    }
                } else {
                    acb0x = 0;
                    acb0y = cb0y;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandSyn)root.getSubbandByIdx(r, 1);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[c2][r][nPrec].nblk[1] = 0;
                        this.ttIncl[c2][r][nPrec][1] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[c2][r][nPrec][1] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[c2][r][nPrec][1] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[c2][r][nPrec][1] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[c2][r][nPrec].cblk[1] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[c2][r][nPrec].nblk[1] = (kend - kstart + 1) * (lend - lstart + 1);
                        k = kstart;
                        while (k <= kend) {
                            l = lstart;
                            while (l <= lend) {
                                cb = new CBlkCoordInfo(k - k0, l - l0);
                                cb.ulx = l == l0 ? sb.ulx : sb.ulx + l * cw - (sb.ulcx - acb0x);
                                cb.uly = k == k0 ? sb.uly : sb.uly + k * ch - (sb.ulcy - acb0y);
                                tmp1 = acb0x + l * cw;
                                tmp1 = tmp1 > sb.ulcx ? tmp1 : sb.ulcx;
                                tmp2 = acb0x + (l + 1) * cw;
                                tmp2 = tmp2 > sb.ulcx + sb.w ? sb.ulcx + sb.w : tmp2;
                                cb.w = tmp2 - tmp1;
                                tmp1 = acb0y + k * ch;
                                tmp1 = tmp1 > sb.ulcy ? tmp1 : sb.ulcy;
                                tmp2 = acb0y + (k + 1) * ch;
                                tmp2 = tmp2 > sb.ulcy + sb.h ? sb.ulcy + sb.h : tmp2;
                                cb.h = tmp2 - tmp1;
                                this.ppinfo[c2][r][nPrec].cblk[1][k - kstart][l - lstart] = cb;
                                ++l;
                            }
                            ++k;
                        }
                    }
                    acb0x = cb0x;
                    acb0y = 0;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandSyn)root.getSubbandByIdx(r, 2);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[c2][r][nPrec].nblk[2] = 0;
                        this.ttIncl[c2][r][nPrec][2] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[c2][r][nPrec][2] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[c2][r][nPrec][2] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[c2][r][nPrec][2] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[c2][r][nPrec].cblk[2] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[c2][r][nPrec].nblk[2] = (kend - kstart + 1) * (lend - lstart + 1);
                        k = kstart;
                        while (k <= kend) {
                            l = lstart;
                            while (l <= lend) {
                                cb = new CBlkCoordInfo(k - k0, l - l0);
                                cb.ulx = l == l0 ? sb.ulx : sb.ulx + l * cw - (sb.ulcx - acb0x);
                                cb.uly = k == k0 ? sb.uly : sb.uly + k * ch - (sb.ulcy - acb0y);
                                tmp1 = acb0x + l * cw;
                                tmp1 = tmp1 > sb.ulcx ? tmp1 : sb.ulcx;
                                tmp2 = acb0x + (l + 1) * cw;
                                tmp2 = tmp2 > sb.ulcx + sb.w ? sb.ulcx + sb.w : tmp2;
                                cb.w = tmp2 - tmp1;
                                tmp1 = acb0y + k * ch;
                                tmp1 = tmp1 > sb.ulcy ? tmp1 : sb.ulcy;
                                tmp2 = acb0y + (k + 1) * ch;
                                tmp2 = tmp2 > sb.ulcy + sb.h ? sb.ulcy + sb.h : tmp2;
                                cb.h = tmp2 - tmp1;
                                this.ppinfo[c2][r][nPrec].cblk[2][k - kstart][l - lstart] = cb;
                                ++l;
                            }
                            ++k;
                        }
                    }
                    acb0x = 0;
                    acb0y = 0;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandSyn)root.getSubbandByIdx(r, 3);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[c2][r][nPrec].nblk[3] = 0;
                        this.ttIncl[c2][r][nPrec][3] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[c2][r][nPrec][3] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[c2][r][nPrec][3] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[c2][r][nPrec][3] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[c2][r][nPrec].cblk[3] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[c2][r][nPrec].nblk[3] = (kend - kstart + 1) * (lend - lstart + 1);
                        k = kstart;
                        while (k <= kend) {
                            l = lstart;
                            while (l <= lend) {
                                cb = new CBlkCoordInfo(k - k0, l - l0);
                                cb.ulx = l == l0 ? sb.ulx : sb.ulx + l * cw - (sb.ulcx - acb0x);
                                cb.uly = k == k0 ? sb.uly : sb.uly + k * ch - (sb.ulcy - acb0y);
                                tmp1 = acb0x + l * cw;
                                tmp1 = tmp1 > sb.ulcx ? tmp1 : sb.ulcx;
                                tmp2 = acb0x + (l + 1) * cw;
                                tmp2 = tmp2 > sb.ulcx + sb.w ? sb.ulcx + sb.w : tmp2;
                                cb.w = tmp2 - tmp1;
                                tmp1 = acb0y + k * ch;
                                tmp1 = tmp1 > sb.ulcy ? tmp1 : sb.ulcy;
                                tmp2 = acb0y + (k + 1) * ch;
                                tmp2 = tmp2 > sb.ulcy + sb.h ? sb.ulcy + sb.h : tmp2;
                                cb.h = tmp2 - tmp1;
                                this.ppinfo[c2][r][nPrec].cblk[3][k - kstart][l - lstart] = cb;
                                ++l;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
                ++nPrec;
            }
            ++i;
        }
    }

    public int getNumPrecinct(int c2, int r) {
        return this.numPrec[c2][r].x * this.numPrec[c2][r].y;
    }

    public boolean readPktHead(int l, int r, int c2, int p, CBlkInfo[][][] cbI, int[] nb) throws IOException {
        int tmp2;
        int sumtotnewtp = 0;
        int startPktHead = this.ehs.getPos();
        if (startPktHead >= this.ehs.length()) {
            return true;
        }
        int tIdx = this.src.getTileIdx();
        SubbandSyn root = this.src.getSynSubbandTree(tIdx, c2);
        PktHeaderBitReader bin = this.pph ? new PktHeaderBitReader(this.pphbais) : this.bin;
        int mins = r == 0 ? 0 : 1;
        int maxs = r == 0 ? 1 : 4;
        boolean precFound = false;
        int s = mins;
        while (s < maxs) {
            if (p < this.ppinfo[c2][r].length) {
                precFound = true;
            }
            ++s;
        }
        if (!precFound) {
            return false;
        }
        PrecInfo prec = this.ppinfo[c2][r][p];
        bin.sync();
        if (bin.readBit() == 0) {
            this.cblks = new Vector[maxs + 1];
            int s2 = mins;
            while (s2 < maxs) {
                this.cblks[s2] = new Vector();
                ++s2;
            }
            ++this.pktIdx;
            if (this.isTruncMode && this.maxCB == -1) {
                int tmp2 = this.ehs.getPos() - startPktHead;
                if (tmp2 > nb[tIdx]) {
                    nb[tIdx] = 0;
                    return true;
                }
                int n = tIdx;
                nb[n] = nb[n] - tmp2;
            }
            if (this.ephUsed) {
                this.readEPHMarker(bin);
            }
            return false;
        }
        if (this.cblks == null || this.cblks.length < maxs + 1) {
            this.cblks = new Vector[maxs + 1];
        }
        int s3 = mins;
        while (s3 < maxs) {
            if (this.cblks[s3] == null) {
                this.cblks[s3] = new Vector();
            } else {
                this.cblks[s3].removeAllElements();
            }
            SubbandSyn sb = (SubbandSyn)root.getSubbandByIdx(r, s3);
            if (prec.nblk[s3] != 0) {
                TagTreeDecoder tdIncl = this.ttIncl[c2][r][p][s3];
                TagTreeDecoder tdBD = this.ttMaxBP[c2][r][p][s3];
                int mend = prec.cblk[s3] == null ? 0 : prec.cblk[s3].length;
                int m = 0;
                while (m < mend) {
                    int nend = prec.cblk[s3][m] == null ? 0 : prec.cblk[s3][m].length;
                    int n = 0;
                    while (n < nend) {
                        block52: {
                            Point cbc = prec.cblk[s3][m][n].idx;
                            int b2 = cbc.x + cbc.y * sb.numCb.x;
                            CBlkInfo ccb = cbI[s3][cbc.y][cbc.x];
                            try {
                                int cbLen;
                                int passtype;
                                int tpidx;
                                int nSeg;
                                int totnewtp;
                                if (ccb == null || ccb.ctp == 0) {
                                    if (ccb == null) {
                                        CBlkInfo cBlkInfo = new CBlkInfo(prec.cblk[s3][m][n].ulx, prec.cblk[s3][m][n].uly, prec.cblk[s3][m][n].w, prec.cblk[s3][m][n].h, this.nl);
                                        cbI[s3][cbc.y][cbc.x] = cBlkInfo;
                                        ccb = cBlkInfo;
                                    }
                                    ccb.pktIdx[l] = this.pktIdx;
                                    tmp2 = tdIncl.update(m, n, l + 1, bin);
                                    if (tmp2 > l) break block52;
                                    tmp2 = 1;
                                    int tmp2 = 1;
                                    while (tmp2 >= tmp2) {
                                        tmp2 = tdBD.update(m, n, tmp2, bin);
                                        ++tmp2;
                                    }
                                    ccb.msbSkipped = tmp2 - 2;
                                    totnewtp = 1;
                                    ccb.addNTP(l, 0);
                                    ++this.ncb;
                                    if (this.maxCB != -1 && !this.ncbQuit && this.ncb == this.maxCB) {
                                        this.ncbQuit = true;
                                        this.tQuit = tIdx;
                                        this.cQuit = c2;
                                        this.sQuit = s3;
                                        this.rQuit = r;
                                        this.xQuit = cbc.x;
                                        this.yQuit = cbc.y;
                                    }
                                } else {
                                    ccb.pktIdx[l] = this.pktIdx;
                                    if (bin.readBit() != 1) break block52;
                                    totnewtp = 1;
                                }
                                if (bin.readBit() == 1) {
                                    ++totnewtp;
                                    if (bin.readBit() == 1) {
                                        ++totnewtp;
                                        tmp2 = bin.readBits(2);
                                        totnewtp += tmp2;
                                        if (tmp2 == 3) {
                                            tmp2 = bin.readBits(5);
                                            totnewtp += tmp2;
                                            if (tmp2 == 31) {
                                                totnewtp += bin.readBits(7);
                                            }
                                        }
                                    }
                                }
                                ccb.addNTP(l, totnewtp);
                                sumtotnewtp += totnewtp;
                                this.cblks[s3].addElement(prec.cblk[s3][m][n]);
                                int options = (Integer)this.decSpec.ecopts.getTileCompVal(tIdx, c2);
                                if ((options & 4) != 0) {
                                    nSeg = totnewtp;
                                } else if ((options & 1) != 0) {
                                    if (ccb.ctp <= 10) {
                                        nSeg = 1;
                                    } else {
                                        nSeg = 1;
                                        tpidx = ccb.ctp - totnewtp;
                                        while (tpidx < ccb.ctp - 1) {
                                            if (tpidx >= 9 && ((passtype = (tpidx + 2) % 3) == 1 || passtype == 2)) {
                                                ++nSeg;
                                            }
                                            ++tpidx;
                                        }
                                    }
                                } else {
                                    nSeg = 1;
                                }
                                while (bin.readBit() != 0) {
                                    int[] nArray = this.lblock[c2][r][s3][cbc.y];
                                    int n2 = cbc.x;
                                    nArray[n2] = nArray[n2] + 1;
                                }
                                if (nSeg == 1) {
                                    cbLen = bin.readBits(this.lblock[c2][r][s3][cbc.y][cbc.x] + MathUtil.log2(totnewtp));
                                } else {
                                    int lblockCur;
                                    int j;
                                    ccb.segLen[l] = new int[nSeg];
                                    cbLen = 0;
                                    if ((options & 4) != 0) {
                                        tpidx = ccb.ctp - totnewtp;
                                        j = 0;
                                        while (tpidx < ccb.ctp) {
                                            lblockCur = this.lblock[c2][r][s3][cbc.y][cbc.x];
                                            ccb.segLen[l][j] = tmp2 = bin.readBits(lblockCur);
                                            cbLen += tmp2;
                                            ++tpidx;
                                            ++j;
                                        }
                                    } else {
                                        int ltp = ccb.ctp - totnewtp - 1;
                                        tpidx = ccb.ctp - totnewtp;
                                        j = 0;
                                        while (tpidx < ccb.ctp - 1) {
                                            if (tpidx >= 9 && (passtype = (tpidx + 2) % 3) != 0) {
                                                lblockCur = this.lblock[c2][r][s3][cbc.y][cbc.x];
                                                ccb.segLen[l][j] = tmp2 = bin.readBits(lblockCur + MathUtil.log2(tpidx - ltp));
                                                cbLen += tmp2;
                                                ltp = tpidx;
                                                ++j;
                                            }
                                            ++tpidx;
                                        }
                                        lblockCur = this.lblock[c2][r][s3][cbc.y][cbc.x];
                                        tmp2 = bin.readBits(lblockCur + MathUtil.log2(tpidx - ltp));
                                        cbLen += tmp2;
                                        ccb.segLen[l][j] = tmp2;
                                    }
                                }
                                ccb.len[l] = cbLen;
                                if (this.isTruncMode && this.maxCB == -1 && (tmp2 = this.ehs.getPos() - startPktHead) > nb[tIdx]) {
                                    nb[tIdx] = 0;
                                    if (l == 0) {
                                        cbI[s3][cbc.y][cbc.x] = null;
                                    } else {
                                        ccb.len[l] = 0;
                                        ccb.off[l] = 0;
                                        ccb.ctp -= ccb.ntp[l];
                                        ccb.ntp[l] = 0;
                                        ccb.pktIdx[l] = -1;
                                    }
                                    return true;
                                }
                            }
                            catch (EOFException e) {
                                if (l == 0) {
                                    cbI[s3][cbc.y][cbc.x] = null;
                                } else {
                                    ccb.len[l] = 0;
                                    ccb.off[l] = 0;
                                    ccb.ctp -= ccb.ntp[l];
                                    ccb.ntp[l] = 0;
                                    ccb.pktIdx[l] = -1;
                                }
                                return true;
                            }
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            ++s3;
        }
        if (this.ephUsed) {
            this.readEPHMarker(bin);
        }
        ++this.pktIdx;
        if (this.isTruncMode && this.maxCB == -1) {
            tmp2 = this.ehs.getPos() - startPktHead;
            if (tmp2 > nb[tIdx]) {
                nb[tIdx] = 0;
                return true;
            }
            int n = tIdx;
            nb[n] = nb[n] - tmp2;
        }
        return false;
    }

    public boolean readPktBody(int l, int r, int c2, int p, CBlkInfo[][][] cbI, int[] nb) throws IOException {
        int curOff = this.ehs.getPos();
        boolean stopRead = false;
        int tIdx = this.src.getTileIdx();
        boolean precFound = false;
        int mins = r == 0 ? 0 : 1;
        int maxs = r == 0 ? 1 : 4;
        int s = mins;
        while (s < maxs) {
            if (p < this.ppinfo[c2][r].length) {
                precFound = true;
            }
            ++s;
        }
        if (!precFound) {
            return false;
        }
        int s2 = mins;
        while (s2 < maxs) {
            int numCB = 0;
            while (numCB < this.cblks[s2].size()) {
                Point cbc = ((CBlkCoordInfo)this.cblks[s2].elementAt((int)numCB)).idx;
                CBlkInfo ccb = cbI[s2][cbc.y][cbc.x];
                ccb.off[l] = curOff;
                curOff += ccb.len[l];
                try {
                    this.ehs.seek(curOff);
                }
                catch (EOFException e) {
                    if (l == 0) {
                        cbI[s2][cbc.y][cbc.x] = null;
                    } else {
                        ccb.len[l] = 0;
                        ccb.off[l] = 0;
                        ccb.ctp -= ccb.ntp[l];
                        ccb.ntp[l] = 0;
                        ccb.pktIdx[l] = -1;
                    }
                    throw new EOFException();
                }
                if (this.isTruncMode) {
                    if (stopRead || ccb.len[l] > nb[tIdx]) {
                        if (l == 0) {
                            cbI[s2][cbc.y][cbc.x] = null;
                        } else {
                            ccb.len[l] = 0;
                            ccb.off[l] = 0;
                            ccb.ctp -= ccb.ntp[l];
                            ccb.ntp[l] = 0;
                            ccb.pktIdx[l] = -1;
                        }
                        stopRead = true;
                    }
                    if (!stopRead) {
                        int n = tIdx;
                        nb[n] = nb[n] - ccb.len[l];
                    }
                }
                if (this.ncbQuit && r == this.rQuit && s2 == this.sQuit && cbc.x == this.xQuit && cbc.y == this.yQuit && tIdx == this.tQuit && c2 == this.cQuit) {
                    cbI[s2][cbc.y][cbc.x] = null;
                    stopRead = true;
                }
                ++numCB;
            }
            ++s2;
        }
        this.ehs.seek(curOff);
        return stopRead;
    }

    public final int getPPX(int t, int c2, int r) {
        return this.decSpec.pss.getPPX(t, c2, r);
    }

    public final int getPPY(int t, int c2, int rl) {
        return this.decSpec.pss.getPPY(t, c2, rl);
    }

    public boolean readSOPMarker(int[] nBytes, int p, int c2, int r) throws IOException {
        byte[] sopArray = new byte[6];
        int tIdx = this.src.getTileIdx();
        int mins = r == 0 ? 0 : 1;
        int maxs = r == 0 ? 1 : 4;
        boolean precFound = false;
        int s = mins;
        while (s < maxs) {
            if (p < this.ppinfo[c2][r].length) {
                precFound = true;
            }
            ++s;
        }
        if (!precFound) {
            return false;
        }
        if (!this.sopUsed) {
            return false;
        }
        int pos = this.ehs.getPos();
        if ((short)(this.ehs.read() << 8 | this.ehs.read()) != -111) {
            this.ehs.seek(pos);
            return false;
        }
        this.ehs.seek(pos);
        if (nBytes[tIdx] < 6) {
            return true;
        }
        int n = tIdx;
        nBytes[n] = nBytes[n] - 6;
        this.ehs.readFully(sopArray, 0, 6);
        int val = sopArray[0];
        val <<= 8;
        if ((val |= sopArray[1]) != -111) {
            throw new Error("Corrupted Bitstream: Could not parse SOP marker !");
        }
        val = sopArray[2] & 0xFF;
        val <<= 8;
        if ((val |= sopArray[3] & 0xFF) != 4) {
            throw new Error("Corrupted Bitstream: Corrupted SOP marker !");
        }
        val = sopArray[4] & 0xFF;
        val <<= 8;
        if (!this.pph && (val |= sopArray[5] & 0xFF) != this.pktIdx) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        if (this.pph && val != this.pktIdx - 1) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        return false;
    }

    public void readEPHMarker(PktHeaderBitReader bin) throws IOException {
        byte[] ephArray = new byte[2];
        if (bin.usebais) {
            bin.bais.read(ephArray, 0, 2);
        } else {
            bin.in.readFully(ephArray, 0, 2);
        }
        int val = ephArray[0];
        val <<= 8;
        if ((val |= ephArray[1]) != -110) {
            throw new Error("Corrupted Bitstream: Could not parse EPH marker ! ");
        }
    }

    public PrecInfo getPrecInfo(int c2, int r, int p) {
        return this.ppinfo[c2][r][p];
    }
}

