/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

public class ByteOutputBuffer {
    byte[] buf;
    int count;
    public static final int BUF_INC = 512;
    public static final int BUF_DEF_LEN = 256;

    public ByteOutputBuffer() {
        this.buf = new byte[256];
    }

    public ByteOutputBuffer(int size) {
        this.buf = new byte[size];
    }

    public final void write(int b2) {
        if (this.count == this.buf.length) {
            byte[] tmpbuf = this.buf;
            this.buf = new byte[this.buf.length + 512];
            System.arraycopy(tmpbuf, 0, this.buf, 0, this.count);
        }
        this.buf[this.count++] = (byte)b2;
    }

    public void toByteArray(int off, int len, byte[] outbuf, int outoff) {
        System.arraycopy(this.buf, off, outbuf, outoff, len);
    }

    public int size() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public int getByte(int pos) {
        if (pos >= this.count) {
            throw new IllegalArgumentException();
        }
        return this.buf[pos] & 0xFF;
    }

    static {
        BUF_INC = 512;
        BUF_DEF_LEN = 256;
    }
}

