/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.awt.Point;
import java.io.IOException;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.codestream.writer.CodestreamWriter;
import jj2000.j2k.codestream.writer.PktEncoder;
import jj2000.j2k.entropy.Progression;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import jj2000.j2k.entropy.encoder.EBCOTLayer;
import jj2000.j2k.entropy.encoder.LayersInfo;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class EBCOTRateAllocator
extends PostCompRateAllocator {
    private static final boolean DO_TIMING = false;
    private long initTime;
    private long buildTime;
    private long writeTime;
    private CBlkRateDistStats[][][][][] cblks;
    private int[][][][][][] truncIdxs;
    private Point[][][] numPrec;
    private EBCOTLayer[] layers;
    private static final double LOG2;
    private static final int RD_SUMMARY_OFF = 24;
    private static final int RD_SUMMARY_SIZE = 64;
    private static final float FLOAT_REL_PRECISION = 1.0E-4f;
    private static final float FLOAT_ABS_PRECISION = 1.0E-10f;
    private static final int MIN_AVG_PACKET_SZ = 32;
    private int[] RDSlopesRates;
    private PktEncoder pktEnc;
    private LayersInfo lyrSpec;
    private float maxSlope;
    private float minSlope;

    public EBCOTRateAllocator(CodedCBlkDataSrcEnc src, LayersInfo lyrs, CodestreamWriter writer, J2KImageWriteParamJava wp) {
        super(src, lyrs.getTotNumLayers(), writer, wp);
        Point ncblks = null;
        this.lyrSpec = lyrs;
        this.RDSlopesRates = new int[64];
        int nt = src.getNumTiles();
        int nc = this.getNumComps();
        this.cblks = new CBlkRateDistStats[nt][nc][][][];
        this.truncIdxs = new int[nt][this.numLayers][nc][][][];
        Point tileI = null;
        Point nTiles = null;
        int cb0x = src.getCbULX();
        int cb0y = src.getCbULY();
        src.setTile(0, 0);
        int t = 0;
        while (t < nt) {
            nTiles = src.getNumTiles(nTiles);
            tileI = src.getTile(tileI);
            int x0siz = this.getImgULX();
            int y0siz = this.getImgULY();
            int xsiz = x0siz + this.getImgWidth();
            int ysiz = y0siz + this.getImgHeight();
            int xt0siz = src.getTilePartULX();
            int yt0siz = src.getTilePartULY();
            int xtsiz = src.getNomTileWidth();
            int ytsiz = src.getNomTileHeight();
            int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
            int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
            int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
            int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
            int c2 = 0;
            while (c2 < nc) {
                SubbandAn sb = src.getAnSubbandTree(t, c2);
                int mrl = sb.resLvl + 1;
                if (this.numPrec == null) {
                    this.numPrec = new Point[nt][nc][];
                }
                if (this.numPrec[t][c2] == null) {
                    this.numPrec[t][c2] = new Point[mrl];
                }
                int xrsiz = src.getCompSubsX(c2);
                int yrsiz = src.getCompSubsY(c2);
                int tcx0 = (int)Math.ceil((double)tx0 / (double)xrsiz);
                int tcy0 = (int)Math.ceil((double)ty0 / (double)yrsiz);
                int tcx1 = (int)Math.ceil((double)tx1 / (double)xrsiz);
                int tcy1 = (int)Math.ceil((double)ty1 / (double)yrsiz);
                this.cblks[t][c2] = new CBlkRateDistStats[mrl][][];
                int l = 0;
                while (l < this.numLayers) {
                    this.truncIdxs[t][l][c2] = new int[mrl][][];
                    ++l;
                }
                int r = 0;
                while (r < mrl) {
                    int trx0 = (int)Math.ceil((double)tcx0 / (double)(1 << mrl - 1 - r));
                    int try0 = (int)Math.ceil((double)tcy0 / (double)(1 << mrl - 1 - r));
                    int trx1 = (int)Math.ceil((double)tcx1 / (double)(1 << mrl - 1 - r));
                    int try1 = (int)Math.ceil((double)tcy1 / (double)(1 << mrl - 1 - r));
                    double twoppx = wp.getPrecinctPartition().getPPX(t, c2, r);
                    double twoppy = wp.getPrecinctPartition().getPPY(t, c2, r);
                    this.numPrec[t][c2][r] = new Point();
                    this.numPrec[t][c2][r].x = trx1 > trx0 ? (int)Math.ceil((double)(trx1 - cb0x) / twoppx) - (int)Math.floor((double)(trx0 - cb0x) / twoppx) : 0;
                    this.numPrec[t][c2][r].y = try1 > try0 ? (int)Math.ceil((double)(try1 - cb0y) / twoppy) - (int)Math.floor((double)(try0 - cb0y) / twoppy) : 0;
                    int minsbi = r == 0 ? 0 : 1;
                    int maxsbi = r == 0 ? 1 : 4;
                    this.cblks[t][c2][r] = new CBlkRateDistStats[maxsbi][];
                    l = 0;
                    while (l < this.numLayers) {
                        this.truncIdxs[t][l][c2][r] = new int[maxsbi][];
                        ++l;
                    }
                    int s = minsbi;
                    while (s < maxsbi) {
                        SubbandAn sb2 = (SubbandAn)sb.getSubbandByIdx(r, s);
                        ncblks = sb2.numCb;
                        int cblkPerSubband = ncblks.x * ncblks.y;
                        this.cblks[t][c2][r][s] = new CBlkRateDistStats[cblkPerSubband];
                        l = 0;
                        while (l < this.numLayers) {
                            this.truncIdxs[t][l][c2][r][s] = new int[cblkPerSubband];
                            int i = 0;
                            while (i < cblkPerSubband) {
                                this.truncIdxs[t][l][c2][r][s][i] = -1;
                                ++i;
                            }
                            ++l;
                        }
                        ++s;
                    }
                    ++r;
                }
                ++c2;
            }
            if (t != nt - 1) {
                src.nextTile();
            }
            ++t;
        }
        this.pktEnc = new PktEncoder(src, wp, this.numPrec);
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void runAndWrite() throws IOException {
        this.buildAndWriteLayers();
    }

    public void initialize() throws IOException {
        int newbytes;
        int nextbytes;
        int maxpkt;
        int numLvls;
        int numTiles = this.src.getNumTiles();
        int numComps = this.src.getNumComps();
        long stime = 0L;
        this.getAllCodeBlocks();
        int totenclength = this.RDSlopesRates[0];
        int t = 0;
        while (t < numTiles) {
            int avgPktLen = 2;
            if (((String)this.wp.getSOP().getTileDef(t)).equalsIgnoreCase("true")) {
                avgPktLen += 6;
            }
            if (((String)this.wp.getEPH().getTileDef(t)).equalsIgnoreCase("true")) {
                avgPktLen += 2;
            }
            int c2 = 0;
            while (c2 < numComps) {
                numLvls = this.src.getAnSubbandTree((int)t, (int)c2).resLvl + 1;
                if (!this.src.precinctPartitionUsed(c2, t)) {
                    totenclength += this.numLayers * avgPktLen * numLvls;
                } else {
                    int rl = 0;
                    while (rl < numLvls) {
                        maxpkt = this.numPrec[t][c2][rl].x * this.numPrec[t][c2][rl].y;
                        totenclength += this.numLayers * avgPktLen * maxpkt;
                        ++rl;
                    }
                }
                ++c2;
            }
            ++t;
        }
        int ho = this.headEnc.getLength();
        float np = (float)(this.src.getImgWidth() * this.src.getImgHeight()) / 8.0f;
        int t2 = 0;
        while (t2 < numTiles) {
            this.headEnc.reset();
            this.headEnc.encodeTilePartHeader(0, t2);
            ho += this.headEnc.getLength();
            ++t2;
        }
        this.layers = new EBCOTLayer[this.numLayers];
        int n = this.numLayers - 1;
        while (n >= 0) {
            this.layers[n] = new EBCOTLayer();
            --n;
        }
        int minlsz = 0;
        int t3 = 0;
        while (t3 < numTiles) {
            int c3 = 0;
            while (c3 < numComps) {
                numLvls = this.src.getAnSubbandTree((int)t3, (int)c3).resLvl + 1;
                if (!this.src.precinctPartitionUsed(c3, t3)) {
                    minlsz += 32 * numLvls;
                } else {
                    int rl = 0;
                    while (rl < numLvls) {
                        maxpkt = this.numPrec[t3][c3][rl].x * this.numPrec[t3][c3][rl].y;
                        minlsz += 32 * maxpkt;
                        ++rl;
                    }
                }
                ++c3;
            }
            ++t3;
        }
        n = 0;
        int i = 0;
        int lastbytes = 0;
        while (n < this.numLayers - 1) {
            double basebytes = Math.floor(this.lyrSpec.getTargetBitrate(i) * np);
            if (i < this.lyrSpec.getNOptPoints() - 1) {
                nextbytes = (int)(this.lyrSpec.getTargetBitrate(i + 1) * np);
                if (nextbytes > totenclength) {
                    nextbytes = totenclength;
                }
            } else {
                nextbytes = 1;
            }
            int loopnlyrs = this.lyrSpec.getExtraLayers(i) + 1;
            double ls = Math.exp(Math.log((double)nextbytes / basebytes) / (double)loopnlyrs);
            this.layers[n].optimize = true;
            int l = 0;
            while (l < loopnlyrs) {
                newbytes = (int)basebytes - lastbytes - ho;
                if (newbytes < minlsz) {
                    basebytes *= ls;
                    --this.numLayers;
                } else {
                    this.layers[n].maxBytes = lastbytes = (int)basebytes - ho;
                    basebytes *= ls;
                    ++n;
                }
                ++l;
            }
            ++i;
        }
        n = this.numLayers - 2;
        nextbytes = (int)(this.lyrSpec.getTotBitrate() * np) - ho;
        newbytes = nextbytes - (n >= 0 ? this.layers[n].maxBytes : 0);
        while (newbytes < minlsz) {
            if (this.numLayers == 1) {
                if (newbytes > 0) break;
                throw new IllegalArgumentException("Overall target bitrate too low, given the current bit stream header overhead");
            }
            --this.numLayers;
            newbytes = nextbytes - (--n >= 0 ? this.layers[n].maxBytes : 0);
        }
        this.layers[++n].maxBytes = nextbytes;
        this.layers[n].optimize = true;
        Progression[] prog1 = (Progression[])this.wp.getProgressionType().getDefault();
        int nValidProg = prog1.length;
        int prg = 0;
        while (prg < prog1.length) {
            if (prog1[prg].lye > this.numLayers) {
                prog1[prg].lye = this.numLayers;
            }
            ++prg;
        }
        if (nValidProg == 0) {
            throw new Error("Unable to initialize rate allocator: No default progression type has been defined.");
        }
        int t4 = 0;
        while (t4 < numTiles) {
            if (this.wp.getProgressionType().isTileSpecified(t4)) {
                prog1 = (Progression[])this.wp.getProgressionType().getTileDef(t4);
                nValidProg = prog1.length;
                int prg2 = 0;
                while (prg2 < prog1.length) {
                    if (prog1[prg2].lye > this.numLayers) {
                        prog1[prg2].lye = this.numLayers;
                    }
                    ++prg2;
                }
                if (nValidProg == 0) {
                    throw new Error("Unable to initialize rate allocator: No default progression type has been defined.");
                }
            }
            ++t4;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getAllCodeBlocks() {
        ccb = null;
        ncblks = null;
        stime = 0L;
        this.maxSlope = 0.0f;
        this.minSlope = 3.4028235E38f;
        numComps = this.src.getNumComps();
        numTiles = this.src.getNumTiles();
        cblkToEncode = 0;
        nEncCblk = 0;
        pw = FacilityManager.getProgressWatch();
        this.src.setTile(0, 0);
        t = 0;
        while (t < numTiles) {
            nEncCblk = 0;
            cblkToEncode = 0;
            c = 0;
            while (c < numComps) {
                root = this.src.getAnSubbandTree(t, c);
                r = 0;
                while (r <= root.resLvl) {
                    if (r == 0) {
                        sb = (SubbandAn)root.getSubbandByIdx(0, 0);
                        if (sb != null) {
                            cblkToEncode += sb.numCb.x * sb.numCb.y;
                        }
                    } else {
                        sb = (SubbandAn)root.getSubbandByIdx(r, 1);
                        if (sb != null) {
                            cblkToEncode += sb.numCb.x * sb.numCb.y;
                        }
                        if ((sb = (SubbandAn)root.getSubbandByIdx(r, 2)) != null) {
                            cblkToEncode += sb.numCb.x * sb.numCb.y;
                        }
                        if ((sb = (SubbandAn)root.getSubbandByIdx(r, 3)) != null) {
                            cblkToEncode += sb.numCb.x * sb.numCb.y;
                        }
                    }
                    ++r;
                }
                ++c;
            }
            if (pw != null) {
                pw.initProgressWatch(0, cblkToEncode, "Encoding tile " + t + "...");
            }
            c = 0;
            ** GOTO lbl68
            {
                if (pw != null) {
                    pw.updateProgressWatch(++nEncCblk, null);
                }
                subb = ccb.sb;
                r = subb.resLvl;
                s = subb.sbandIdx;
                ncblks = subb.numCb;
                last_sidx = -1;
                k = ccb.nVldTrunc - 1;
                while (k >= 0) {
                    fslope = ccb.truncSlopes[k];
                    if (fslope > this.maxSlope) {
                        this.maxSlope = fslope;
                    }
                    if (fslope < this.minSlope) {
                        this.minSlope = fslope;
                    }
                    sidx = EBCOTRateAllocator.getLimitedSIndexFromSlope(fslope);
                    while (sidx > last_sidx) {
                        v0 = sidx--;
                        this.RDSlopesRates[v0] = this.RDSlopesRates[v0] + ccb.truncRates[ccb.truncIdxs[k]];
                    }
                    last_sidx = EBCOTRateAllocator.getLimitedSIndexFromSlope(fslope);
                    --k;
                }
                this.cblks[t][c][r][s][ccb.m * ncblks.x + ccb.n] = ccb;
                ccb = null;
                do {
                    if ((ccb = this.src.getNextCodeBlock(c, ccb)) != null) continue block3;
                    ++c;
lbl68:
                    // 2 sources

                } while (c < numComps);
            }
            if (pw != null) {
                pw.terminateProgressWatch();
            }
            if (t < numTiles - 1) {
                this.src.nextTile();
            }
            ++t;
        }
    }

    private void buildAndWriteLayers() throws IOException {
        int nPrec = 0;
        BitOutputBuffer hBuff = null;
        byte[] bBuff = null;
        int nc = this.src.getNumComps();
        int nt = this.src.getNumTiles();
        long stime = 0L;
        float rdThreshold = this.maxSlope;
        int[] tileLengths = new int[nt];
        int actualBytes = 0;
        int l = 0;
        while (l < this.numLayers) {
            int maxBytes = this.layers[l].maxBytes;
            if (this.layers[l].optimize) {
                rdThreshold = this.optimizeBitstreamLayer(l, rdThreshold, maxBytes, actualBytes);
            } else {
                if (l <= 0 || l >= this.numLayers - 1) {
                    throw new IllegalArgumentException("The first and the last layer thresholds must be optimized");
                }
                rdThreshold = this.estimateLayerThreshold(maxBytes, this.layers[l - 1]);
            }
            int t = 0;
            while (t < nt) {
                if (l == 0) {
                    this.headEnc.reset();
                    this.headEnc.encodeTilePartHeader(0, t);
                    int n = t;
                    tileLengths[n] = tileLengths[n] + this.headEnc.getLength();
                }
                int c2 = 0;
                while (c2 < nc) {
                    boolean sopUsed = ((String)this.wp.getSOP().getTileDef(t)).equalsIgnoreCase("true");
                    boolean ephUsed = ((String)this.wp.getEPH().getTileDef(t)).equalsIgnoreCase("true");
                    SubbandAn sb = this.src.getAnSubbandTree(t, c2);
                    int mrl = sb.resLvl + 1;
                    while (sb.subb_LL != null) {
                        sb = sb.subb_LL;
                    }
                    int r = 0;
                    while (r < mrl) {
                        nPrec = this.numPrec[t][c2][r].x * this.numPrec[t][c2][r].y;
                        int p = 0;
                        while (p < nPrec) {
                            this.findTruncIndices(l, c2, r, t, sb, rdThreshold, p);
                            hBuff = this.pktEnc.encodePacket(l + 1, c2, r, t, this.cblks[t][c2][r], this.truncIdxs[t][l][c2][r], hBuff, bBuff, p);
                            if (this.pktEnc.isPacketWritable()) {
                                int tmp = this.bsWriter.writePacketHead(hBuff.getBuffer(), hBuff.getLength(), true, sopUsed, ephUsed);
                                actualBytes += (tmp += this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), true, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen()));
                                int n = t;
                                tileLengths[n] = tileLengths[n] + tmp;
                            }
                            ++p;
                        }
                        sb = sb.parent;
                        ++r;
                    }
                    ++c2;
                }
                ++t;
            }
            this.layers[l].rdThreshold = rdThreshold;
            this.layers[l].actualBytes = actualBytes;
            ++l;
        }
        this.pktEnc.reset();
        int[] mrlc = new int[nc];
        int t = 0;
        while (t < nt) {
            int[][] lys = new int[nc][];
            int c3 = 0;
            while (c3 < nc) {
                mrlc[c3] = this.src.getAnSubbandTree((int)t, (int)c3).resLvl;
                lys[c3] = new int[mrlc[c3] + 1];
                ++c3;
            }
            this.headEnc.reset();
            this.headEnc.encodeTilePartHeader(tileLengths[t], t);
            this.bsWriter.commitBitstreamHeader(this.headEnc);
            Progression[] prog = (Progression[])this.wp.getProgressionType().getTileDef(t);
            int prg = 0;
            while (prg < prog.length) {
                int lye = prog[prg].lye;
                int cs = prog[prg].cs;
                int ce = prog[prg].ce;
                int rs = prog[prg].rs;
                int re = prog[prg].re;
                switch (prog[prg].type) {
                    case 1: {
                        this.writeResLyCompPos(t, rs, re, cs, ce, lys, lye);
                        break;
                    }
                    case 0: {
                        this.writeLyResCompPos(t, rs, re, cs, ce, lys, lye);
                        break;
                    }
                    case 3: {
                        this.writePosCompResLy(t, rs, re, cs, ce, lys, lye);
                        break;
                    }
                    case 4: {
                        this.writeCompPosResLy(t, rs, re, cs, ce, lys, lye);
                        break;
                    }
                    case 2: {
                        this.writeResPosCompLy(t, rs, re, cs, ce, lys, lye);
                        break;
                    }
                    default: {
                        throw new Error("Unsupported bit stream progression type");
                    }
                }
                int c4 = cs;
                while (c4 < ce) {
                    int r = rs;
                    while (r < re) {
                        if (r <= mrlc[c4]) {
                            lys[c4][r] = lye;
                        }
                        ++r;
                    }
                    ++c4;
                }
                ++prg;
            }
            ++t;
        }
    }

    public void writeResLyCompPos(int t, int rs, int re, int cs, int ce, int[][] lys, int lye) throws IOException {
        int nc = this.src.getNumComps();
        int[] mrl = new int[nc];
        BitOutputBuffer hBuff = null;
        byte[] bBuff = null;
        int nPrec = 0;
        int maxResLvl = 0;
        int c2 = 0;
        while (c2 < nc) {
            mrl[c2] = this.src.getAnSubbandTree((int)t, (int)c2).resLvl;
            if (mrl[c2] > maxResLvl) {
                maxResLvl = mrl[c2];
            }
            ++c2;
        }
        int r = rs;
        while (r < re) {
            if (r <= maxResLvl) {
                int minlys = 100000;
                int c3 = cs;
                while (c3 < ce) {
                    if (r < lys[c3].length && lys[c3][r] < minlys) {
                        minlys = lys[c3][r];
                    }
                    ++c3;
                }
                int l = minlys;
                while (l < lye) {
                    int c4 = cs;
                    while (c4 < ce) {
                        if (r < lys[c4].length && l >= lys[c4][r] && r <= mrl[c4]) {
                            nPrec = this.numPrec[t][c4][r].x * this.numPrec[t][c4][r].y;
                            int p = 0;
                            while (p < nPrec) {
                                boolean sopUsed = ((String)this.wp.getSOP().getTileDef(t)).equals("true");
                                boolean ephUsed = ((String)this.wp.getEPH().getTileDef(t)).equals("true");
                                SubbandAn sb = this.src.getAnSubbandTree(t, c4);
                                int i = mrl[c4];
                                while (i > r) {
                                    sb = sb.subb_LL;
                                    --i;
                                }
                                float threshold = this.layers[l].rdThreshold;
                                this.findTruncIndices(l, c4, r, t, sb, threshold, p);
                                hBuff = this.pktEnc.encodePacket(l + 1, c4, r, t, this.cblks[t][c4][r], this.truncIdxs[t][l][c4][r], hBuff, bBuff, p);
                                if (this.pktEnc.isPacketWritable()) {
                                    this.bsWriter.writePacketHead(hBuff.getBuffer(), hBuff.getLength(), false, sopUsed, ephUsed);
                                    this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                                }
                                ++p;
                            }
                        }
                        ++c4;
                    }
                    ++l;
                }
            }
            ++r;
        }
    }

    public void writeLyResCompPos(int t, int rs, int re, int cs, int ce, int[][] lys, int lye) throws IOException {
        int nc = this.src.getNumComps();
        BitOutputBuffer hBuff = null;
        byte[] bBuff = null;
        int nPrec = 0;
        int minlys = 100000;
        int c2 = cs;
        while (c2 < ce) {
            int r = 0;
            while (r < lys.length) {
                if (lys[c2] != null && r < lys[c2].length && lys[c2][r] < minlys) {
                    minlys = lys[c2][r];
                }
                ++r;
            }
            ++c2;
        }
        int l = minlys;
        while (l < lye) {
            int r = rs;
            while (r < re) {
                int c3 = cs;
                while (c3 < ce) {
                    int mrl = this.src.getAnSubbandTree((int)t, (int)c3).resLvl;
                    if (r <= mrl && r < lys[c3].length && l >= lys[c3][r]) {
                        nPrec = this.numPrec[t][c3][r].x * this.numPrec[t][c3][r].y;
                        int p = 0;
                        while (p < nPrec) {
                            boolean sopUsed = ((String)this.wp.getSOP().getTileDef(t)).equals("true");
                            boolean ephUsed = ((String)this.wp.getEPH().getTileDef(t)).equals("true");
                            SubbandAn sb = this.src.getAnSubbandTree(t, c3);
                            int i = mrl;
                            while (i > r) {
                                sb = sb.subb_LL;
                                --i;
                            }
                            float threshold = this.layers[l].rdThreshold;
                            this.findTruncIndices(l, c3, r, t, sb, threshold, p);
                            hBuff = this.pktEnc.encodePacket(l + 1, c3, r, t, this.cblks[t][c3][r], this.truncIdxs[t][l][c3][r], hBuff, bBuff, p);
                            if (this.pktEnc.isPacketWritable()) {
                                this.bsWriter.writePacketHead(hBuff.getBuffer(), hBuff.getLength(), false, sopUsed, ephUsed);
                                this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                            }
                            ++p;
                        }
                    }
                    ++c3;
                }
                ++r;
            }
            ++l;
        }
    }

    public void writePosCompResLy(int t, int rs, int re, int cs, int ce, int[][] lys, int lye) throws IOException {
        PrecInfo prec;
        int mrl;
        int nc = this.src.getNumComps();
        BitOutputBuffer hBuff = null;
        byte[] bBuff = null;
        Point nTiles = this.src.getNumTiles(null);
        Point tileI = this.src.getTile(null);
        int x0siz = this.src.getImgULX();
        int y0siz = this.src.getImgULY();
        int xsiz = x0siz + this.src.getImgWidth();
        int ysiz = y0siz + this.src.getImgHeight();
        int xt0siz = this.src.getTilePartULX();
        int yt0siz = this.src.getTilePartULY();
        int xtsiz = this.src.getNomTileWidth();
        int ytsiz = this.src.getNomTileHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int gcd_x = 0;
        int gcd_y = 0;
        int nPrec = 0;
        int[][] nextPrec = new int[ce][];
        int minlys = 100000;
        int minx = tx1;
        int miny = ty1;
        int maxx = tx0;
        int maxy = ty0;
        int c2 = cs;
        while (c2 < ce) {
            mrl = this.src.getAnSubbandTree((int)t, (int)c2).resLvl;
            nextPrec[c2] = new int[mrl + 1];
            int r = rs;
            while (r < re) {
                if (r <= mrl) {
                    if (r < lys[c2].length && lys[c2][r] < minlys) {
                        minlys = lys[c2][r];
                    }
                    int p = this.numPrec[t][c2][r].y * this.numPrec[t][c2][r].x - 1;
                    while (p >= 0) {
                        prec = this.pktEnc.getPrecInfo(t, c2, r, p);
                        if (prec.rgulx != tx0) {
                            if (prec.rgulx < minx) {
                                minx = prec.rgulx;
                            }
                            if (prec.rgulx > maxx) {
                                maxx = prec.rgulx;
                            }
                        }
                        if (prec.rguly != ty0) {
                            if (prec.rguly < miny) {
                                miny = prec.rguly;
                            }
                            if (prec.rguly > maxy) {
                                maxy = prec.rguly;
                            }
                        }
                        if (nPrec == 0) {
                            gcd_x = prec.rgw;
                            gcd_y = prec.rgh;
                        } else {
                            gcd_x = MathUtil.gcd(gcd_x, prec.rgw);
                            gcd_y = MathUtil.gcd(gcd_y, prec.rgh);
                        }
                        ++nPrec;
                        --p;
                    }
                }
                ++r;
            }
            ++c2;
        }
        if (nPrec == 0) {
            throw new Error("Image cannot have no precinct");
        }
        int pyend = (maxy - miny) / gcd_y + 1;
        int pxend = (maxx - minx) / gcd_x + 1;
        int y = ty0;
        int x = tx0;
        int py = 0;
        while (py <= pyend) {
            int px = 0;
            while (px <= pxend) {
                int c3 = cs;
                while (c3 < ce) {
                    mrl = this.src.getAnSubbandTree((int)t, (int)c3).resLvl;
                    int r = rs;
                    while (r < re) {
                        if (r <= mrl && nextPrec[c3][r] < this.numPrec[t][c3][r].x * this.numPrec[t][c3][r].y) {
                            prec = this.pktEnc.getPrecInfo(t, c3, r, nextPrec[c3][r]);
                            if (prec.rgulx == x && prec.rguly == y) {
                                int l = minlys;
                                while (l < lye) {
                                    if (r < lys[c3].length && l >= lys[c3][r]) {
                                        boolean sopUsed = ((String)this.wp.getSOP().getTileDef(t)).equals("true");
                                        boolean ephUsed = ((String)this.wp.getEPH().getTileDef(t)).equals("true");
                                        SubbandAn sb = this.src.getAnSubbandTree(t, c3);
                                        int i = mrl;
                                        while (i > r) {
                                            sb = sb.subb_LL;
                                            --i;
                                        }
                                        float threshold = this.layers[l].rdThreshold;
                                        this.findTruncIndices(l, c3, r, t, sb, threshold, nextPrec[c3][r]);
                                        hBuff = this.pktEnc.encodePacket(l + 1, c3, r, t, this.cblks[t][c3][r], this.truncIdxs[t][l][c3][r], hBuff, bBuff, nextPrec[c3][r]);
                                        if (this.pktEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(hBuff.getBuffer(), hBuff.getLength(), false, sopUsed, ephUsed);
                                            this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                                        }
                                    }
                                    ++l;
                                }
                                int[] nArray = nextPrec[c3];
                                int n = r;
                                nArray[n] = nArray[n] + 1;
                            }
                        }
                        ++r;
                    }
                    ++c3;
                }
                x = px != pxend ? minx + px * gcd_x : tx0;
                ++px;
            }
            y = py != pyend ? miny + py * gcd_y : ty0;
            ++py;
        }
        int c4 = cs;
        while (c4 < ce) {
            mrl = this.src.getAnSubbandTree((int)t, (int)c4).resLvl;
            int r = rs;
            while (r < re) {
                if (r <= mrl && nextPrec[c4][r] < this.numPrec[t][c4][r].x * this.numPrec[t][c4][r].y - 1) {
                    throw new Error("JJ2000 bug: One precinct at least has not been written for resolution level " + r + " of component " + c4 + " in tile " + t + ".");
                }
                ++r;
            }
            ++c4;
        }
    }

    public void writeCompPosResLy(int t, int rs, int re, int cs, int ce, int[][] lys, int lye) throws IOException {
        PrecInfo prec;
        int mrl;
        int nc = this.src.getNumComps();
        BitOutputBuffer hBuff = null;
        byte[] bBuff = null;
        Point nTiles = this.src.getNumTiles(null);
        Point tileI = this.src.getTile(null);
        int x0siz = this.src.getImgULX();
        int y0siz = this.src.getImgULY();
        int xsiz = x0siz + this.src.getImgWidth();
        int ysiz = y0siz + this.src.getImgHeight();
        int xt0siz = this.src.getTilePartULX();
        int yt0siz = this.src.getTilePartULY();
        int xtsiz = this.src.getNomTileWidth();
        int ytsiz = this.src.getNomTileHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int gcd_x = 0;
        int gcd_y = 0;
        int nPrec = 0;
        int[][] nextPrec = new int[ce][];
        int minlys = 100000;
        int minx = tx1;
        int miny = ty1;
        int maxx = tx0;
        int maxy = ty0;
        int c2 = cs;
        while (c2 < ce) {
            mrl = this.src.getAnSubbandTree((int)t, (int)c2).resLvl;
            int r = rs;
            while (r < re) {
                if (r <= mrl) {
                    nextPrec[c2] = new int[mrl + 1];
                    if (r < lys[c2].length && lys[c2][r] < minlys) {
                        minlys = lys[c2][r];
                    }
                    int p = this.numPrec[t][c2][r].y * this.numPrec[t][c2][r].x - 1;
                    while (p >= 0) {
                        prec = this.pktEnc.getPrecInfo(t, c2, r, p);
                        if (prec.rgulx != tx0) {
                            if (prec.rgulx < minx) {
                                minx = prec.rgulx;
                            }
                            if (prec.rgulx > maxx) {
                                maxx = prec.rgulx;
                            }
                        }
                        if (prec.rguly != ty0) {
                            if (prec.rguly < miny) {
                                miny = prec.rguly;
                            }
                            if (prec.rguly > maxy) {
                                maxy = prec.rguly;
                            }
                        }
                        if (nPrec == 0) {
                            gcd_x = prec.rgw;
                            gcd_y = prec.rgh;
                        } else {
                            gcd_x = MathUtil.gcd(gcd_x, prec.rgw);
                            gcd_y = MathUtil.gcd(gcd_y, prec.rgh);
                        }
                        ++nPrec;
                        --p;
                    }
                }
                ++r;
            }
            ++c2;
        }
        if (nPrec == 0) {
            throw new Error("Image cannot have no precinct");
        }
        int pyend = (maxy - miny) / gcd_y + 1;
        int pxend = (maxx - minx) / gcd_x + 1;
        int c3 = cs;
        while (c3 < ce) {
            int y = ty0;
            int x = tx0;
            mrl = this.src.getAnSubbandTree((int)t, (int)c3).resLvl;
            int py = 0;
            while (py <= pyend) {
                int px = 0;
                while (px <= pxend) {
                    int r = rs;
                    while (r < re) {
                        if (r <= mrl && nextPrec[c3][r] < this.numPrec[t][c3][r].x * this.numPrec[t][c3][r].y) {
                            prec = this.pktEnc.getPrecInfo(t, c3, r, nextPrec[c3][r]);
                            if (prec.rgulx == x && prec.rguly == y) {
                                int l = minlys;
                                while (l < lye) {
                                    if (r < lys[c3].length && l >= lys[c3][r]) {
                                        boolean sopUsed = ((String)this.wp.getSOP().getTileDef(t)).equals("true");
                                        boolean ephUsed = ((String)this.wp.getEPH().getTileDef(t)).equals("true");
                                        SubbandAn sb = this.src.getAnSubbandTree(t, c3);
                                        int i = mrl;
                                        while (i > r) {
                                            sb = sb.subb_LL;
                                            --i;
                                        }
                                        float threshold = this.layers[l].rdThreshold;
                                        this.findTruncIndices(l, c3, r, t, sb, threshold, nextPrec[c3][r]);
                                        hBuff = this.pktEnc.encodePacket(l + 1, c3, r, t, this.cblks[t][c3][r], this.truncIdxs[t][l][c3][r], hBuff, bBuff, nextPrec[c3][r]);
                                        if (this.pktEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(hBuff.getBuffer(), hBuff.getLength(), false, sopUsed, ephUsed);
                                            this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                                        }
                                    }
                                    ++l;
                                }
                                int[] nArray = nextPrec[c3];
                                int n = r;
                                nArray[n] = nArray[n] + 1;
                            }
                        }
                        ++r;
                    }
                    x = px != pxend ? minx + px * gcd_x : tx0;
                    ++px;
                }
                y = py != pyend ? miny + py * gcd_y : ty0;
                ++py;
            }
            ++c3;
        }
        int c4 = cs;
        while (c4 < ce) {
            mrl = this.src.getAnSubbandTree((int)t, (int)c4).resLvl;
            int r = rs;
            while (r < re) {
                if (r <= mrl && nextPrec[c4][r] < this.numPrec[t][c4][r].x * this.numPrec[t][c4][r].y - 1) {
                    throw new Error("JJ2000 bug: One precinct at least has not been written for resolution level " + r + " of component " + c4 + " in tile " + t + ".");
                }
                ++r;
            }
            ++c4;
        }
    }

    public void writeResPosCompLy(int t, int rs, int re, int cs, int ce, int[][] lys, int lye) throws IOException {
        PrecInfo prec;
        int mrl;
        int nc = this.src.getNumComps();
        BitOutputBuffer hBuff = null;
        byte[] bBuff = null;
        Point nTiles = this.src.getNumTiles(null);
        Point tileI = this.src.getTile(null);
        int x0siz = this.src.getImgULX();
        int y0siz = this.src.getImgULY();
        int xsiz = x0siz + this.src.getImgWidth();
        int ysiz = y0siz + this.src.getImgHeight();
        int xt0siz = this.src.getTilePartULX();
        int yt0siz = this.src.getTilePartULY();
        int xtsiz = this.src.getNomTileWidth();
        int ytsiz = this.src.getNomTileHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int gcd_x = 0;
        int gcd_y = 0;
        int nPrec = 0;
        int[][] nextPrec = new int[ce][];
        int minlys = 100000;
        int minx = tx1;
        int miny = ty1;
        int maxx = tx0;
        int maxy = ty0;
        int c2 = cs;
        while (c2 < ce) {
            mrl = this.src.getAnSubbandTree((int)t, (int)c2).resLvl;
            nextPrec[c2] = new int[mrl + 1];
            int r = rs;
            while (r < re) {
                if (r <= mrl) {
                    if (r < lys[c2].length && lys[c2][r] < minlys) {
                        minlys = lys[c2][r];
                    }
                    int p = this.numPrec[t][c2][r].y * this.numPrec[t][c2][r].x - 1;
                    while (p >= 0) {
                        prec = this.pktEnc.getPrecInfo(t, c2, r, p);
                        if (prec.rgulx != tx0) {
                            if (prec.rgulx < minx) {
                                minx = prec.rgulx;
                            }
                            if (prec.rgulx > maxx) {
                                maxx = prec.rgulx;
                            }
                        }
                        if (prec.rguly != ty0) {
                            if (prec.rguly < miny) {
                                miny = prec.rguly;
                            }
                            if (prec.rguly > maxy) {
                                maxy = prec.rguly;
                            }
                        }
                        if (nPrec == 0) {
                            gcd_x = prec.rgw;
                            gcd_y = prec.rgh;
                        } else {
                            gcd_x = MathUtil.gcd(gcd_x, prec.rgw);
                            gcd_y = MathUtil.gcd(gcd_y, prec.rgh);
                        }
                        ++nPrec;
                        --p;
                    }
                }
                ++r;
            }
            ++c2;
        }
        if (nPrec == 0) {
            throw new Error("Image cannot have no precinct");
        }
        int pyend = (maxy - miny) / gcd_y + 1;
        int pxend = (maxx - minx) / gcd_x + 1;
        int r = rs;
        while (r < re) {
            int y = ty0;
            int x = tx0;
            int py = 0;
            while (py <= pyend) {
                int px = 0;
                while (px <= pxend) {
                    int c3 = cs;
                    while (c3 < ce) {
                        mrl = this.src.getAnSubbandTree((int)t, (int)c3).resLvl;
                        if (r <= mrl && nextPrec[c3][r] < this.numPrec[t][c3][r].x * this.numPrec[t][c3][r].y) {
                            prec = this.pktEnc.getPrecInfo(t, c3, r, nextPrec[c3][r]);
                            if (prec.rgulx == x && prec.rguly == y) {
                                int l = minlys;
                                while (l < lye) {
                                    if (r < lys[c3].length && l >= lys[c3][r]) {
                                        boolean sopUsed = ((String)this.wp.getSOP().getTileDef(t)).equals("true");
                                        boolean ephUsed = ((String)this.wp.getEPH().getTileDef(t)).equals("true");
                                        SubbandAn sb = this.src.getAnSubbandTree(t, c3);
                                        int i = mrl;
                                        while (i > r) {
                                            sb = sb.subb_LL;
                                            --i;
                                        }
                                        float threshold = this.layers[l].rdThreshold;
                                        this.findTruncIndices(l, c3, r, t, sb, threshold, nextPrec[c3][r]);
                                        hBuff = this.pktEnc.encodePacket(l + 1, c3, r, t, this.cblks[t][c3][r], this.truncIdxs[t][l][c3][r], hBuff, bBuff, nextPrec[c3][r]);
                                        if (this.pktEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(hBuff.getBuffer(), hBuff.getLength(), false, sopUsed, ephUsed);
                                            this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                                        }
                                    }
                                    ++l;
                                }
                                int[] nArray = nextPrec[c3];
                                int n = r;
                                nArray[n] = nArray[n] + 1;
                            }
                        }
                        ++c3;
                    }
                    x = px != pxend ? minx + px * gcd_x : tx0;
                    ++px;
                }
                y = py != pyend ? miny + py * gcd_y : ty0;
                ++py;
            }
            ++r;
        }
        int c4 = cs;
        while (c4 < ce) {
            mrl = this.src.getAnSubbandTree((int)t, (int)c4).resLvl;
            int r2 = rs;
            while (r2 < re) {
                if (r2 <= mrl && nextPrec[c4][r2] < this.numPrec[t][c4][r2].x * this.numPrec[t][c4][r2].y - 1) {
                    throw new Error("JJ2000 bug: One precinct at least has not been written for resolution level " + r2 + " of component " + c4 + " in tile " + t + ".");
                }
                ++r2;
            }
            ++c4;
        }
    }

    private float optimizeBitstreamLayer(int layerIdx, float fmaxt, int maxBytes, int prevBytes) throws IOException {
        float ft;
        this.pktEnc.save();
        int nt = this.src.getNumTiles();
        int nc = this.src.getNumComps();
        BitOutputBuffer hBuff = null;
        byte[] bBuff = null;
        int sidx = 63;
        while (sidx > 0) {
            if (this.RDSlopesRates[sidx] >= maxBytes) break;
            --sidx;
        }
        float fmint = EBCOTRateAllocator.getSlopeFromSIndex(sidx);
        if (fmint >= fmaxt) {
            fmint = EBCOTRateAllocator.getSlopeFromSIndex(--sidx);
        }
        if (sidx <= 0) {
            fmint = 0.0f;
        }
        if ((ft = (fmaxt + fmint) / 2.0f) <= fmint) {
            ft = fmaxt;
        }
        do {
            int actualBytes = prevBytes;
            this.src.setTile(0, 0);
            int t = 0;
            while (t < nt) {
                int c2 = 0;
                while (c2 < nc) {
                    boolean sopUsed = ((String)this.wp.getSOP().getTileDef(t)).equalsIgnoreCase("true");
                    boolean ephUsed = ((String)this.wp.getEPH().getTileDef(t)).equalsIgnoreCase("true");
                    SubbandAn sb = this.src.getAnSubbandTree(t, c2);
                    int numLvls = sb.resLvl + 1;
                    sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                    int r = 0;
                    while (r < numLvls) {
                        int nPrec = this.numPrec[t][c2][r].x * this.numPrec[t][c2][r].y;
                        int p = 0;
                        while (p < nPrec) {
                            this.findTruncIndices(layerIdx, c2, r, t, sb, ft, p);
                            hBuff = this.pktEnc.encodePacket(layerIdx + 1, c2, r, t, this.cblks[t][c2][r], this.truncIdxs[t][layerIdx][c2][r], hBuff, bBuff, p);
                            if (this.pktEnc.isPacketWritable()) {
                                bBuff = this.pktEnc.getLastBodyBuf();
                                actualBytes += this.bsWriter.writePacketHead(hBuff.getBuffer(), hBuff.getLength(), true, sopUsed, ephUsed);
                                actualBytes += this.bsWriter.writePacketBody(bBuff, this.pktEnc.getLastBodyLen(), true, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                            }
                            ++p;
                        }
                        sb = sb.parent;
                        ++r;
                    }
                    ++c2;
                }
                ++t;
            }
            if (actualBytes > maxBytes) {
                fmint = ft;
            } else {
                fmaxt = ft;
            }
            ft = (fmaxt + fmint) / 2.0f;
            if (ft <= fmint) {
                ft = fmaxt;
            }
            this.pktEnc.restore();
        } while (ft < fmaxt * 0.9999f && ft < fmaxt - 1.0E-10f);
        ft = ft <= 1.0E-10f ? 0.0f : fmaxt;
        return ft;
    }

    private float estimateLayerThreshold(int targetBytes, EBCOTLayer lastLayer) {
        float log_ab;
        float log_len2;
        float log_len1;
        float lthresh = lastLayer.rdThreshold;
        if (lthresh > this.maxSlope) {
            lthresh = this.maxSlope;
        }
        if (lthresh < 1.0E-10f) {
            return 0.0f;
        }
        int sidx = EBCOTRateAllocator.getLimitedSIndexFromSlope(lthresh);
        if (sidx >= 63) {
            sidx = 62;
        }
        if (this.RDSlopesRates[sidx + 1] == 0) {
            log_len1 = (float)Math.log((this.RDSlopesRates[sidx] << 1) + 1);
            log_len2 = (float)Math.log(this.RDSlopesRates[sidx] + 1);
            log_ab = (float)Math.log(lastLayer.actualBytes + this.RDSlopesRates[sidx] + 1);
        } else {
            log_len1 = (float)Math.log(this.RDSlopesRates[sidx]);
            log_len2 = (float)Math.log(this.RDSlopesRates[sidx + 1]);
            log_ab = (float)Math.log(lastLayer.actualBytes);
        }
        float log_sl1 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(sidx));
        float log_sl2 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(sidx + 1));
        float log_isl = (float)Math.log(lthresh);
        float log_ilen = log_len1 + (log_isl - log_sl1) * (log_len1 - log_len2) / (log_sl1 - log_sl2);
        float log_off = log_ab - log_ilen;
        if (log_off < 0.0f) {
            log_off = 0.0f;
        }
        int tlen = (int)((float)targetBytes / (float)Math.exp(log_off));
        sidx = 63;
        while (sidx >= 0) {
            if (this.RDSlopesRates[sidx] >= tlen) break;
            --sidx;
        }
        if (++sidx >= 64) {
            sidx = 63;
        }
        if (sidx <= 0) {
            sidx = 1;
        }
        if (this.RDSlopesRates[sidx] == 0) {
            log_len1 = (float)Math.log(this.RDSlopesRates[sidx - 1] + 1);
            log_len2 = (float)Math.log((this.RDSlopesRates[sidx - 1] << 1) + 1);
            log_ilen = (float)Math.log(tlen + this.RDSlopesRates[sidx - 1] + 1);
        } else {
            log_len1 = (float)Math.log(this.RDSlopesRates[sidx]);
            log_len2 = (float)Math.log(this.RDSlopesRates[sidx - 1]);
            log_ilen = (float)Math.log(tlen);
        }
        log_sl1 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(sidx));
        log_sl2 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(sidx - 1));
        log_isl = log_sl1 + (log_ilen - log_len1) * (log_sl1 - log_sl2) / (log_len1 - log_len2);
        float eth = (float)Math.exp(log_isl);
        if (eth > lthresh) {
            eth = lthresh;
        }
        if (eth < 1.0E-10f) {
            eth = 0.0f;
        }
        return eth;
    }

    private void findTruncIndices(int layerIdx, int compIdx, int lvlIdx, int tileIdx, SubbandAn subb, float fthresh, int precinctIdx) {
        Object ncblks = null;
        PrecInfo prec = this.pktEnc.getPrecInfo(tileIdx, compIdx, lvlIdx, precinctIdx);
        SubbandAn sb = subb;
        while (sb.subb_HH != null) {
            sb = sb.subb_HH;
        }
        int minsbi = lvlIdx == 0 ? 0 : 1;
        int maxsbi = lvlIdx == 0 ? 1 : 4;
        sb = (SubbandAn)subb.getSubbandByIdx(lvlIdx, minsbi);
        int s = minsbi;
        while (s < maxsbi) {
            int yend = prec.cblk[s] != null ? prec.cblk[s].length : 0;
            int y = 0;
            while (y < yend) {
                int xend = prec.cblk[s][y] != null ? prec.cblk[s][y].length : 0;
                int x = 0;
                while (x < xend) {
                    Point cbCoord = prec.cblk[s][y][x].idx;
                    int b2 = cbCoord.x + cbCoord.y * sb.numCb.x;
                    CBlkRateDistStats cur_cblk = this.cblks[tileIdx][compIdx][lvlIdx][s][b2];
                    int n = 0;
                    while (n < cur_cblk.nVldTrunc) {
                        if (cur_cblk.truncSlopes[n] < fthresh) break;
                        ++n;
                    }
                    this.truncIdxs[tileIdx][layerIdx][compIdx][lvlIdx][s][b2] = n - 1;
                    ++x;
                }
                ++y;
            }
            sb = (SubbandAn)sb.nextSubband();
            ++s;
        }
    }

    private static int getLimitedSIndexFromSlope(float slope) {
        int idx = (int)Math.floor(Math.log(slope) / LOG2) + 24;
        if (idx < 0) {
            return 0;
        }
        if (idx >= 64) {
            return 63;
        }
        return idx;
    }

    private static float getSlopeFromSIndex(int index) {
        return (float)Math.pow(2.0, index - 24);
    }

    static {
        DO_TIMING = false;
        LOG2 = Math.log(2.0);
        RD_SUMMARY_OFF = 24;
        RD_SUMMARY_SIZE = 64;
        FLOAT_REL_PRECISION = 1.0E-4f;
        FLOAT_ABS_PRECISION = 1.0E-10f;
        MIN_AVG_PACKET_SZ = 32;
    }
}

