/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;

public class QuantTypeSpec
extends ModuleSpec {
    public QuantTypeSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public QuantTypeSpec(int nt, int nc, byte type, J2KImageWriteParamJava wp, String values) {
        super(nt, nc, type);
        if (values == null) {
            if (wp.getLossless()) {
                this.setDefault("reversible");
            } else {
                this.setDefault("expounded");
            }
            return;
        }
        this.specified = values;
        String param = values;
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecValType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken().toLowerCase();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = ModuleSpec.parseIdx(word, this.nTiles);
                    if (curSpecValType == 1) {
                        curSpecValType = 3;
                        break;
                    }
                    curSpecValType = 2;
                    break;
                }
                case 'c': {
                    compSpec = ModuleSpec.parseIdx(word, this.nComp);
                    if (curSpecValType == 2) {
                        curSpecValType = 3;
                        break;
                    }
                    curSpecValType = 1;
                    break;
                }
                case 'd': 
                case 'e': 
                case 'r': {
                    int i;
                    if (!(word.equalsIgnoreCase("reversible") || word.equalsIgnoreCase("derived") || word.equalsIgnoreCase("expounded"))) {
                        throw new IllegalArgumentException("Unknown parameter for '-Qtype' option: " + word);
                    }
                    if (wp.getLossless() && (word.equalsIgnoreCase("derived") || word.equalsIgnoreCase("expounded"))) {
                        throw new IllegalArgumentException("Cannot use non reversible quantization with '-lossless' option");
                    }
                    if (curSpecValType == 0) {
                        this.setDefault(word);
                    } else if (curSpecValType == 2) {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            if (tileSpec[i]) {
                                this.setTileDef(i, word);
                            }
                            --i;
                        }
                    } else if (curSpecValType == 1) {
                        i = compSpec.length - 1;
                        while (i >= 0) {
                            if (compSpec[i]) {
                                this.setCompDef(i, word);
                            }
                            --i;
                        }
                    } else {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            int j = compSpec.length - 1;
                            while (j >= 0) {
                                if (tileSpec[i] && compSpec[j]) {
                                    this.setTileCompVal(i, j, word);
                                }
                                --j;
                            }
                            --i;
                        }
                    }
                    curSpecValType = 0;
                    tileSpec = null;
                    compSpec = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown parameter for '-Qtype' option: " + word);
                }
            }
        }
        if (this.getDefault() == null) {
            int c2;
            int ndefspec = 0;
            int t = nt - 1;
            while (t >= 0) {
                c2 = nc - 1;
                while (c2 >= 0) {
                    if (this.specValType[t][c2] == 0) {
                        ++ndefspec;
                    }
                    --c2;
                }
                --t;
            }
            if (ndefspec != 0) {
                if (wp.getLossless()) {
                    this.setDefault("reversible");
                } else {
                    this.setDefault("expounded");
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        c2 = nc - 1;
                        while (c2 >= 0) {
                            if (this.specValType[0][c2] == 2) {
                                this.specValType[0][c2] = 0;
                            }
                            --c2;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        int t2 = nt - 1;
                        while (t2 >= 0) {
                            if (this.specValType[t2][0] == 1) {
                                this.specValType[t2][0] = 0;
                            }
                            --t2;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }

    public boolean isDerived(int t, int c2) {
        return ((String)this.getTileCompVal(t, c2)).equals("derived");
    }

    public boolean isReversible(int t, int c2) {
        return ((String)this.getTileCompVal(t, c2)).equals("reversible");
    }

    public boolean isFullyReversible() {
        if (((String)this.getDefault()).equals("reversible")) {
            int t = this.nTiles - 1;
            while (t >= 0) {
                int c2 = this.nComp - 1;
                while (c2 >= 0) {
                    if (this.specValType[t][c2] != 0) {
                        return false;
                    }
                    --c2;
                }
                --t;
            }
            return true;
        }
        return false;
    }

    public boolean isFullyNonReversible() {
        int t = this.nTiles - 1;
        while (t >= 0) {
            int c2 = this.nComp - 1;
            while (c2 >= 0) {
                if (((String)this.getSpec(t, c2)).equals("reversible")) {
                    return false;
                }
                --c2;
            }
            --t;
        }
        return true;
    }
}

