/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization.quantizer;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import jj2000.j2k.quantization.GuardBitsSpec;
import jj2000.j2k.quantization.QuantStepSizeSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.CBlkWTDataFloat;
import jj2000.j2k.wavelet.analysis.CBlkWTDataSrc;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class StdQuantizer
extends Quantizer {
    public static final int QSTEP_MANTISSA_BITS = 11;
    public static final int QSTEP_EXPONENT_BITS = 5;
    public static final int QSTEP_MAX_MANTISSA = 2047;
    public static final int QSTEP_MAX_EXPONENT = 31;
    private static double log2;
    private QuantTypeSpec qts;
    private QuantStepSizeSpec qsss;
    private GuardBitsSpec gbs;
    private CBlkWTDataFloat infblk;

    public StdQuantizer(CBlkWTDataSrc src, J2KImageWriteParamJava wp) {
        super(src);
        this.qts = wp.getQuantizationType();
        this.qsss = wp.getQuantizationStep();
        this.gbs = wp.getGuardBits();
    }

    public QuantTypeSpec getQuantTypeSpec() {
        return this.qts;
    }

    public int getNumGuardBits(int t, int c2) {
        return (Integer)this.gbs.getTileCompVal(t, c2);
    }

    public boolean isReversible(int t, int c2) {
        return this.qts.isReversible(t, c2);
    }

    public boolean isDerived(int t, int c2) {
        return this.qts.isDerived(t, c2);
    }

    public CBlkWTData getNextCodeBlock(int c2, CBlkWTData cblk) {
        return this.getNextInternCodeBlock(c2, cblk);
    }

    /*
     * Exception decompiling
     */
    public final CBlkWTData getNextInternCodeBlock(int c, CBlkWTData cblk) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void calcSbParams(SubbandAn sb, int c2) {
        if (sb.stepWMSE > 0.0f) {
            return;
        }
        if (!sb.isNode) {
            if (this.isReversible(this.tIdx, c2)) {
                sb.stepWMSE = (float)Math.pow(2.0, -(this.src.getNomRangeBits(c2) << 1)) * sb.l2Norm * sb.l2Norm;
            } else {
                float baseStep = ((Float)this.qsss.getTileCompVal(this.tIdx, c2)).floatValue();
                sb.stepWMSE = this.isDerived(this.tIdx, c2) ? baseStep * baseStep * (float)Math.pow(2.0, sb.anGainExp - sb.level << 1) * sb.l2Norm * sb.l2Norm : baseStep * baseStep;
            }
        } else {
            this.calcSbParams((SubbandAn)sb.getLL(), c2);
            this.calcSbParams((SubbandAn)sb.getHL(), c2);
            this.calcSbParams((SubbandAn)sb.getLH(), c2);
            this.calcSbParams((SubbandAn)sb.getHH(), c2);
            sb.stepWMSE = 1.0f;
        }
    }

    public static int convertToExpMantissa(float step) {
        int exp = (int)Math.ceil(-Math.log(step) / log2);
        if (exp > 31) {
            return 63488;
        }
        return exp << 11 | (int)((-step * (float)(-1 << exp) - 1.0f) * 2048.0f + 0.5f);
    }

    private static float convertFromExpMantissa(int ems) {
        return (-1.0f - (float)(ems & 0x7FF) / 2048.0f) / (float)(-1 << (ems >> 11 & 0x1F));
    }

    public int getMaxMagBits(int c2) {
        SubbandAn sb = this.getAnSubbandTree(this.tIdx, c2);
        if (this.isReversible(this.tIdx, c2)) {
            return this.getMaxMagBitsRev(sb, c2);
        }
        if (this.isDerived(this.tIdx, c2)) {
            return this.getMaxMagBitsDerived(sb, this.tIdx, c2);
        }
        return this.getMaxMagBitsExpounded(sb, this.tIdx, c2);
    }

    private int getMaxMagBitsRev(Subband sb, int c2) {
        int max = 0;
        int g = (Integer)this.gbs.getTileCompVal(this.tIdx, c2);
        if (!sb.isNode) {
            return g - 1 + this.src.getNomRangeBits(c2) + sb.anGainExp;
        }
        max = this.getMaxMagBitsRev(sb.getLL(), c2);
        int tmp = this.getMaxMagBitsRev(sb.getLH(), c2);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsRev(sb.getHL(), c2)) > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsRev(sb.getHH(), c2)) > max) {
            max = tmp;
        }
        return max;
    }

    private int getMaxMagBitsDerived(Subband sb, int t, int c2) {
        int max = 0;
        int g = (Integer)this.gbs.getTileCompVal(t, c2);
        if (!sb.isNode) {
            float baseStep = ((Float)this.qsss.getTileCompVal(t, c2)).floatValue();
            return g - 1 + sb.level - (int)Math.floor(Math.log(baseStep) / log2);
        }
        max = this.getMaxMagBitsDerived(sb.getLL(), t, c2);
        int tmp = this.getMaxMagBitsDerived(sb.getLH(), t, c2);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsDerived(sb.getHL(), t, c2)) > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsDerived(sb.getHH(), t, c2)) > max) {
            max = tmp;
        }
        return max;
    }

    private int getMaxMagBitsExpounded(Subband sb, int t, int c2) {
        int max = 0;
        int g = (Integer)this.gbs.getTileCompVal(t, c2);
        if (!sb.isNode) {
            float baseStep = ((Float)this.qsss.getTileCompVal(t, c2)).floatValue();
            return g - 1 - (int)Math.floor(Math.log(baseStep / (((SubbandAn)sb).l2Norm * (float)(1 << sb.anGainExp))) / log2);
        }
        max = this.getMaxMagBitsExpounded(sb.getLL(), t, c2);
        int tmp = this.getMaxMagBitsExpounded(sb.getLH(), t, c2);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsExpounded(sb.getHL(), t, c2)) > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsExpounded(sb.getHH(), t, c2)) > max) {
            max = tmp;
        }
        return max;
    }

    static {
        QSTEP_MANTISSA_BITS = 11;
        QSTEP_EXPONENT_BITS = 5;
        QSTEP_MAX_MANTISSA = 2047;
        QSTEP_MAX_EXPONENT = 31;
        log2 = Math.log(2.0);
    }
}

