/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import junit.swingui.TestRunContext;
import junit.swingui.TestRunView;
import junit.swingui.TestRunner;

public class FailureRunView
implements TestRunView {
    JList fFailureList;
    TestRunContext fRunContext;

    public FailureRunView(TestRunContext context) {
        this.fRunContext = context;
        this.fFailureList = new JList(this.fRunContext.getFailures());
        this.fFailureList.setFont(new Font("Dialog", 0, 12));
        this.fFailureList.setSelectionMode(0);
        this.fFailureList.setCellRenderer(new FailureListCellRenderer());
        this.fFailureList.setVisibleRowCount(5);
        this.fFailureList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FailureRunView.this.testSelected();
            }
        });
    }

    public Test getSelectedTest() {
        int index = this.fFailureList.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        ListModel model = this.fFailureList.getModel();
        TestFailure failure = (TestFailure)model.getElementAt(index);
        return failure.failedTest();
    }

    public void activate() {
        this.testSelected();
    }

    public void addTab(JTabbedPane pane) {
        JScrollPane scrollPane = new JScrollPane(this.fFailureList, 22, 32);
        Icon errorIcon = TestRunner.getIconResource(this.getClass(), "icons/error.gif");
        pane.addTab("Failures", errorIcon, scrollPane, "The list of failed tests");
    }

    public void revealFailure(Test failure) {
        this.fFailureList.setSelectedIndex(0);
    }

    public void aboutToStart(Test suite, TestResult result2) {
    }

    public void runFinished(Test suite, TestResult result2) {
    }

    protected void testSelected() {
        this.fRunContext.handleTestSelected(this.getSelectedTest());
    }

    static class FailureListCellRenderer
    extends DefaultListCellRenderer {
        private Icon fFailureIcon;
        private Icon fErrorIcon;

        FailureListCellRenderer() {
            this.loadIcons();
        }

        void loadIcons() {
            this.fFailureIcon = TestRunner.getIconResource(this.getClass(), "icons/failure.gif");
            this.fErrorIcon = TestRunner.getIconResource(this.getClass(), "icons/error.gif");
        }

        public Component getListCellRendererComponent(JList list, Object value, int modelIndex, boolean isSelected, boolean cellHasFocus) {
            Component c2 = super.getListCellRendererComponent((JList<?>)list, value, modelIndex, isSelected, cellHasFocus);
            TestFailure failure = (TestFailure)value;
            String text = failure.failedTest().toString();
            String msg = failure.exceptionMessage();
            if (msg != null) {
                text = String.valueOf(text) + ":" + BaseTestRunner.truncate(msg);
            }
            if (failure.isFailure()) {
                if (this.fFailureIcon != null) {
                    this.setIcon(this.fFailureIcon);
                }
            } else if (this.fErrorIcon != null) {
                this.setIcon(this.fErrorIcon);
            }
            this.setText(text);
            this.setToolTipText(text);
            return c2;
        }
    }
}

