/*
 * Decompiled with CFR 0.152.
 */
package org.jdeferred.impl;

import org.jdeferred.DoneCallback;
import org.jdeferred.DoneFilter;
import org.jdeferred.FailCallback;
import org.jdeferred.FailFilter;
import org.jdeferred.ProgressCallback;
import org.jdeferred.ProgressFilter;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;

public class FilteredPromise<D, F, P, D_OUT, F_OUT, P_OUT>
extends DeferredObject<D_OUT, F_OUT, P_OUT>
implements Promise<D_OUT, F_OUT, P_OUT> {
    protected static final NoOpDoneFilter NO_OP_DONE_FILTER = new NoOpDoneFilter();
    protected static final NoOpFailFilter NO_OP_FAIL_FILTER = new NoOpFailFilter();
    protected static final NoOpProgressFilter NO_OP_PROGRESS_FILTER = new NoOpProgressFilter();
    private final DoneFilter<D, D_OUT> doneFilter;
    private final FailFilter<F, F_OUT> failFilter;
    private final ProgressFilter<P, P_OUT> progressFilter;

    public FilteredPromise(Promise<D, F, P> promise, DoneFilter<D, D_OUT> doneFilter, FailFilter<F, F_OUT> failFilter, ProgressFilter<P, P_OUT> progressFilter) {
        this.doneFilter = doneFilter == null ? NO_OP_DONE_FILTER : doneFilter;
        this.failFilter = failFilter == null ? NO_OP_FAIL_FILTER : failFilter;
        this.progressFilter = progressFilter == null ? NO_OP_PROGRESS_FILTER : progressFilter;
        promise.done(new DoneCallback<D>(){

            @Override
            public void onDone(D result2) {
                FilteredPromise.this.resolve(FilteredPromise.this.doneFilter.filterDone(result2));
            }
        }).fail(new FailCallback<F>(){

            @Override
            public void onFail(F result2) {
                FilteredPromise.this.reject(FilteredPromise.this.failFilter.filterFail(result2));
            }
        }).progress(new ProgressCallback<P>(){

            @Override
            public void onProgress(P progress) {
                FilteredPromise.this.notify(FilteredPromise.this.progressFilter.filterProgress(progress));
            }
        });
    }

    public static final class NoOpProgressFilter<P>
    implements ProgressFilter<P, P> {
        @Override
        public P filterProgress(P progress) {
            return progress;
        }
    }

    public static final class NoOpFailFilter<F>
    implements FailFilter<F, F> {
        @Override
        public F filterFail(F result2) {
            return result2;
        }
    }

    public static final class NoOpDoneFilter<D>
    implements DoneFilter<D, D> {
        @Override
        public D filterDone(D result2) {
            return result2;
        }
    }
}

