/*
 * Decompiled with CFR 0.152.
 */
package org.jdeferred.multiple;

import java.util.concurrent.atomic.AtomicInteger;
import org.jdeferred.DoneCallback;
import org.jdeferred.FailCallback;
import org.jdeferred.ProgressCallback;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;
import org.jdeferred.multiple.MasterProgress;
import org.jdeferred.multiple.MultipleResults;
import org.jdeferred.multiple.OneProgress;
import org.jdeferred.multiple.OneReject;
import org.jdeferred.multiple.OneResult;

public class MasterDeferredObject
extends DeferredObject<MultipleResults, OneReject, MasterProgress>
implements Promise<MultipleResults, OneReject, MasterProgress> {
    private final int numberOfPromises;
    private final AtomicInteger doneCount = new AtomicInteger();
    private final AtomicInteger failCount = new AtomicInteger();
    private final MultipleResults results;

    public MasterDeferredObject(Promise ... promises) {
        if (promises == null || promises.length == 0) {
            throw new IllegalArgumentException("Promises is null or empty");
        }
        this.numberOfPromises = promises.length;
        this.results = new MultipleResults(this.numberOfPromises);
        int count = 0;
        for (final Promise promise : promises) {
            final int index = count++;
            promise.fail(new FailCallback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFail(Object result2) {
                    MasterDeferredObject masterDeferredObject = MasterDeferredObject.this;
                    synchronized (masterDeferredObject) {
                        if (!MasterDeferredObject.this.isPending()) {
                            return;
                        }
                        int fail = MasterDeferredObject.this.failCount.incrementAndGet();
                        MasterDeferredObject.this.notify(new MasterProgress(MasterDeferredObject.this.doneCount.get(), fail, MasterDeferredObject.this.numberOfPromises));
                        MasterDeferredObject.this.reject(new OneReject(index, promise, result2));
                    }
                }
            }).progress(new ProgressCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onProgress(Object progress) {
                    MasterDeferredObject masterDeferredObject = MasterDeferredObject.this;
                    synchronized (masterDeferredObject) {
                        if (!MasterDeferredObject.this.isPending()) {
                            return;
                        }
                        MasterDeferredObject.this.notify(new OneProgress(MasterDeferredObject.this.doneCount.get(), MasterDeferredObject.this.failCount.get(), MasterDeferredObject.this.numberOfPromises, index, promise, progress));
                    }
                }
            }).done(new DoneCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onDone(Object result2) {
                    MasterDeferredObject masterDeferredObject = MasterDeferredObject.this;
                    synchronized (masterDeferredObject) {
                        if (!MasterDeferredObject.this.isPending()) {
                            return;
                        }
                        MasterDeferredObject.this.results.set(index, new OneResult(index, promise, result2));
                        int done = MasterDeferredObject.this.doneCount.incrementAndGet();
                        MasterDeferredObject.this.notify(new MasterProgress(done, MasterDeferredObject.this.failCount.get(), MasterDeferredObject.this.numberOfPromises));
                        if (done == MasterDeferredObject.this.numberOfPromises) {
                            MasterDeferredObject.this.resolve(MasterDeferredObject.this.results);
                        }
                    }
                }
            });
        }
    }
}

