/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.DrawableLegendItem;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendRenderingOrder;
import org.jfree.chart.OldLegend;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class DefaultOldLegend
extends OldLegend
implements Serializable {
    private static final long serialVersionUID = -5466149184220837922L;
    public static final RectangleInsets DEFAULT_MARGIN = new RectangleInsets(3.0, 3.0, 3.0, 3.0);
    public static final RectangleInsets DEFAULT_PADDING = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke();
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final Font DEFAULT_TITLE_FONT = new Font("SansSerif", 1, 11);
    public static final Font DEFAULT_ITEM_FONT = new Font("SansSerif", 0, 10);
    public static final double NO_PREFERRED_WIDTH = Double.MAX_VALUE;
    private static final String UNEXPECTED_LEGEND_ANCHOR = "Unexpected legend anchor";
    private RectangleInsets margin;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private transient Paint backgroundPaint;
    private RectangleInsets padding;
    private String title = null;
    private Font titleFont;
    private Font itemFont;
    private transient Paint itemPaint;
    private double shapeScaleX = 1.0;
    private double shapeScaleY = 1.0;
    private LegendRenderingOrder renderingOrder = LegendRenderingOrder.STANDARD;
    private int boundingBoxArcWidth = 0;
    private int boundingBoxArcHeight = 0;
    private double preferredWidth = Double.MAX_VALUE;

    public DefaultOldLegend() {
        this.margin = DEFAULT_MARGIN;
        this.padding = DEFAULT_PADDING;
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
        this.outlineStroke = DEFAULT_OUTLINE_STROKE;
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.titleFont = DEFAULT_TITLE_FONT;
        this.itemFont = DEFAULT_ITEM_FONT;
        this.itemPaint = Color.black;
    }

    public RectangleInsets getMargin() {
        return this.margin;
    }

    public void setMargin(RectangleInsets margin) {
        if (margin == null) {
            throw new NullPointerException("Null 'margin' argument.");
        }
        this.margin = margin;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public RectangleInsets getPadding() {
        return this.padding;
    }

    public void setPadding(RectangleInsets padding) {
        if (padding == null) {
            throw new NullPointerException("Null 'padding' argument.");
        }
        this.padding = padding;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.backgroundPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException("Null 'stroke' argument.");
        }
        this.outlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.outlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.titleFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.itemFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getItemPaint() {
        return this.itemPaint;
    }

    public void setItemPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.itemPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public double getShapeScaleX() {
        return this.shapeScaleX;
    }

    public void setShapeScaleX(double factor) {
        this.shapeScaleX = factor;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public double getShapeScaleY() {
        return this.shapeScaleY;
    }

    public void setShapeScaleY(double factor) {
        this.shapeScaleY = factor;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public LegendRenderingOrder getRenderingOrder() {
        return this.renderingOrder;
    }

    public void setRenderingOrder(LegendRenderingOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = order;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public int getBoundingBoxArcWidth() {
        return this.boundingBoxArcWidth;
    }

    public void setBoundingBoxArcWidth(int arcWidth) {
        this.boundingBoxArcWidth = arcWidth;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public int getBoundingBoxArcHeight() {
        return this.boundingBoxArcHeight;
    }

    public void setBoundingBoxArcHeight(int arcHeight) {
        this.boundingBoxArcHeight = arcHeight;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(double width) {
        this.preferredWidth = width;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D g2, Rectangle2D available, ChartRenderingInfo info) {
        return this.draw(g2, available, (this.getAnchor() & 1) != 0, (this.getAnchor() & 2) != 0, info);
    }

    protected Rectangle2D draw(Graphics2D g2, Rectangle2D available, boolean horizontal, boolean inverted, ChartRenderingInfo info) {
        Point2D translation;
        RoundRectangle2D legendArea;
        LegendItemCollection legendItems = this.getChart().getPlot().getLegendItems();
        if (legendItems == null || legendItems.getItemCount() == 0) {
            return available;
        }
        DrawableLegendItem legendTitle = null;
        LegendItem titleItem = null;
        if (this.title != null && !this.title.equals("")) {
            titleItem = new LegendItem(this.title, this.title, null, null, null, Color.black);
        }
        double availableWidth = available.getWidth();
        ArrayList<DrawableLegendItem> items = new ArrayList<DrawableLegendItem>();
        if (horizontal) {
            double xstart = available.getX() + this.getMargin().calculateLeftOutset(availableWidth);
            double xlimit = available.getMaxX() - this.getMargin().calculateRightOutset(availableWidth);
            double maxRowWidth = 0.0;
            double xoffset = 0.0;
            double rowHeight = 0.0;
            double totalHeight = 0.0;
            boolean wrappingAllowed = true;
            if (titleItem != null) {
                g2.setFont(this.getTitleFont());
                legendTitle = this.createDrawableLegendItem(g2, titleItem, xoffset, totalHeight);
                rowHeight = Math.max(0.0, legendTitle.getHeight());
                xoffset += legendTitle.getWidth();
            }
            g2.setFont(this.itemFont);
            for (int i = 0; i < legendItems.getItemCount(); ++i) {
                DrawableLegendItem item = this.renderingOrder == LegendRenderingOrder.STANDARD ? this.createDrawableLegendItem(g2, legendItems.get(i), xoffset, totalHeight) : (this.renderingOrder == LegendRenderingOrder.REVERSE ? this.createDrawableLegendItem(g2, legendItems.get(legendItems.getItemCount() - i - 1), xoffset, totalHeight) : null);
                if (item.getMaxX() + xstart > xlimit && wrappingAllowed) {
                    maxRowWidth = Math.max(maxRowWidth, xoffset);
                    xoffset = 0.0;
                    totalHeight += rowHeight;
                    --i;
                    wrappingAllowed = false;
                    continue;
                }
                rowHeight = Math.max(rowHeight, item.getHeight());
                xoffset += item.getWidth();
                wrappingAllowed = true;
                items.add(item);
            }
            maxRowWidth = Math.max(maxRowWidth, xoffset);
            legendArea = new RoundRectangle2D.Double(0.0, 0.0, maxRowWidth, totalHeight += rowHeight, this.boundingBoxArcWidth, this.boundingBoxArcHeight);
            translation = this.createTranslationPointForHorizontalDraw(available, inverted, maxRowWidth, totalHeight);
        } else {
            double maxWidth;
            double totalHeight = 0.0;
            double d = maxWidth = this.preferredWidth == Double.MAX_VALUE ? 0.0 : this.preferredWidth;
            if (titleItem != null) {
                g2.setFont(this.getTitleFont());
                legendTitle = this.createDrawableLegendItem(g2, titleItem, 0.0, totalHeight);
                totalHeight += legendTitle.getHeight();
                maxWidth = Math.max(maxWidth, legendTitle.getWidth());
            }
            g2.setFont(this.itemFont);
            int legendItemsLength = legendItems.getItemCount();
            for (int i = 0; i < legendItemsLength; ++i) {
                List drawableParts = this.renderingOrder == LegendRenderingOrder.STANDARD ? this.createAllDrawableLinesForItem(g2, legendItems.get(i), 0.0, totalHeight, maxWidth) : (this.renderingOrder == LegendRenderingOrder.REVERSE ? this.createAllDrawableLinesForItem(g2, legendItems.get(legendItemsLength - i - 1), 0.0, totalHeight, maxWidth) : null);
                Iterator j = drawableParts.iterator();
                while (j.hasNext()) {
                    DrawableLegendItem item = (DrawableLegendItem)j.next();
                    totalHeight += item.getHeight();
                    maxWidth = Math.max(maxWidth, item.getWidth());
                    items.add(item);
                }
            }
            legendArea = new RoundRectangle2D.Float(0.0f, 0.0f, (float)maxWidth, (float)totalHeight, this.boundingBoxArcWidth, this.boundingBoxArcHeight);
            translation = this.createTranslationPointForVerticalDraw(available, inverted, totalHeight, maxWidth);
        }
        g2.translate(translation.getX(), translation.getY());
        this.drawLegendBox(g2, legendArea);
        this.drawLegendTitle(g2, legendTitle);
        this.drawSeriesElements(g2, items, translation, info);
        g2.translate(-translation.getX(), -translation.getY());
        return this.calcRemainingDrawingArea(available, horizontal, inverted, legendArea);
    }

    /*
     * WARNING - void declaration
     */
    private Point2D createTranslationPointForHorizontalDraw(Rectangle2D available, boolean inverted, double maxRowWidth, double totalHeight) {
        void var9_6;
        double xloc;
        double yloc;
        double d = yloc = inverted ? available.getMaxY() - totalHeight - this.getMargin().calculateBottomOutset(available.getHeight()) : available.getY() + this.getMargin().calculateTopOutset(available.getHeight());
        if (this.isAnchoredToLeft()) {
            xloc = available.getX() + this.getMargin().calculateLeftOutset(available.getWidth());
        } else if (this.isAnchoredToCenter()) {
            xloc = available.getX() + available.getWidth() / 2.0 - maxRowWidth / 2.0;
        } else if (this.isAnchoredToRight()) {
            xloc = available.getX() + available.getWidth() - maxRowWidth - this.getChart().getPlot().getInsets().getLeft();
        } else {
            throw new IllegalStateException(UNEXPECTED_LEGEND_ANCHOR);
        }
        return new Point2D.Double((double)var9_6, yloc);
    }

    /*
     * WARNING - void declaration
     */
    private Point2D createTranslationPointForVerticalDraw(Rectangle2D available, boolean inverted, double totalHeight, double maxWidth) {
        void var9_6;
        double yloc;
        double xloc;
        double d = xloc = inverted ? available.getMaxX() - maxWidth - this.getMargin().calculateRightOutset(available.getWidth()) : available.getX() + this.getMargin().calculateLeftOutset(available.getWidth());
        if (this.isAnchoredToTop()) {
            yloc = available.getY() + this.getChart().getPlot().getInsets().getTop();
        } else if (this.isAnchoredToMiddle()) {
            yloc = available.getY() + available.getHeight() / 2.0 - totalHeight / 2.0;
        } else if (this.isAnchoredToBottom()) {
            yloc = available.getY() + available.getHeight() - this.getChart().getPlot().getInsets().getBottom() - totalHeight;
        } else {
            throw new IllegalStateException(UNEXPECTED_LEGEND_ANCHOR);
        }
        return new Point2D.Double(xloc, (double)var9_6);
    }

    private void drawLegendTitle(Graphics2D g2, DrawableLegendItem legendTitle) {
        if (legendTitle != null) {
            g2.setPaint(legendTitle.getItem().getFillPaint());
            g2.setPaint(this.itemPaint);
            g2.setFont(this.getTitleFont());
            TextUtilities.drawAlignedString(legendTitle.getItem().getLabel(), g2, (float)legendTitle.getLabelPosition().getX(), (float)legendTitle.getLabelPosition().getY(), TextAnchor.CENTER_LEFT);
        }
    }

    private void drawLegendBox(Graphics2D g2, RectangularShape legendArea) {
        g2.setPaint(this.backgroundPaint);
        g2.fill(legendArea);
        g2.setPaint(this.outlinePaint);
        g2.setStroke(this.outlineStroke);
        g2.draw(legendArea);
    }

    private void drawSeriesElements(Graphics2D g2, List items, Point2D translation, ChartRenderingInfo info) {
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getEntityCollection();
        }
        for (int i = 0; i < items.size(); ++i) {
            DrawableLegendItem item = (DrawableLegendItem)items.get(i);
            g2.setPaint(item.getItem().getFillPaint());
            Shape keyBox = item.getMarker();
            if (item.getItem().isLineVisible()) {
                g2.setStroke(item.getItem().getLineStroke());
                g2.draw(item.getLine());
                if (item.getItem().isShapeVisible()) {
                    if (item.getItem().isShapeFilled()) {
                        g2.fill(keyBox);
                    } else {
                        g2.draw(keyBox);
                    }
                }
            } else {
                if (item.getItem().isShapeFilled()) {
                    g2.fill(keyBox);
                }
                if (item.getItem().isShapeOutlineVisible()) {
                    g2.setPaint(item.getItem().getOutlinePaint());
                    g2.setStroke(item.getItem().getOutlineStroke());
                    g2.draw(keyBox);
                }
            }
            g2.setPaint(this.itemPaint);
            g2.setFont(this.itemFont);
            TextUtilities.drawAlignedString(item.getItem().getLabel(), g2, (float)item.getLabelPosition().getX(), (float)item.getLabelPosition().getY(), TextAnchor.CENTER_LEFT);
            if (entities == null) continue;
            Rectangle2D.Double area = new Rectangle2D.Double(translation.getX() + item.getX(), translation.getY() + item.getY(), item.getWidth(), item.getHeight());
            LegendItemEntity entity = new LegendItemEntity(area);
            entity.setSeriesIndex(i);
            entities.add(entity);
        }
    }

    private Rectangle2D calcRemainingDrawingArea(Rectangle2D available, boolean horizontal, boolean inverted, RectangularShape legendArea) {
        if (horizontal) {
            double yy = available.getY();
            double yloc = inverted ? yy : yy + legendArea.getHeight() + this.getMargin().calculateBottomOutset(available.getHeight());
            return new Rectangle2D.Double(available.getX(), yloc, available.getWidth(), available.getHeight() - legendArea.getHeight() - this.getMargin().calculateTopOutset(available.getHeight()) - this.getMargin().calculateBottomOutset(available.getHeight()));
        }
        double xloc = inverted ? available.getX() : available.getX() + legendArea.getWidth() + this.getMargin().calculateLeftOutset(available.getWidth()) + this.getMargin().calculateRightOutset(available.getWidth());
        return new Rectangle2D.Double(xloc, available.getY(), available.getWidth() - legendArea.getWidth() - this.getMargin().calculateLeftOutset(available.getWidth()) - this.getMargin().calculateRightOutset(available.getWidth()), available.getHeight());
    }

    private List createAllDrawableLinesForItem(Graphics2D g2, LegendItem legendItem, double x, double y, double wordWrapWidth) {
        ArrayList<DrawableLegendItem> drawableParts = new ArrayList<DrawableLegendItem>();
        DrawableLegendItem line = this.createDrawableLegendItem(g2, legendItem, x, y);
        if (line.getWidth() < wordWrapWidth) {
            drawableParts.add(line);
            return drawableParts;
        }
        boolean firstLine = true;
        double totalHeight = y;
        String prefix = "";
        String suffix = legendItem.getLabel().trim();
        LegendItem tmpItem = new LegendItem(prefix.trim(), legendItem.getLabel(), legendItem.getToolTipText(), legendItem.getURLText(), legendItem.isShapeVisible(), legendItem.getShape(), legendItem.isShapeFilled(), legendItem.getFillPaint(), legendItem.isShapeOutlineVisible(), legendItem.getOutlinePaint(), legendItem.getOutlineStroke(), legendItem.isLineVisible(), legendItem.getLine(), legendItem.getLineStroke(), legendItem.getLinePaint());
        line = this.createDrawableLegendItem(g2, tmpItem, x, totalHeight);
        DrawableLegendItem goodLine = null;
        do {
            String prevSuffix = suffix;
            int spacePos = suffix.indexOf(" ");
            if (spacePos < 0) {
                prefix = prefix + suffix;
                suffix = "";
            } else {
                prefix = prefix + suffix.substring(0, spacePos + 1);
                suffix = suffix.substring(spacePos + 1);
            }
            tmpItem = new LegendItem(prefix.trim(), legendItem.getLabel(), legendItem.getToolTipText(), legendItem.getURLText(), firstLine && legendItem.isShapeVisible(), legendItem.getShape(), firstLine && legendItem.isShapeFilled(), legendItem.getFillPaint(), firstLine && legendItem.isShapeOutlineVisible(), legendItem.getOutlinePaint(), legendItem.getOutlineStroke(), firstLine && legendItem.isLineVisible(), legendItem.getLine(), legendItem.getLineStroke(), legendItem.getLinePaint());
            line = this.createDrawableLegendItem(g2, tmpItem, x, totalHeight);
            if (line.getWidth() < wordWrapWidth) {
                goodLine = line;
                continue;
            }
            if (goodLine == null) {
                drawableParts.add(line);
                totalHeight += line.getHeight();
            } else {
                drawableParts.add(goodLine);
                totalHeight += goodLine.getHeight();
                suffix = prevSuffix;
            }
            firstLine = false;
            prefix = "";
            suffix = suffix.trim();
            line = null;
            goodLine = null;
        } while (!suffix.equals(""));
        if (line != null) {
            drawableParts.add(line);
        }
        return drawableParts;
    }

    private DrawableLegendItem createDrawableLegendItem(Graphics2D graphics, LegendItem legendItem, double x, double y) {
        int insideGap = 2;
        FontMetrics fm = graphics.getFontMetrics();
        LineMetrics lm = fm.getLineMetrics(legendItem.getLabel(), graphics);
        float textAscent = lm.getAscent();
        float lineHeight = textAscent + lm.getDescent() + lm.getLeading();
        DrawableLegendItem item = new DrawableLegendItem(legendItem);
        float xLabelLoc = (float)(x + (double)insideGap + (double)(1.15f * lineHeight));
        float yLabelLoc = (float)(y + (double)insideGap + (double)(0.5f * lineHeight));
        item.setLabelPosition(new Point2D.Float(xLabelLoc, yLabelLoc));
        float width = (float)(item.getLabelPosition().getX() - x + (double)fm.stringWidth(legendItem.getLabel()) + 0.5 * (double)textAscent);
        float height = (float)(2 * insideGap) + lineHeight;
        item.setBounds(x, y, width, height);
        float boxDim = lineHeight * 0.7f;
        float xloc = (float)(x + (double)insideGap + (double)(0.15f * lineHeight));
        float yloc = (float)(y + (double)insideGap + (double)(0.15f * lineHeight));
        if (legendItem.isLineVisible()) {
            Line2D.Float line = new Line2D.Float(xloc, yloc + boxDim / 2.0f, xloc + boxDim * 3.0f, yloc + boxDim / 2.0f);
            item.setLine(line);
            item.setBounds(item.getX(), item.getY(), item.getWidth() + (double)(boxDim * 2.0f), item.getHeight());
            item.setLabelPosition(new Point2D.Float(xLabelLoc + boxDim * 2.0f, yLabelLoc));
            if (item.getItem().isShapeVisible()) {
                Shape marker = legendItem.getShape();
                AffineTransform t1 = AffineTransform.getScaleInstance(this.shapeScaleX, this.shapeScaleY);
                Shape s1 = t1.createTransformedShape(marker);
                AffineTransform transformer = AffineTransform.getTranslateInstance((double)xloc + (double)boxDim * 1.5, yloc + boxDim / 2.0f);
                Shape s2 = transformer.createTransformedShape(s1);
                item.setMarker(s2);
            }
        } else if (item.getItem().isShapeVisible()) {
            Shape marker = legendItem.getShape();
            AffineTransform t1 = AffineTransform.getScaleInstance(this.shapeScaleX, this.shapeScaleY);
            Shape s1 = t1.createTransformedShape(marker);
            AffineTransform transformer = AffineTransform.getTranslateInstance(xloc + boxDim / 2.0f, yloc + boxDim / 2.0f);
            Shape s2 = transformer.createTransformedShape(s1);
            item.setMarker(s2);
        } else {
            item.setMarker(new Rectangle2D.Float(xloc, yloc, boxDim, boxDim));
        }
        return item;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultOldLegend)) {
            return false;
        }
        DefaultOldLegend that = (DefaultOldLegend)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.margin, that.margin)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStroke, that.outlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlinePaint, that.outlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundPaint, that.backgroundPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.padding, that.padding)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.title, that.title)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.titleFont, that.titleFont)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemFont, that.itemFont)) {
            return false;
        }
        return ObjectUtilities.equal(this.itemPaint, that.itemPaint);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writeStroke(this.outlineStroke, stream);
        SerialUtilities.writePaint(this.outlinePaint, stream);
        SerialUtilities.writePaint(this.backgroundPaint, stream);
        SerialUtilities.writePaint(this.itemPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.outlineStroke = SerialUtilities.readStroke(stream);
        this.outlinePaint = SerialUtilities.readPaint(stream);
        this.backgroundPaint = SerialUtilities.readPaint(stream);
        this.itemPaint = SerialUtilities.readPaint(stream);
    }
}

