/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.data.DataUtilities;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class AbstractCategoryItemLabelGenerator
implements PublicCloneable,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7108591260223293197L;
    private String labelFormat;
    private String nullValueString;
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private NumberFormat percentFormat;

    protected AbstractCategoryItemLabelGenerator(String labelFormat, NumberFormat formatter) {
        if (labelFormat == null) {
            throw new IllegalArgumentException("Null 'labelFormat' argument.");
        }
        if (formatter == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.labelFormat = labelFormat;
        this.numberFormat = formatter;
        this.percentFormat = NumberFormat.getPercentInstance();
        this.dateFormat = null;
        this.nullValueString = "-";
    }

    protected AbstractCategoryItemLabelGenerator(String labelFormat, DateFormat formatter) {
        if (labelFormat == null) {
            throw new IllegalArgumentException("Null 'labelFormat' argument.");
        }
        if (formatter == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.labelFormat = labelFormat;
        this.numberFormat = null;
        this.percentFormat = NumberFormat.getPercentInstance();
        this.dateFormat = formatter;
        this.nullValueString = "-";
    }

    public String generateRowLabel(CategoryDataset dataset, int row) {
        return dataset.getRowKey(row).toString();
    }

    public String generateColumnLabel(CategoryDataset dataset, int column) {
        return dataset.getColumnKey(column).toString();
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    protected String generateLabelString(CategoryDataset dataset, int row, int column) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String result2 = null;
        Object[] items = this.createItemArray(dataset, row, column);
        result2 = MessageFormat.format(this.labelFormat, items);
        return result2;
    }

    protected Object[] createItemArray(CategoryDataset dataset, int row, int column) {
        Object[] result2 = new Object[4];
        result2[0] = dataset.getRowKey(row).toString();
        result2[1] = dataset.getColumnKey(column).toString();
        Number value = dataset.getValue(row, column);
        if (value != null) {
            if (this.numberFormat != null) {
                result2[2] = this.numberFormat.format(value);
            } else if (this.dateFormat != null) {
                result2[2] = this.dateFormat.format(value);
            }
        } else {
            result2[2] = this.nullValueString;
        }
        if (value != null) {
            double total = DataUtilities.calculateColumnTotal(dataset, column);
            double percent = value.doubleValue() / total;
            result2[3] = this.percentFormat.format(percent);
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractCategoryItemLabelGenerator)) {
            return false;
        }
        AbstractCategoryItemLabelGenerator that = (AbstractCategoryItemLabelGenerator)obj;
        if (!this.labelFormat.equals(that.labelFormat)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.dateFormat, that.dateFormat)) {
            return false;
        }
        return ObjectUtilities.equal(this.numberFormat, that.numberFormat);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractCategoryItemLabelGenerator clone = (AbstractCategoryItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            clone.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        if (this.dateFormat != null) {
            clone.dateFormat = (DateFormat)this.dateFormat.clone();
        }
        return clone;
    }
}

